/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.factmodel.FieldDefinition;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.core.util.DroolsAssert;
import org.drools.mvel.asm.DefaultBeanClassBuilder;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieTypeResolver;
import org.kie.maven.integration.MavenRepository;
import org.kie.scanner.AbstractKieCiTest;
import org.kie.scanner.KieMavenRepository;
import org.kie.util.maven.support.DependencyFilter;

public class KieModuleMavenTest
extends AbstractKieCiTest {
    @Test
    public void testKieModuleFromMavenNoDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, true, "rule1", "rule2");
        String pomText = this.getPom(releaseId, new ReleaseId[0]);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieMavenRepository.getKieMavenRepository().installArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        ((ObjectAssert)Assertions.assertThat((Object)kbaseModel).as("Default kbase was not found", new Object[0])).isNotNull();
        String kbaseName = kbaseModel.getName();
        Assertions.assertThat((String)kbaseName).isEqualTo("KBase1");
        DroolsAssert.assertUrlEnumerationContainsMatch((String)".*org/kie/maven\\-test/1.0\\-SNAPSHOT.*", kieContainer.getClassLoader().getResources(""));
        DroolsAssert.assertUrlEnumerationContainsMatch((String)".*org/kie/maven\\-test/1.0\\-SNAPSHOT.*", kieContainer.getClassLoader().getResources("KBase1/org/test"));
        DroolsAssert.assertUrlEnumerationContainsMatch((String)".*org/kie/maven\\-test/1.0\\-SNAPSHOT.*", kieContainer.getClassLoader().getResources("KBase1/org/test/"));
    }

    @Test
    public void testKieModuleFromMavenWithDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, true, "rule1", "rule2");
        String pomText = this.getPom(releaseId, this.getTestDependencyJarReleaseId());
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieMavenRepository.getKieMavenRepository().installArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        ((ObjectAssert)Assertions.assertThat((Object)kbaseModel).as("Default kbase was not found", new Object[0])).isNotNull();
        String kbaseName = kbaseModel.getName();
        Assertions.assertThat((String)kbaseName).isEqualTo("KBase1");
    }

    @Test
    public void testKieModuleFromMavenWithTransitiveDependencies() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId dependency = this.getTestDependencyJarReleaseId();
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test", "1.0-SNAPSHOT");
        String pomText = this.getPom(releaseId, dependency);
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, pomText, true, "rule1", "rule2");
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieMavenRepository.getKieMavenRepository().installArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        HashSet<ReleaseId> expectedDependencies = new HashSet<ReleaseId>();
        expectedDependencies.add(dependency);
        expectedDependencies.add(ks.newReleaseId(dependency.getGroupId(), "kie-ci-test-jar", dependency.getVersion()));
        Collection dependencies = ((InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase("KBase1")).getJarDependencies(DependencyFilter.TAKE_ALL_FILTER);
        Assertions.assertThat((Collection)dependencies).isNotNull();
        ClassLoader kieContainerCL = kieContainer.getClassLoader();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(kieContainerCL instanceof KieTypeResolver)).as("Kie Container class loader must be of KieTypeResolver type", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(kieContainerCL.getParent() instanceof KieTypeResolver)).as("Kie Container parent class loader must be of KieTypeResolver type", new Object[0])).isTrue();
        boolean matchedAll = dependencies.containsAll(expectedDependencies);
        Assertions.assertThat((boolean)matchedAll).isTrue();
    }

    @Test
    public void testKieModulePojoDependencies() throws Exception {
        KieServices ks = KieServices.Factory.get();
        String pojoNS = "org.kie.pojos";
        ReleaseId pojoID = KieServices.Factory.get().newReleaseId(pojoNS, "pojojar", "2.0.0");
        String className = "Message";
        ClassDefinition def = new ClassDefinition(pojoNS + "." + className);
        def.addField(new FieldDefinition("text", String.class.getName()));
        byte[] messageClazz = new DefaultBeanClassBuilder(true).buildClass(def, null);
        MemoryFileSystem mfs = new MemoryFileSystem();
        mfs.write(pojoNS.replace('.', '/') + "/" + className + ".class", messageClazz);
        byte[] pomContent = KieModuleMavenTest.generatePomXml(pojoID, new ReleaseId[0]).getBytes();
        mfs.write("META-INF/maven/" + pojoID.getGroupId() + "/" + pojoID.getArtifactId() + "/pom.xml", pomContent);
        mfs.write("META-INF/maven/" + pojoID.getGroupId() + "/" + pojoID.getArtifactId() + "/pom.properties", KieModuleMavenTest.generatePomProperties(pojoID).getBytes());
        byte[] pojojar = mfs.writeAsBytes();
        MavenRepository.getMavenRepository().installArtifact(pojoID, pojojar, pomContent);
        String kjarNS = "org.kie.test1";
        ReleaseId kjarID = KieServices.Factory.get().newReleaseId(kjarNS, "rkjar", "1.0.0");
        String rule = this.getRule(kjarNS, pojoNS, "R1");
        String pom = KieModuleMavenTest.generatePomXml(kjarID, pojoID);
        byte[] rkjar = KieModuleMavenTest.createKJar(ks, kjarID, pom, rule);
        KieModule kmodule = KieModuleMavenTest.deployJar(ks, rkjar);
        Assertions.assertThat((Object)kmodule).isNotNull();
        KieContainer kContainer = ks.newKieContainer(kjarID);
        KieSession kSession = kContainer.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    public void testKieContainerBeforeAndAfterDeployOfSnapshot() throws Exception {
        KieServices ks = KieServices.Factory.get();
        String group = "org.kie.test";
        String artifact = "test-module";
        String version = "1.0.0-SNAPSHOT";
        ReleaseId releaseId = ks.newReleaseId(group, artifact, version);
        String prefix = new File(".").getAbsolutePath().contains("kie-ci") ? "" : "kie-ci/";
        File kjar = new File(prefix + "src/test/resources/kjar/kjar-module-before.jar");
        File pom = new File(prefix + "src/test/resources/kjar/pom-kjar.xml");
        MavenRepository repository = MavenRepository.getMavenRepository();
        repository.installArtifact(releaseId, kjar, pom);
        KieContainer kContainer = ks.newKieContainer(releaseId);
        KieBase kbase = kContainer.getKieBase();
        Assertions.assertThat((Object)kbase).isNotNull();
        Collection packages = kbase.getKiePackages();
        Assertions.assertThat((Collection)packages).isNotNull();
        Assertions.assertThat((int)packages.size()).isEqualTo(1);
        Collection rules = ((KiePackage)packages.iterator().next()).getRules();
        Assertions.assertThat((int)rules.size()).isEqualTo(2);
        ks.getRepository().removeKieModule(releaseId);
        File kjar1 = new File(prefix + "src/test/resources/kjar/kjar-module-after.jar");
        File pom1 = new File(prefix + "src/test/resources/kjar/pom-kjar.xml");
        repository.installArtifact(releaseId, kjar1, pom1);
        KieContainer kContainer2 = ks.newKieContainer(releaseId);
        KieBase kbase2 = kContainer2.getKieBase();
        Assertions.assertThat((Object)kbase2).isNotNull();
        Collection packages2 = kbase2.getKiePackages();
        Assertions.assertThat((Collection)packages2).isNotNull();
        Assertions.assertThat((int)packages2.size()).isEqualTo(1);
        Collection rules2 = ((KiePackage)packages2.iterator().next()).getRules();
        Assertions.assertThat((int)rules2.size()).isEqualTo(4);
        ks.getRepository().removeKieModule(releaseId);
    }

    @Test
    public void testKieModuleFromMavenWithDependenciesProperties() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId dependencyReleaseIdTemplate = this.getTestDependencyJarReleaseId();
        ReleaseId dependency = ks.newReleaseId(dependencyReleaseIdTemplate.getGroupId(), dependencyReleaseIdTemplate.getArtifactId(), "${version.org.drools.test}");
        ReleaseId releaseId = ks.newReleaseId("org.kie.test", "maven-test", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJarWithProperties((KieServices)ks, releaseId, true, dependencyReleaseIdTemplate.getVersion(), new ReleaseId[]{dependency}, "rule1", "rule2");
        String pomText = KieModuleMavenTest.generatePomXmlWithProperties(releaseId, "${project.version}", dependency);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieMavenRepository.getKieMavenRepository().installArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBaseModel kbaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
        ((ObjectAssert)Assertions.assertThat((Object)kbaseModel).as("Default kbase was not found", new Object[0])).isNotNull();
        String kbaseName = kbaseModel.getName();
        Assertions.assertThat((String)kbaseName).isEqualTo("KBase1");
    }

    @Test
    public void testResourceTypeInKieModuleReleaseId() throws Exception {
        KieServicesImpl ks = new KieServicesImpl(){

            public KieRepository getRepository() {
                return new KieRepositoryImpl();
            }
        };
        ReleaseId releaseId = ks.newReleaseId("org.kie", "maven-test.drl", "1.0-SNAPSHOT");
        InternalKieModule kJar1 = this.createKieJar((KieServices)ks, releaseId, true, "rule1", "rule2");
        String pomText = this.getPom(releaseId, new ReleaseId[0]);
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomText.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieMavenRepository.getKieMavenRepository().installArtifact(releaseId, kJar1, pomFile);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        KieBase kieBase = kieContainer.getKieBase("KBase1");
        Assertions.assertThat((Object)kieBase).isNotNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)kieBase.getKiePackages().size()).as("There must be one package built", new Object[0])).isEqualTo(1);
        ClassLoader classLoader = kieContainer.getClassLoader();
        DroolsAssert.assertEnumerationSize((int)1, classLoader.getResources("KBase1/org/test"));
        DroolsAssert.assertEnumerationSize((int)1, classLoader.getResources("META-INF/maven/org.kie/maven-test.drl"));
    }

    public static String generatePomXml(ReleaseId releaseId, ReleaseId ... dependencies) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append("         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append("    <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append("    <groupId>").append(releaseId.getGroupId()).append("</groupId> \n");
        sBuilder.append("    <artifactId>").append(releaseId.getArtifactId()).append("</artifactId> \n");
        sBuilder.append("    <version>").append(releaseId.getVersion()).append("</version> \n");
        sBuilder.append("    <packaging>jar</packaging> \n");
        sBuilder.append("    <name>Default</name> \n");
        if (dependencies.length > 0) {
            sBuilder.append("<dependencies>\n");
            for (ReleaseId dep : dependencies) {
                sBuilder.append("  <dependency>\n");
                sBuilder.append("    <groupId>").append(dep.getGroupId()).append("</groupId> \n");
                sBuilder.append("    <artifactId>").append(dep.getArtifactId()).append("</artifactId> \n");
                sBuilder.append("    <version>").append(dep.getVersion()).append("</version> \n");
                sBuilder.append("  </dependency>\n");
            }
            sBuilder.append("</dependencies>\n");
        }
        sBuilder.append("</project>  \n");
        return sBuilder.toString();
    }

    public static String generatePomXmlWithProperties(ReleaseId releaseId, String dependencyVersion, ReleaseId ... dependencies) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append(" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append(" <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append(" <groupId>").append(releaseId.getGroupId()).append("</groupId> \n");
        sBuilder.append(" <artifactId>").append(releaseId.getArtifactId()).append("</artifactId> \n");
        sBuilder.append(" <version>").append(releaseId.getVersion()).append("</version> \n");
        sBuilder.append(" <packaging>jar</packaging> \n");
        sBuilder.append(" <name>Default</name> \n");
        sBuilder.append(" <properties> \n");
        sBuilder.append(" <version.org.drools.test>" + dependencyVersion + "</version.org.drools.test> \n");
        sBuilder.append(" </properties> \n");
        if (dependencies.length > 0) {
            sBuilder.append("<dependencies>\n");
            for (ReleaseId dep : dependencies) {
                sBuilder.append(" <dependency>\n");
                sBuilder.append(" <groupId>").append(dep.getGroupId()).append("</groupId> \n");
                sBuilder.append(" <artifactId>").append(dep.getArtifactId()).append("</artifactId> \n");
                sBuilder.append(" <version>").append(dep.getVersion()).append("</version> \n");
                sBuilder.append(" </dependency>\n");
            }
            sBuilder.append("</dependencies>\n");
        }
        sBuilder.append("</project> \n");
        return sBuilder.toString();
    }

    protected InternalKieModule createKieJarWithProperties(KieServices ks, ReleaseId releaseId, boolean isdefault, String droolsVersion, ReleaseId[] dependencies, String ... rules) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, isdefault);
        kfs.writePomXML(KieModuleMavenTest.generatePomXmlWithProperties(releaseId, droolsVersion, dependencies));
        for (String rule : rules) {
            String file = "org/test/" + rule + ".drl";
            kfs.write("src/main/resources/KBase1/" + file, this.createDRL(rule));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assertions.assertThat((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty()).isTrue();
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    public static String generatePomProperties(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("version=").append(releaseId.getVersion()).append("\n");
        sBuilder.append("groupId=").append(releaseId.getGroupId()).append("\n");
        sBuilder.append("artifactId=").append(releaseId.getArtifactId()).append("\n");
        return sBuilder.toString();
    }

    public String getRule(String namespace, String messageNS, String ruleName) {
        String s = "package " + namespace + "\nimport " + messageNS + ".Message\nglobal java.util.List list\nrule " + ruleName + " when \nthen \n  Message msg = new Message('hello');\n  list.add(msg);\n end \n";
        return s;
    }
}

