/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.audit;

import com.thoughtworks.xstream.XStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.audit.WorkingMemoryLogger;
import org.drools.core.audit.event.LogEvent;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingMemoryFileLogger
extends WorkingMemoryLogger {
    protected static transient Logger logger = LoggerFactory.getLogger(WorkingMemoryFileLogger.class);
    private List<LogEvent> events = new ArrayList<LogEvent>();
    private String fileName = "event";
    private int maxEventsInMemory = 1000;
    private int nbOfFile = 0;
    private boolean split = true;
    private boolean initialized = false;
    protected boolean terminate = false;

    public WorkingMemoryFileLogger() {
    }

    public WorkingMemoryFileLogger(WorkingMemory workingMemory) {
        super(workingMemory);
    }

    public WorkingMemoryFileLogger(KnowledgeRuntimeEventManager session) {
        super(session);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.events = (List)in.readObject();
        this.fileName = (String)in.readObject();
        this.maxEventsInMemory = in.readInt();
        this.nbOfFile = in.readInt();
        this.split = in.readBoolean();
        this.initialized = in.readBoolean();
        this.terminate = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.events);
        out.writeObject(this.fileName);
        out.writeInt(this.maxEventsInMemory);
        out.writeInt(this.nbOfFile);
        out.writeBoolean(this.split);
        out.writeBoolean(this.initialized);
        out.writeBoolean(this.terminate);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk() {
        if (!this.initialized) {
            this.initializeLog();
        }
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
            XStream xstream = new XStream();
            ArrayList<LogEvent> eventsToWrite = null;
            List<LogEvent> list = this.events;
            synchronized (list) {
                eventsToWrite = new ArrayList<LogEvent>(this.events);
                this.clear();
            }
            for (LogEvent event : eventsToWrite) {
                fileWriter.write(xstream.toXML((Object)event) + "\n");
            }
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            logger.error("error", t);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.terminate) {
            this.closeLog();
            this.terminate = true;
        } else if (this.split) {
            this.closeLog();
            ++this.nbOfFile;
            this.initialized = false;
        }
    }

    private void initializeLog() {
        try {
            FileWriter writer = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), false);
            writer.append("<object-stream>\n");
            writer.close();
            this.initialized = true;
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            logger.error("error", t);
        }
    }

    private void closeLog() {
        try {
            FileWriter writer = new FileWriter(this.fileName + (this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
            writer.append("</object-stream>\n");
            writer.close();
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not close the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            logger.error("error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.clear();
        }
    }

    public void setMaxEventsInMemory(int maxEventsInMemory) {
        this.maxEventsInMemory = maxEventsInMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logEventCreated(LogEvent logEvent) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.add(logEvent);
            if (this.events.size() > this.maxEventsInMemory) {
                this.writeToDisk();
            }
        }
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public void stop() {
        if (this.terminate) {
            throw new IllegalStateException("Logger has already been closed.");
        }
        this.terminate = true;
        this.writeToDisk();
    }
}

