/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.jtms;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.SimpleLogicalDependency;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;

public class JTMSBeliefSet
extends LinkedList
implements BeliefSet {
    private BeliefSystem beliefSystem;
    private WorkingMemoryAction wmAction;
    private InternalFactHandle rootHandle;
    private InternalFactHandle positiveFactHandle;
    private InternalFactHandle negativeFactHandle;
    private int posCounter = 0;
    private int negCounter = 0;

    public JTMSBeliefSet(BeliefSystem beliefSystem, InternalFactHandle rootHandle) {
        this.beliefSystem = beliefSystem;
        this.rootHandle = rootHandle;
    }

    public InternalFactHandle getPositiveFactHandle() {
        return this.positiveFactHandle;
    }

    public void setPositiveFactHandle(InternalFactHandle positiveFactHandle) {
        this.positiveFactHandle = positiveFactHandle;
    }

    public InternalFactHandle getNegativeFactHandle() {
        return this.negativeFactHandle;
    }

    public void setNegativeFactHandle(InternalFactHandle negativeFactHandle) {
        this.negativeFactHandle = negativeFactHandle;
    }

    @Override
    public void add(LinkedListNode node) {
        boolean neg;
        SimpleLogicalDependency ld = (SimpleLogicalDependency)((LinkedListEntry)node).getObject();
        boolean bl = neg = ld.getValue() != null && MODE.NEGATIVE.getId().equals(ld.getValue().toString());
        if (neg) {
            super.addLast(node);
            ++this.negCounter;
        } else {
            super.add(node);
            ld.setValue(MODE.POSITIVE.getId());
            ++this.posCounter;
        }
    }

    @Override
    public void remove(LinkedListNode node) {
        boolean neg;
        super.remove(node);
        LogicalDependency ld = (LogicalDependency)((LinkedListEntry)node).getObject();
        boolean bl = neg = ld.getValue() != null && MODE.NEGATIVE.getId().equals(ld.getValue().toString());
        if (neg) {
            --this.negCounter;
        } else {
            --this.posCounter;
        }
    }

    @Override
    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.rootHandle;
    }

    public boolean isNegated() {
        return this.posCounter == 0 && this.negCounter > 0;
    }

    public boolean isConflicting() {
        return this.posCounter > 0 && this.negCounter > 0;
    }

    public boolean isPositive() {
        return this.negCounter == 0 && this.posCounter > 0;
    }

    @Override
    public void cancel(PropagationContext context) {
        LinkedListEntry entry = (LinkedListEntry)this.getFirst();
        while (entry != this.getLast()) {
            LinkedListEntry temp = (LinkedListEntry)entry.getNext();
            LogicalDependency node = (LogicalDependency)entry.getObject();
            node.getJustifier().getLogicalDependencies().remove(node);
            this.remove(entry);
            entry = temp;
        }
        LinkedListEntry last = (LinkedListEntry)this.getFirst();
        LogicalDependency node = (LogicalDependency)last.getObject();
        node.getJustifier().getLogicalDependencies().remove(node);
        this.beliefSystem.delete(node, this, context);
        this.positiveFactHandle = null;
        this.negativeFactHandle = null;
    }

    @Override
    public void clear(PropagationContext context) {
        LinkedListEntry entry = (LinkedListEntry)this.getFirst();
        while (entry != null) {
            LinkedListEntry temp = (LinkedListEntry)entry.getNext();
            LogicalDependency node = (LogicalDependency)entry.getObject();
            node.getJustifier().getLogicalDependencies().remove(node);
            this.remove(entry);
            entry = temp;
        }
    }

    @Override
    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
        this.wmAction = wmAction;
    }

    public WorkingMemoryAction getWorkingMemoryAction() {
        return this.wmAction;
    }

    public static enum MODE {
        POSITIVE("pos"),
        NEGATIVE("neg");

        private String string;

        private MODE(String string2) {
            this.string = string2;
        }

        public String toExternalForm() {
            return this.string;
        }

        public String toString() {
            return this.string;
        }

        public String getId() {
            return this.string;
        }

        public static MODE resolve(Object id) {
            if (id == null) {
                return null;
            }
            if (NEGATIVE == id || NEGATIVE.getId().equalsIgnoreCase(id.toString())) {
                return NEGATIVE;
            }
            if (POSITIVE == id || POSITIVE.getId().equalsIgnoreCase(id.toString())) {
                return POSITIVE;
            }
            return null;
        }
    }
}

