/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetObjectsCommand
implements GenericCommand<Collection>,
IdentifiableResult {
    private ObjectFilter filter = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public GetObjectsCommand() {
    }

    public GetObjectsCommand(ObjectFilter filter) {
        this.filter = filter;
    }

    public GetObjectsCommand(ObjectFilter filter, String outIdentifier) {
        this.filter = filter;
        this.outIdentifier = outIdentifier;
    }

    @Override
    public Collection execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        Collection col = null;
        col = this.filter != null ? ksession.getObjects(this.filter) : ksession.getObjects();
        if (this.outIdentifier != null) {
            ArrayList objects = new ArrayList(col);
            ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult().getResults().put(this.outIdentifier, objects);
        }
        return col;
    }

    public Collection<? extends Object> getObjects(ReteooWorkingMemory session) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(session.getObjectStore(), null, 0);
    }

    public Collection<? extends Object> getObjects(ReteooWorkingMemory session, ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(session.getObjectStore(), filter, 0);
    }

    public String toString() {
        if (this.filter != null) {
            return "session.iterateObjects( " + this.filter + " );";
        }
        return "session.iterateObjects();";
    }
}

