/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.command.impl.ContextImpl;
import org.drools.core.command.impl.FixedKnowledgeCommandContext;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.event.AgendaEventSupport;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.event.WorkingMemoryEventSupport;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.rule.EntryPoint;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.agent.KnowledgeAgent;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class StatelessKnowledgeSessionImpl
implements StatelessKnowledgeSession,
StatelessKieSession {
    private InternalRuleBase ruleBase;
    private KnowledgeAgent kagent;
    private MapGlobalResolver sessionGlobals = new MapGlobalResolver();
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    public Map<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper> mappedWorkingMemoryListeners;
    public Map<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper> mappedAgendaListeners;
    public AgendaEventSupport agendaEventSupport = new AgendaEventSupport();
    public WorkingMemoryEventSupport workingMemoryEventSupport = new WorkingMemoryEventSupport();
    public ProcessEventSupport processEventSupport = new ProcessEventSupport();
    private boolean initialized;
    private KieSessionConfiguration conf;
    private Environment environment;

    public StatelessKnowledgeSessionImpl() {
    }

    public StatelessKnowledgeSessionImpl(InternalRuleBase ruleBase, KnowledgeAgent kagent, KieSessionConfiguration conf) {
        this.ruleBase = ruleBase;
        this.kagent = kagent;
        this.conf = conf != null ? conf : SessionConfiguration.getDefaultInstance();
        this.environment = EnvironmentFactory.newEnvironment();
    }

    public InternalRuleBase getRuleBase() {
        if (this.kagent != null) {
            this.ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kagent.getKnowledgeBase()).ruleBase;
        }
        return this.ruleBase;
    }

    public KnowledgeAgent getKnowledgeAgent() {
        return this.kagent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulKnowledgeSession newWorkingMemory() {
        if (this.kagent != null) {
            this.ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kagent.getKnowledgeBase()).ruleBase;
        }
        this.ruleBase.readLock();
        try {
            InternalProcessRuntime processRuntime;
            ReteooWorkingMemory wm = new ReteooWorkingMemory(this.ruleBase.nextWorkingMemoryCounter(), this.ruleBase, (SessionConfiguration)this.conf, this.environment);
            StatefulKnowledgeSessionImpl ksession = new StatefulKnowledgeSessionImpl(wm, new KnowledgeBaseImpl(this.ruleBase));
            ((Globals)wm.getGlobalResolver()).setDelegate((Globals)this.sessionGlobals);
            if (!this.initialized) {
                for (EventListener listener : wm.getAgendaEventSupport().getEventListeners()) {
                    this.agendaEventSupport.addEventListener(listener);
                }
                for (EventListener listener : wm.getWorkingMemoryEventSupport().getEventListeners()) {
                    this.workingMemoryEventSupport.addEventListener(listener);
                }
                processRuntime = wm.getProcessRuntime();
                if (processRuntime != null) {
                    for (ProcessEventListener listener : processRuntime.getProcessEventListeners()) {
                        this.processEventSupport.addEventListener(listener);
                    }
                }
                this.initialized = true;
            }
            wm.setAgendaEventSupport(this.agendaEventSupport);
            wm.setWorkingMemoryEventSupport(this.workingMemoryEventSupport);
            processRuntime = wm.getProcessRuntime();
            if (processRuntime != null) {
                processRuntime.setProcessEventSupport(this.processEventSupport);
            }
            for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
                wm.registerChannel(entry.getKey(), entry.getValue());
            }
            InternalFactHandle handle = wm.getFactHandleFactory().newFactHandle(InitialFactImpl.getInstance(), wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(EntryPoint.DEFAULT, InitialFactImpl.getInstance()), wm, wm);
            wm.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(handle, false, true, null, null));
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = ksession;
            return statefulKnowledgeSessionImpl;
        }
        finally {
            this.ruleBase.readUnlock();
        }
    }

    public void addEventListener(AgendaEventListener listener) {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper wrapper = new StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper(listener);
        this.mappedAgendaListeners.put(listener, wrapper);
        this.agendaEventSupport.addEventListener(wrapper);
    }

    public Collection<AgendaEventListener> getAgendaEventListeners() {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper>();
        }
        return Collections.unmodifiableCollection(this.mappedAgendaListeners.keySet());
    }

    public void removeEventListener(AgendaEventListener listener) {
        if (this.mappedAgendaListeners == null) {
            this.mappedAgendaListeners = new IdentityHashMap<AgendaEventListener, StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.AgendaEventListenerWrapper wrapper = this.mappedAgendaListeners.remove(listener);
        this.agendaEventSupport.removeEventListener(wrapper);
    }

    public void addEventListener(WorkingMemoryEventListener listener) {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper wrapper = new StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper(listener);
        this.mappedWorkingMemoryListeners.put(listener, wrapper);
        this.workingMemoryEventSupport.addEventListener(wrapper);
    }

    public void removeEventListener(WorkingMemoryEventListener listener) {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper>();
        }
        StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper wrapper = this.mappedWorkingMemoryListeners.remove(listener);
        this.workingMemoryEventSupport.removeEventListener(wrapper);
    }

    public Collection<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        if (this.mappedWorkingMemoryListeners == null) {
            this.mappedWorkingMemoryListeners = new IdentityHashMap<WorkingMemoryEventListener, StatefulKnowledgeSessionImpl.WorkingMemoryEventListenerWrapper>();
        }
        return Collections.unmodifiableCollection(this.mappedWorkingMemoryListeners.keySet());
    }

    public void addEventListener(ProcessEventListener listener) {
        this.processEventSupport.addEventListener(listener);
    }

    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.processEventSupport.getEventListeners();
    }

    public void removeEventListener(ProcessEventListener listener) {
        this.processEventSupport.removeEventListener(listener);
    }

    public void setGlobal(String identifier, Object value) {
        this.sessionGlobals.setGlobal(identifier, value);
    }

    public Globals getGlobals() {
        return this.sessionGlobals;
    }

    public void registerChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    public void unregisterChannel(String name) {
        this.channels.remove(name);
    }

    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Command<T> command) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        FixedKnowledgeCommandContext context = new FixedKnowledgeCommandContext(new ContextImpl("ksession", null), null, null, (KieSession)ksession, null);
        try {
            ((StatefulKnowledgeSessionImpl)ksession).session.startBatchExecution(new ExecutionResultImpl());
            Object o = ((GenericCommand)command).execute(context);
            boolean autoFireAllRules = true;
            if (command instanceof FireAllRulesCommand) {
                autoFireAllRules = false;
            } else if (command instanceof BatchExecutionCommandImpl) {
                for (GenericCommand<?> nestedCmd : ((BatchExecutionCommandImpl)command).getCommands()) {
                    if (!(nestedCmd instanceof FireAllRulesCommand)) continue;
                    autoFireAllRules = false;
                    break;
                }
            }
            if (autoFireAllRules) {
                ksession.fireAllRules();
            }
            if (command instanceof BatchExecutionCommandImpl) {
                ExecutionResultImpl result;
                ExecutionResultImpl executionResultImpl = result = ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult();
                return (T)executionResultImpl;
            }
            Object t = o;
            return t;
        }
        finally {
            ((StatefulKnowledgeSessionImpl)ksession).session.endBatchExecution();
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object object) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            ksession.insert(object);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Iterable objects) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            for (Object object : objects) {
                ksession.insert(object);
            }
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

