/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import org.drools.core.QueryResults;
import org.drools.core.StatelessSessionResult;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ObjectStore;
import org.drools.core.spi.GlobalResolver;
import org.kie.api.runtime.ObjectFilter;

public class ReteStatelessSessionResult
implements StatelessSessionResult,
Externalizable {
    private transient InternalWorkingMemory workingMemory;
    private ObjectStore objectStore;
    private GlobalResolver globalResolver;

    public ReteStatelessSessionResult() {
    }

    public ReteStatelessSessionResult(InternalWorkingMemory workingMemory, GlobalResolver globalResolver) {
        this.workingMemory = workingMemory;
        this.objectStore = workingMemory.getObjectStore();
        this.globalResolver = globalResolver;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.objectStore = (ObjectStore)in.readObject();
        this.globalResolver = (GlobalResolver)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.objectStore);
        out.writeObject(this.globalResolver);
    }

    @Override
    public QueryResults getQueryResults(String query) {
        return this.workingMemory.getQueryResults(query, new Object[0]);
    }

    @Override
    public QueryResults getQueryResults(String query, Object[] arguments) {
        return this.workingMemory.getQueryResults(query, arguments);
    }

    @Override
    public Iterator iterateObjects() {
        return this.objectStore.iterateObjects();
    }

    @Override
    public Iterator iterateObjects(ObjectFilter filter) {
        return this.objectStore.iterateObjects(filter);
    }

    @Override
    public Object getGlobal(String identifier) {
        if (this.globalResolver == null) {
            return null;
        }
        return this.globalResolver.resolveGlobal(identifier);
    }

    @Override
    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }
}

