/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.FactException;
import org.drools.core.FactHandle;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.StatefulSession;
import org.drools.core.StatelessSession;
import org.drools.core.common.AbstractRuleBase;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.DroolsObjectInput;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.event.RuleBaseEventListener;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooComponentFactory;
import org.drools.core.reteoo.ReteooFactHandleFactory;
import org.drools.core.reteoo.ReteooStatefulSession;
import org.drools.core.reteoo.ReteooStatelessSession;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.rule.EntryPoint;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.kie.api.KieBase;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.marshalling.MarshallerFactory;

public class ReteooRuleBase
extends AbstractRuleBase {
    private static final long serialVersionUID = 510L;
    private transient Rete rete;
    private ReteooBuilder reteooBuilder;
    public Set<EntryPointNode> addedEntryNodeCache;
    public Set<EntryPointNode> removedEntryNodeCache;
    private transient Map<Integer, SegmentMemory.Prototype> segmentProtos = new ConcurrentHashMap<Integer, SegmentMemory.Prototype>();

    public ReteooRuleBase() {
    }

    public ReteooRuleBase(String id) {
        this(id, null, new ReteooFactHandleFactory());
    }

    public ReteooRuleBase(String id, FactHandleFactory factHandleFactory) {
        this(id, null, factHandleFactory);
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config) {
        this(id, config, config != null ? config.getComponentFactory().getFactHandleFactoryService() : ReteooComponentFactory.getDefaultHandleFactoryProvider());
    }

    public ReteooRuleBase(RuleBaseConfiguration config) {
        this(null, config, config != null ? config.getComponentFactory().getFactHandleFactoryService() : ReteooComponentFactory.getDefaultHandleFactoryProvider());
    }

    public ReteooRuleBase(String id, RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        super(id, config, factHandleFactory);
        this.setupRete();
        if (config != null && config.isMBeansEnabled()) {
            DroolsManagementAgent.getInstance().registerKnowledgeBase(this);
        }
    }

    private void setupRete() {
        this.rete = new Rete(this);
        this.reteooBuilder = new ReteooBuilder(this);
        EntryPointNode epn = new EntryPointNode(this.reteooBuilder.getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, this.getConfiguration().isMultithreadEvaluation(), (ObjectSource)this.rete, EntryPoint.DEFAULT);
        epn.attach();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        DroolsObjectOutputStream droolsStream;
        boolean isDrools = stream instanceof DroolsObjectOutputStream;
        ByteArrayOutputStream bytes = null;
        stream.writeBoolean(isDrools);
        if (isDrools) {
            droolsStream = (DroolsObjectOutputStream)stream;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        super.writeExternal(droolsStream);
        droolsStream.writeObject(this.reteooBuilder);
        droolsStream.writeObject(this.rete);
        if (!isDrools) {
            droolsStream.flush();
            droolsStream.close();
            bytes.close();
            stream.writeObject(bytes.toByteArray());
        }
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        DroolsObjectInput droolsStream;
        boolean isDrools = stream instanceof DroolsObjectInputStream;
        boolean wasDrools = stream.readBoolean();
        if (wasDrools && !isDrools) {
            throw new IllegalArgumentException("The knowledge base was serialized using a DroolsObjectOutputStream. A DroolsObjectInputStream is required for deserialization.");
        }
        if (wasDrools) {
            droolsStream = (DroolsObjectInput)stream;
        } else {
            ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])stream.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        super.readExternal(droolsStream);
        this.reteooBuilder = (ReteooBuilder)droolsStream.readObject();
        this.reteooBuilder.setRuleBase(this);
        this.rete = (Rete)droolsStream.readObject();
        if (!wasDrools) {
            droolsStream.close();
        }
    }

    @Override
    public void registerAddedEntryNodeCache(EntryPointNode node) {
        if (this.addedEntryNodeCache == null) {
            this.addedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.addedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getAddedEntryNodeCache() {
        return this.addedEntryNodeCache;
    }

    @Override
    public void registeRremovedEntryNodeCache(EntryPointNode node) {
        if (this.removedEntryNodeCache == null) {
            this.removedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.removedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getRemovedEntryNodeCache() {
        return this.removedEntryNodeCache;
    }

    @Override
    public Rete getRete() {
        return this.rete;
    }

    @Override
    public ReteooBuilder getReteooBuilder() {
        return this.reteooBuilder;
    }

    @Override
    public void assertObject(FactHandle handle, Object object, PropagationContext context, InternalWorkingMemory workingMemory) throws FactException {
        this.getRete().assertObject((DefaultFactHandle)handle, context, workingMemory);
    }

    @Override
    public void retractObject(FactHandle handle, PropagationContext context, ReteooWorkingMemory workingMemory) throws FactException {
        this.getRete().retractObject((InternalFactHandle)handle, context, workingMemory);
    }

    @Override
    public StatefulSession newStatefulSession(boolean keepReference) {
        SessionConfiguration config = new SessionConfiguration();
        config.setKeepReference(keepReference);
        return this.newStatefulSession(config, EnvironmentFactory.newEnvironment());
    }

    @Override
    public StatefulSession newStatefulSession(InputStream stream) {
        return this.newStatefulSession(stream, true);
    }

    @Override
    public StatefulSession newStatefulSession(InputStream stream, boolean keepReference) {
        return this.newStatefulSession(stream, keepReference, SessionConfiguration.getDefaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulSession newStatefulSession(InputStream stream, boolean keepReference, SessionConfiguration conf) {
        StatefulSession session = null;
        try {
            this.readLock();
            try {
                ObjectInputStream ois = new ObjectInputStream(stream);
                ReteooStatefulSession rsession = (ReteooStatefulSession)ois.readObject();
                ByteArrayInputStream bais = new ByteArrayInputStream(rsession.bytes);
                Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)new KnowledgeBaseImpl(this), (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()});
                Environment environment = EnvironmentFactory.newEnvironment();
                KieSession ksession = marshaller.unmarshall((InputStream)bais, (KieSessionConfiguration)conf, environment);
                session = (StatefulSession)((Object)((StatefulKnowledgeSessionImpl)ksession).session);
                if (keepReference) {
                    super.addStatefulSession(session);
                    for (Object listener : session.getRuleBaseUpdateListeners()) {
                        this.addEventListener((RuleBaseEventListener)listener);
                    }
                }
                bais.close();
            }
            finally {
                this.readUnlock();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unmarshall session", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close stream", e);
            }
        }
        return session;
    }

    @Override
    public StatefulSession newStatefulSession(SessionConfiguration sessionConfig, Environment environment) {
        if (sessionConfig == null) {
            sessionConfig = SessionConfiguration.getDefaultInstance();
        }
        if (environment == null) {
            environment = EnvironmentFactory.newEnvironment();
        }
        return this.newStatefulSession(this.nextWorkingMemoryCounter(), sessionConfig, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatefulSession newStatefulSession(int id, SessionConfiguration sessionConfig, Environment environment) {
        if (this.getConfiguration().isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        this.readLock();
        try {
            ReteooStatefulSession session = new ReteooStatefulSession(id, this, sessionConfig, environment);
            new StatefulKnowledgeSessionImpl(session);
            if (sessionConfig.isKeepReference()) {
                super.addStatefulSession(session);
                for (Object listener : session.getRuleBaseUpdateListeners()) {
                    this.addEventListener((RuleBaseEventListener)listener);
                }
            }
            session.queueWorkingMemoryAction(new ReteooWorkingMemory.WorkingMemoryReteAssertAction(session.getInitialFactHandle(), false, true, null, null));
            ReteooStatefulSession reteooStatefulSession = session;
            return reteooStatefulSession;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatelessSession newStatelessSession() {
        Map map = this.pkgs;
        synchronized (map) {
            return new ReteooStatelessSession(this);
        }
    }

    @Override
    protected void addRule(Rule rule) throws InvalidPatternException {
        this.reteooBuilder.addRule(rule);
    }

    @Override
    protected void addEntryPoint(String id) throws InvalidPatternException {
        this.reteooBuilder.addEntryPoint(id);
    }

    @Override
    protected void addWindowDeclaration(WindowDeclaration window) throws InvalidPatternException {
        this.reteooBuilder.addNamedWindow(window);
    }

    @Override
    protected void removeRule(Rule rule) {
        this.reteooBuilder.removeRule(rule);
    }

    @Override
    public int getNodeCount() {
        return this.reteooBuilder.getIdGenerator().getLastId() + 1;
    }

    @Override
    public void addPackages(Package[] pkgs) {
        this.addPackages(Arrays.asList(pkgs));
    }

    @Override
    public void addPackages(Collection<Package> pkgs) {
        super.addPackages(pkgs);
    }

    @Override
    public void addPackage(Package newPkg) {
        this.addPackages(Collections.singleton(newPkg));
    }

    @Override
    protected void updateDependentTypes(Package newPkg, TypeDeclaration typeDeclaration) {
        if (this.getConfiguration().getEventProcessingMode().equals((Object)EventProcessingOption.STREAM)) {
            long exp = typeDeclaration.getExpirationOffset() > -1L ? typeDeclaration.getExpirationOffset() + 1L : -1L;
            for (EntryPointNode ep : this.rete.getEntryPointNodes().values()) {
                for (ObjectTypeNode node : ep.getObjectTypeNodes().values()) {
                    if (!node.isAssignableFrom(typeDeclaration.getObjectType())) continue;
                    node.setExpirationOffset(Math.max(node.getExpirationOffset(), exp));
                }
            }
        }
    }

    public void registerSegmentPrototype(LeftTupleSource tupleSource, SegmentMemory smem) {
        this.segmentProtos.put(tupleSource.getId(), smem.asPrototype());
    }

    public void invalidateSegmentPrototype(LeftTupleSource tupleSource) {
        this.segmentProtos.remove(tupleSource.getId());
        LeftTupleSinkPropagator sinkProp = tupleSource.getSinkPropagator();
        for (LeftTupleSinkNode sink = sinkProp.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!(sink instanceof LeftTupleSource)) continue;
            this.invalidateSegmentPrototype((LeftTupleSource)((Object)sink));
        }
    }

    public SegmentMemory getSegmentFromPrototype(InternalWorkingMemory wm, LeftTupleSource tupleSource) {
        SegmentMemory.Prototype proto = this.segmentProtos.get(tupleSource.getId());
        if (proto == null) {
            return null;
        }
        return proto.newSegmentMemory(wm);
    }
}

