/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.UUID;
import org.drools.core.util.StringUtils;

public class FileManager {
    private File root;

    public FileManager setUp() {
        this.root = this.getRootDirectory();
        return this;
    }

    public void tearDown() {
        this.deleteDir(this.root);
    }

    public File newFile(String name) {
        File file = new File(this.getRootDirectory(), name);
        return file;
    }

    private File newFile(String path, String fileName) {
        File file = new File(this.getRootDirectory(), path);
        file.mkdir();
        return new File(file, fileName);
    }

    public File newFile(File dir, String name) {
        File file = new File(dir, name);
        return file;
    }

    public File getRootDirectory() {
        if (this.root != null) {
            return this.root;
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(tmp, "__drools__" + UUID.randomUUID().toString());
        if (f.exists()) {
            if (f.isFile()) {
                throw new IllegalStateException("The temp directory exists as a file. Nuke it now !");
            }
            this.deleteDir(f);
            f.mkdir();
        } else {
            f.mkdir();
        }
        this.root = f;
        return this.root;
    }

    public void deleteDir(File dir) {
        String[] children;
        for (String child : children = dir.list()) {
            File file = new File(dir, child);
            if (file.isFile()) {
                this.deleteFile(file);
                continue;
            }
            this.deleteDir(file);
        }
        this.deleteFile(dir);
    }

    public void deleteFile(File file) {
        if (!file.delete()) {
            int count = 0;
            while (!file.delete() && count++ < 5) {
                System.gc();
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("This should never happen");
                }
            }
        }
        if (file.exists()) {
            try {
                throw new RuntimeException("Unable to delete file:" + file.getCanonicalPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to delete file", e);
            }
        }
    }

    public void write(File f, String text) throws IOException {
        int count;
        if (f.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to sleep");
            }
        } else {
            new File(f.getParent()).mkdirs();
        }
        BufferedWriter output = new BufferedWriter(new FileWriter(f));
        output.write(text);
        output.close();
        String t1 = StringUtils.toString(new StringReader(text));
        for (count = 0; !t1.equals(StringUtils.toString(new BufferedReader(new FileReader(f)))) && count < 5; ++count) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("This should never happen");
            }
            output = new BufferedWriter(new FileWriter(f));
            output.write(text);
            output.close();
        }
        if (count == 5) {
            throw new IOException("Unable to write to file:" + f.getCanonicalPath());
        }
    }

    public static void write(File f, byte[] data) throws IOException {
        int count;
        if (f.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to sleep");
            }
        }
        FileManager.writeBytes(f, data);
        for (count = 0; !FileManager.areByteArraysEqual(data, FileManager.readBytes(f)) && count < 5; ++count) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("This should never happen");
            }
            FileManager.writeBytes(f, data);
        }
        if (count == 5) {
            throw new IOException("Unable to write to file:" + f.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(File f) throws IOException {
        byte[] buf = new byte[1024];
        BufferedInputStream bais = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            bais = new BufferedInputStream(new FileInputStream(f));
            baos = new ByteArrayOutputStream();
            while ((len = bais.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(File f, byte[] data) throws IOException {
        byte[] buf = new byte[1024];
        FilterOutputStream bos = null;
        ByteArrayInputStream bais = null;
        try {
            int len;
            bos = new BufferedOutputStream(new FileOutputStream(f));
            bais = new ByteArrayInputStream(data);
            while ((len = bais.read(buf)) > 0) {
                ((BufferedOutputStream)bos).write(buf, 0, len);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public File write(String fileName, String text) throws IOException {
        File f = this.newFile(fileName);
        this.write(f, text);
        return f;
    }

    public File write(String path, String fileName, String text) throws IOException {
        File f = this.newFile(path, fileName);
        this.write(f, text);
        return f;
    }

    public String readInputStreamReaderAsString(InputStreamReader in) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(in);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public static boolean areByteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int length = b1.length;
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

