/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;
import org.kie.scanner.ArtifactResolver;
import org.kie.scanner.DependencyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

public class KieRepositoryScannerImpl
implements InternalKieScanner {
    private Timer timer;
    private static final Logger log = LoggerFactory.getLogger(KieScanner.class);
    private KieContainer kieContainer;
    private final Set<DependencyDescriptor> usedDependencies = new HashSet<DependencyDescriptor>();
    private ArtifactResolver artifactResolver;

    public void setKieContainer(KieContainer kieContainer) {
        this.kieContainer = kieContainer;
        ReleaseId releaseId = kieContainer.getReleaseId();
        if (releaseId == null) {
            throw new RuntimeException("The KieContainer's ReleaseId cannot be null. Are you using a KieClasspathContainer?");
        }
        DependencyDescriptor projectDescr = new DependencyDescriptor(releaseId);
        if (!projectDescr.isFixedVersion()) {
            this.usedDependencies.add(projectDescr);
        }
        this.artifactResolver = ArtifactResolver.getResolverFor(kieContainer.getReleaseId(), true);
        this.init();
    }

    private ArtifactResolver getArtifactResolver() {
        if (this.artifactResolver == null) {
            this.artifactResolver = new ArtifactResolver();
        }
        return this.artifactResolver;
    }

    private void init() {
        Collection<Artifact> artifacts = this.findKJarAtifacts();
        log.info("Artifacts containing a kjar: " + artifacts);
        if (artifacts.isEmpty()) {
            log.info("There's no artifacts containing a kjar: shutdown the scanner");
            return;
        }
        this.indexAtifacts(artifacts);
    }

    public KieModule loadArtifact(ReleaseId releaseId) {
        return this.loadArtifact(releaseId, null);
    }

    public KieModule loadArtifact(ReleaseId releaseId, InputStream pomXml) {
        String artifactName = releaseId.toString();
        ArtifactResolver resolver = pomXml != null ? ArtifactResolver.getResolverFor(pomXml) : this.getArtifactResolver();
        Artifact artifact = resolver.resolveArtifact(artifactName);
        return artifact != null ? this.buildArtifact(releaseId, artifact, resolver) : this.loadPomArtifact(releaseId);
    }

    public String getArtifactVersion(ReleaseId releaseId) {
        if (!releaseId.isSnapshot()) {
            return releaseId.getVersion();
        }
        Artifact artifact = this.getArtifactResolver().resolveArtifact(releaseId.toString());
        return artifact != null ? artifact.getVersion() : null;
    }

    private KieModule loadPomArtifact(ReleaseId releaseId) {
        ArtifactResolver resolver = ArtifactResolver.getResolverFor(releaseId, false);
        if (resolver == null) {
            return null;
        }
        MemoryKieModule kieModule = new MemoryKieModule(releaseId);
        this.addDependencies((InternalKieModule)kieModule, resolver, resolver.getPomDirectDependencies());
        this.build((InternalKieModule)kieModule);
        return kieModule;
    }

    private InternalKieModule buildArtifact(ReleaseId releaseId, Artifact artifact, ArtifactResolver resolver) {
        ZipKieModule kieModule;
        if (releaseId.isSnapshot()) {
            ((ReleaseIdImpl)releaseId).setSnapshotVersion(artifact.getVersion());
        }
        if ((kieModule = KieRepositoryScannerImpl.createZipKieModule(releaseId, artifact.getFile())) != null) {
            this.addDependencies((InternalKieModule)kieModule, resolver, resolver.getArtifactDependecies(new DependencyDescriptor(artifact).toString()));
            this.build((InternalKieModule)kieModule);
        }
        return kieModule;
    }

    private void addDependencies(InternalKieModule kieModule, ArtifactResolver resolver, List<DependencyDescriptor> dependencies) {
        for (DependencyDescriptor dep : dependencies) {
            ReleaseId depReleaseId;
            ZipKieModule zipKieModule;
            Artifact depArtifact = resolver.resolveArtifact(dep.toString());
            if (!this.isKJar(depArtifact.getFile()) || (zipKieModule = KieRepositoryScannerImpl.createZipKieModule(depReleaseId = new DependencyDescriptor(depArtifact).getGav(), depArtifact.getFile())) == null) continue;
            kieModule.addKieDependency((InternalKieModule)zipKieModule);
        }
    }

    private static ZipKieModule createZipKieModule(ReleaseId releaseId, File jar) {
        KieModuleModel kieModuleModel = KieRepositoryScannerImpl.getKieModuleModelFromJar(jar);
        return kieModuleModel != null ? new ZipKieModule(releaseId, kieModuleModel, jar) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KieModuleModel getKieModuleModelFromJar(File jar) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jar);
            ZipEntry zipEntry = zipFile.getEntry(KieModuleModelImpl.KMODULE_JAR_PATH);
            KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
            KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
            KieModuleModel kieModuleModel2 = kieModuleModel;
            return kieModuleModel2;
        }
        catch (Exception e) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private ResultsImpl build(InternalKieModule kieModule) {
        ResultsImpl messages = new ResultsImpl();
        KieBuilderImpl.buildKieModule((InternalKieModule)kieModule, (ResultsImpl)messages);
        return messages;
    }

    public void start(long pollingInterval) {
        if (pollingInterval <= 0L) {
            throw new IllegalArgumentException("pollingInterval must be positive");
        }
        if (this.timer != null) {
            throw new IllegalStateException("The scanner is already running");
        }
        this.startScanTask(pollingInterval);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void startScanTask(long pollingInterval) {
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new ScanTask(), pollingInterval, pollingInterval);
    }

    public void scanNow() {
        Collection<Artifact> updatedArtifacts = this.scanForUpdates(this.usedDependencies);
        if (updatedArtifacts.isEmpty()) {
            return;
        }
        for (Artifact artifact : updatedArtifacts) {
            DependencyDescriptor depDescr = new DependencyDescriptor(artifact);
            this.usedDependencies.remove(depDescr);
            this.usedDependencies.add(depDescr);
            this.updateKieModule(artifact, depDescr.getGav());
        }
        log.info("The following artifacts have been updated: " + updatedArtifacts);
    }

    private void updateKieModule(Artifact artifact, ReleaseId releaseId) {
        ZipKieModule kieModule = KieRepositoryScannerImpl.createZipKieModule(releaseId, artifact.getFile());
        if (kieModule != null) {
            ResultsImpl messages = this.build((InternalKieModule)kieModule);
            if (messages.filterMessages(new Message.Level[]{Message.Level.ERROR}).isEmpty()) {
                this.kieContainer.updateToVersion(releaseId);
            }
        }
    }

    private Collection<Artifact> scanForUpdates(Collection<DependencyDescriptor> dependencies) {
        ArrayList<Artifact> newArtifacts = new ArrayList<Artifact>();
        for (DependencyDescriptor dependency : dependencies) {
            DependencyDescriptor resolvedDep;
            Artifact newArtifact = this.getArtifactResolver().resolveArtifact(dependency.toResolvableString());
            if (newArtifact == null || !(resolvedDep = new DependencyDescriptor(newArtifact)).isNewerThan(dependency)) continue;
            newArtifacts.add(newArtifact);
        }
        return newArtifacts;
    }

    private void indexAtifacts(Collection<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.usedDependencies.add(new DependencyDescriptor(artifact));
        }
    }

    private Collection<Artifact> findKJarAtifacts() {
        Collection<DependencyDescriptor> deps = this.getArtifactResolver().getAllDependecies();
        deps = this.filterNonFixedDependecies(deps);
        List<Artifact> artifacts = this.resolveArtifacts(deps);
        return this.filterKJarArtifacts(artifacts);
    }

    private Collection<DependencyDescriptor> filterNonFixedDependecies(Collection<DependencyDescriptor> dependencies) {
        ArrayList<DependencyDescriptor> nonFixedDeps = new ArrayList<DependencyDescriptor>();
        for (DependencyDescriptor dep : dependencies) {
            if (dep.isFixedVersion()) continue;
            nonFixedDeps.add(dep);
        }
        return nonFixedDeps;
    }

    private List<Artifact> resolveArtifacts(Collection<DependencyDescriptor> dependencies) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (DependencyDescriptor dep : dependencies) {
            Artifact artifact = this.getArtifactResolver().resolveArtifact(dep.toString());
            artifacts.add(artifact);
            log.debug(artifact + " resolved to  " + artifact.getFile());
        }
        return artifacts;
    }

    private Collection<Artifact> filterKJarArtifacts(Collection<Artifact> artifacts) {
        ArrayList<Artifact> kJarArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.isKJar(artifact.getFile())) continue;
            kJarArtifacts.add(artifact);
        }
        return kJarArtifacts;
    }

    private boolean isKJar(File jar) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(jar);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ZipEntry zipEntry = zipFile.getEntry(KieModuleModelImpl.KMODULE_JAR_PATH);
        return zipEntry != null;
    }

    private class ScanTask
    extends TimerTask {
        private ScanTask() {
        }

        @Override
        public void run() {
            KieRepositoryScannerImpl.this.scanNow();
        }
    }
}

