/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.backend.file;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.shared.file.DeleteService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceDeletedEvent;

@Service
public class DeleteServiceImpl
implements DeleteService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private Event<ResourceDeletedEvent> resourceDeletedEvent;

    public void delete(Path path, String comment) {
        try {
            System.out.println("USER:" + this.identity.getName() + " DELETING asset [" + path.getFileName() + "]");
            this.ioService.delete(this.paths.convert(path));
            this.resourceDeletedEvent.fire((Object)new ResourceDeletedEvent(path, this.sessionInfo));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

