/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.simple;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.simple.SimpleBeliefSet;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedListEntry;

public class ReteSimpleBeliefSystem
implements BeliefSystem {
    private NamedEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public ReteSimpleBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public void insert(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add(node.getJustifierEntry());
        if (empty) {
            InternalFactHandle handle = beliefSet.getFactHandle();
            this.ep.insert(handle, handle.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf, null);
        }
    }

    @Override
    public void read(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        beliefSet.add(node.getJustifierEntry());
    }

    @Override
    public void delete(LogicalDependency node, BeliefSet beliefSet, PropagationContext context) {
        SimpleBeliefSet sBeliefSet = (SimpleBeliefSet)beliefSet;
        beliefSet.remove(node.getJustifierEntry());
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (beliefSet.isEmpty() && (context.getType() != 1 && context.getType() != 2 || context.getFactHandle() != bfh)) {
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                LogicalCallback action = new LogicalCallback(bfh, context, node.getJustifier(), false, true);
                this.ep.enQueueWorkingMemoryAction(action);
                sBeliefSet.setWorkingMemoryAction(action);
            } else {
                LogicalCallback callback = (LogicalCallback)sBeliefSet.getWorkingMemoryAction();
                callback.setUpdate(false);
                callback.setFullyRetract(true);
            }
        } else if (!beliefSet.isEmpty() && beliefSet.getFactHandle().getObject() == node.getObject()) {
            ((NamedEntryPoint)bfh.getEntryPoint()).getObjectStore().updateHandle(bfh, ((LogicalDependency)((LinkedListEntry)beliefSet.getFirst()).getObject()).getObject());
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                LogicalCallback action = new LogicalCallback(bfh, context, node.getJustifier(), true, false);
                this.ep.enQueueWorkingMemoryAction(action);
                sBeliefSet.setWorkingMemoryAction(action);
            }
        }
    }

    @Override
    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new SimpleBeliefSet(this, fh);
    }

    @Override
    public LogicalDependency newLogicalDependency(Activation activation, BeliefSet beliefSet, Object object, Object value) {
        return new SimpleLogicalDependency(activation, beliefSet, object, value);
    }

    public static class LogicalCallback
    implements WorkingMemoryAction {
        private InternalFactHandle handle;
        private PropagationContext context;
        private Activation activation;
        private boolean update;
        private boolean fullyRetract;

        public LogicalCallback() {
        }

        public LogicalCallback(InternalFactHandle handle, PropagationContext context, Activation activation, boolean update, boolean fullyRetract) {
            this.handle = handle;
            this.context = context;
            this.activation = activation;
            this.update = update;
            this.fullyRetract = fullyRetract;
        }

        public LogicalCallback(MarshallerReaderContext context) throws IOException {
            this.handle = context.handles.get(context.readInt());
            this.context = context.propagationContexts.get(context.readLong());
            this.activation = (Activation)context.terminalTupleMap.get(context.readInt()).getObject();
        }

        public LogicalCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            ProtobufMessages.ActionQueue.LogicalRetract _retract = _action.getLogicalRetract();
            this.handle = context.handles.get(_retract.getHandleId());
            this.activation = (Activation)context.filter.getTuplesCache().get(PersisterHelper.createActivationKey(_retract.getActivation().getPackageName(), _retract.getActivation().getRuleName(), _retract.getActivation().getTuple())).getObject();
            this.context = this.activation.getPropagationContext();
            this.fullyRetract = _retract.getFullyRetract();
            this.update = _retract.getUpdate();
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(4);
            context.writeInt(this.handle.getId());
            context.writeLong(this.context.getPropagationNumber());
            context.writeInt(context.terminalTupleMap.get(this.activation.getTuple()));
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            ProtobufMessages.ActionQueue.LogicalRetract _retract = ProtobufMessages.ActionQueue.LogicalRetract.newBuilder().setHandleId(this.handle.getId()).setActivation(PersisterHelper.createActivation(this.activation.getRule().getPackageName(), this.activation.getRule().getName(), this.activation.getTuple())).setFullyRetract(this.fullyRetract).setUpdate(this.update).build();
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.LOGICAL_RETRACT).setLogicalRetract(_retract).build();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.activation = (Activation)in.readObject();
            this.fullyRetract = in.readBoolean();
            this.update = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.handle);
            out.writeObject(this.context);
            out.writeObject(this.activation);
            out.writeBoolean(this.fullyRetract);
            out.writeBoolean(this.update);
        }

        public boolean isUpdate() {
            return this.update;
        }

        public void setUpdate(boolean update) {
            this.update = update;
        }

        public boolean isFullyRetract() {
            return this.fullyRetract;
        }

        public void setFullyRetract(boolean fullyRetract) {
            this.fullyRetract = fullyRetract;
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            NamedEntryPoint nep = (NamedEntryPoint)this.handle.getEntryPoint();
            BeliefSet bs = this.handle.getEqualityKey().getBeliefSet();
            bs.setWorkingMemoryAction(null);
            if (this.update) {
                if (!bs.isEmpty()) {
                    ((NamedEntryPoint)this.handle.getEntryPoint()).update(this.handle, true, this.handle.getObject(), Long.MAX_VALUE, Object.class, null);
                }
            } else if (this.fullyRetract) {
                ((NamedEntryPoint)this.handle.getEntryPoint()).delete(this.handle, this.context.getRuleOrigin(), this.activation);
            } else {
                ObjectTypeConf typeConf = nep.getObjectTypeConfigurationRegistry().getObjectTypeConf(nep.getEntryPoint(), this.handle.getObject());
                ((NamedEntryPoint)this.handle.getEntryPoint()).getEntryPointNode().retractObject(this.handle, this.context, typeConf, workingMemory);
            }
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

