/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.service.ExplorerService;
import org.uberfire.backend.organizationalunit.OrganizationalUnit;
import org.uberfire.backend.organizationalunit.OrganizationalUnitService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.security.Resource;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class ExplorerServiceImpl
implements ExplorerService {
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private ProjectService projectService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @SessionScoped
    private Identity identity;
    @Inject
    private Paths paths;

    public ExplorerServiceImpl() {
    }

    public ExplorerServiceImpl(IOService ioService, AuthorizationManager authorizationManager, ProjectService projectService, OrganizationalUnitService organizationalUnitService, Identity identity, Paths paths) {
        this.ioService = ioService;
        this.authorizationManager = authorizationManager;
        this.projectService = projectService;
        this.organizationalUnitService = organizationalUnitService;
        this.identity = identity;
        this.paths = paths;
    }

    public ProjectExplorerContent getContent(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg) {
        Collection packages;
        Collection projects;
        Collection repositories;
        OrganizationalUnit selectedOrganizationalUnit = organizationalUnit;
        Repository selectedRepository = repository;
        Project selectedProject = project;
        Package selectedPackage = pkg;
        Collection organizationalUnits = this.getOrganizationalUnits();
        if (!organizationalUnits.contains(selectedOrganizationalUnit)) {
            OrganizationalUnit organizationalUnit2 = selectedOrganizationalUnit = organizationalUnits.isEmpty() ? null : (OrganizationalUnit)organizationalUnits.iterator().next();
        }
        if (!(repositories = this.getRepositories(selectedOrganizationalUnit)).contains(selectedRepository)) {
            Repository repository2 = selectedRepository = repositories.isEmpty() ? null : (Repository)repositories.iterator().next();
        }
        if (!(projects = this.getProjects(selectedRepository)).contains(selectedProject)) {
            Project project2 = selectedProject = projects.isEmpty() ? null : (Project)projects.iterator().next();
        }
        if (!(packages = this.getPackages(selectedProject)).contains(selectedPackage)) {
            selectedPackage = packages.isEmpty() ? null : (Package)packages.iterator().next();
        }
        Collection<FolderItem> items = this.getItems(selectedPackage);
        ProjectExplorerContent content = new ProjectExplorerContent((Set)organizationalUnits, selectedOrganizationalUnit, (Set)repositories, selectedRepository, (Set)projects, selectedProject, (Set)packages, selectedPackage, items);
        return content;
    }

    public Set<OrganizationalUnit> getOrganizationalUnits() {
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        HashSet<OrganizationalUnit> authorizedOrganizationalUnits = new HashSet<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            if (!this.authorizationManager.authorize((Resource)organizationalUnit, (Subject)this.identity)) continue;
            authorizedOrganizationalUnits.add(organizationalUnit);
        }
        return authorizedOrganizationalUnits;
    }

    public Set<Repository> getRepositories(OrganizationalUnit organizationalUnit) {
        HashSet<Repository> authorizedRepositories = new HashSet<Repository>();
        if (organizationalUnit == null) {
            return authorizedRepositories;
        }
        Collection repositories = this.organizationalUnitService.getOrganizationalUnit(organizationalUnit.getName()).getRepositories();
        for (Repository repository : repositories) {
            if (!this.authorizationManager.authorize((Resource)repository, (Subject)this.identity)) continue;
            authorizedRepositories.add(repository);
        }
        return authorizedRepositories;
    }

    public Set<Project> getProjects(Repository repository) {
        HashSet<Project> authorizedProjects = new HashSet<Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        org.uberfire.backend.vfs.Path repositoryRoot = repository.getRoot();
        DirectoryStream nioRepositoryPaths = this.ioService.newDirectoryStream(this.paths.convert(repositoryRoot));
        for (Path nioRepositoryPath : nioRepositoryPaths) {
            org.uberfire.backend.vfs.Path projectPath;
            Project project;
            if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0]) || (project = this.projectService.resolveProject(projectPath = this.paths.convert(nioRepositoryPath))) == null || !this.authorizationManager.authorize((Resource)project, (Subject)this.identity)) continue;
            authorizedProjects.add(project);
        }
        return authorizedProjects;
    }

    public Set<Package> getPackages(Project project) {
        return this.projectService.resolvePackages(project);
    }

    public Collection<FolderItem> getItems(Package pkg) {
        HashSet<FolderItem> folderItems = new HashSet<FolderItem>();
        if (pkg == null) {
            return folderItems;
        }
        folderItems.addAll(this.getItems(pkg.getPackageMainSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageMainResourcesPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestResourcesPath()));
        return folderItems;
    }

    private Collection<FolderItem> getItems(org.uberfire.backend.vfs.Path packagePath) {
        HashSet<FolderItem> folderItems = new HashSet<FolderItem>();
        Path nioPackagePath = this.paths.convert(packagePath);
        if (Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPackagePath, (DirectoryStream.Filter)this.dotFileFilter);
            for (Path nioPath : nioPaths) {
                if (!Files.isRegularFile((Path)nioPath, (LinkOption[])new LinkOption[0])) continue;
                org.uberfire.backend.vfs.Path path = this.paths.convert(nioPath);
                FolderItem folderItem = new FolderItem(path, path.getFileName(), FolderItemType.FILE);
                folderItems.add(folderItem);
            }
        }
        return folderItems;
    }

    public FolderListing getFolderListing(org.uberfire.backend.vfs.Path path) {
        HashSet<FolderItem> folderItems = new HashSet<FolderItem>();
        Path nioPath = this.paths.convert(path);
        while (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            nioPath = nioPath.getParent();
        }
        org.uberfire.backend.vfs.Path basePath = this.paths.convert(nioPath);
        org.uberfire.backend.vfs.Path baseParentPath = this.paths.convert(nioPath.getParent());
        DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPath, (DirectoryStream.Filter)this.dotFileFilter);
        for (Path np : nioPaths) {
            FolderItem folderItem;
            org.uberfire.backend.vfs.Path p;
            if (Files.isRegularFile((Path)np, (LinkOption[])new LinkOption[0])) {
                p = this.paths.convert(np);
                folderItem = new FolderItem(p, p.getFileName(), FolderItemType.FILE);
                folderItems.add(folderItem);
                continue;
            }
            if (!Files.isDirectory((Path)np, (LinkOption[])new LinkOption[0])) continue;
            p = this.paths.convert(np);
            folderItem = new FolderItem(p, p.getFileName(), FolderItemType.FOLDER);
            folderItems.add(folderItem);
        }
        List<org.uberfire.backend.vfs.Path> segments = this.getPathSegments(basePath);
        return new FolderListing(basePath, baseParentPath, folderItems, segments);
    }

    private List<org.uberfire.backend.vfs.Path> getPathSegments(org.uberfire.backend.vfs.Path path) {
        Path nioSegmentPath = this.paths.convert(path);
        int segmentCount = nioSegmentPath.getNameCount() - 1;
        if (segmentCount < 1) {
            return new ArrayList<org.uberfire.backend.vfs.Path>();
        }
        org.uberfire.backend.vfs.Path[] segments = new org.uberfire.backend.vfs.Path[segmentCount];
        for (int idx = segmentCount; idx > 0; --idx) {
            segments[idx - 1] = this.paths.convert(nioSegmentPath);
            nioSegmentPath = nioSegmentPath.getParent();
        }
        return Arrays.asList(segments);
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return null;
        }
        Package pkg = this.projectService.resolvePackage(path);
        return pkg;
    }
}

