/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.exception.control;

import java.io.Serializable;
import java.util.Arrays;

public final class ExceptionStackItem
implements Serializable {
    private static final long serialVersionUID = 3082750572813491654L;
    private final Throwable throwable;
    private final StackTraceElement[] stackTraceElements;

    public ExceptionStackItem(Throwable cause) {
        this(cause, cause.getStackTrace());
    }

    public ExceptionStackItem(Throwable throwable, StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = (StackTraceElement[])stackTraceElements.clone();
        this.throwable = throwable;
    }

    public StackTraceElement[] getStackTraceElements() {
        return (StackTraceElement[])this.stackTraceElements.clone();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return "throwable: " + this.throwable + ", " + "stackTraceElements: " + this.stackTraceElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionStackItem that = (ExceptionStackItem)o;
        if (!Arrays.equals(this.stackTraceElements, that.stackTraceElements)) {
            return false;
        }
        return this.throwable.equals(that.throwable);
    }

    public int hashCode() {
        int result = this.throwable.hashCode();
        result = 31 * result + Arrays.hashCode(this.stackTraceElements);
        return result;
    }
}

