/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.uberfire.security.Resource;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.Subject;
import org.uberfire.security.server.URLResource;

public class HttpSecurityContext
implements SecurityContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final URLResource resource;
    private Subject subject;

    public HttpSecurityContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object ... objects) {
        this.request = httpRequest;
        this.response = httpResponse;
        StringBuilder url = new StringBuilder(this.request.getServletPath());
        if (this.request.getQueryString() != null) {
            url.append("?").append(this.request.getQueryString());
        }
        this.resource = new URLResource(url.toString());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Subject getCurrentSubject() {
        return this.subject;
    }

    public void setCurrentSubject(Subject subject) {
        this.subject = subject;
    }
}

