/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class Relayer {
    protected Route[] routes;
    protected List<Bridge> bridges;
    protected final Log log;
    protected final RELAY2 relay;

    public Relayer(RELAY2 relay, Log log) {
        this.relay = relay;
        this.log = log;
    }

    public void start(List<RelayConfig.BridgeConfig> bridge_configs, String bridge_name, final short my_site_id) throws Throwable {
        this.routes = new Route[bridge_configs.size()];
        this.bridges = new ArrayList<Bridge>(bridge_configs.size());
        try {
            for (RelayConfig.BridgeConfig bridge_config : bridge_configs) {
                Bridge bridge = new Bridge(bridge_config.createChannel(), bridge_config.getClusterName(), bridge_name, new AddressGenerator(){

                    @Override
                    public Address generateAddress() {
                        UUID uuid = UUID.randomUUID();
                        return new SiteUUID(uuid, null, my_site_id);
                    }
                });
                this.bridges.add(bridge);
            }
        }
        catch (Throwable t) {
            this.stop();
            throw t;
        }
        try {
            for (Bridge bridge : this.bridges) {
                bridge.start();
            }
        }
        catch (Throwable t) {
            this.stop();
            throw t;
        }
    }

    public void stop() {
        for (Bridge bridge : this.bridges) {
            bridge.stop();
        }
    }

    public synchronized String printRoutes() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.routes.length; ++i) {
            Route route = this.routes[i];
            if (route == null) continue;
            String name = SiteUUID.getSiteName((short)i);
            if (name == null) {
                name = String.valueOf(i);
            }
            sb.append(name + " --> " + route + "\n");
        }
        return sb.toString();
    }

    protected synchronized void addRoute(short site, Route route) {
        this.ensureCapacity(site);
        Route old_route = this.routes[site];
        if (old_route == null) {
            this._addRoute(site, route);
        } else if (!old_route.site_master.equals(route.site_master) || old_route.bridge != route.bridge) {
            this._addRoute(site, route);
        }
    }

    protected void _addRoute(short site, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("added site " + SiteUUID.getSiteName(site));
        }
        this.routes[site] = route;
    }

    protected synchronized Route removeRoute(short site) {
        if (site <= this.routes.length - 1) {
            Route route = this.routes[site];
            this.routes[site] = null;
            if (this.log.isTraceEnabled()) {
                this.log.trace("removed route " + SiteUUID.getSiteName(site));
            }
            return route;
        }
        return null;
    }

    protected synchronized Route getRoute(short site) {
        if (site <= this.routes.length - 1) {
            return this.routes[site];
        }
        return null;
    }

    protected synchronized List<Route> getRoutes(short ... excluded_sites) {
        ArrayList<Route> retval = new ArrayList<Route>(this.routes.length);
        for (int i = 0; i < this.routes.length; i = (int)((short)(i + 1))) {
            Route tmp = this.routes[i];
            if (tmp == null || Relayer.isExcluded(tmp, excluded_sites)) continue;
            retval.add(tmp);
        }
        return retval;
    }

    protected View getBridgeView(String cluster_name) {
        if (cluster_name == null) {
            return null;
        }
        for (Bridge bridge : this.bridges) {
            if (bridge.cluster_name == null || !bridge.cluster_name.equals(cluster_name)) continue;
            return bridge.view;
        }
        return null;
    }

    protected static boolean isExcluded(Route route, short ... excluded_sites) {
        if (excluded_sites == null) {
            return false;
        }
        short site = ((SiteUUID)route.site_master).getSite();
        for (short excluded_site : excluded_sites) {
            if (site != excluded_site) continue;
            return true;
        }
        return false;
    }

    protected synchronized void ensureCapacity(short site) {
        if (site >= this.routes.length) {
            Route[] tmp_routes = new Route[Math.max(site + 1, this.routes.length * 2)];
            System.arraycopy(this.routes, 0, tmp_routes, 0, this.routes.length);
            this.routes = tmp_routes;
        }
    }

    protected class Bridge
    extends ReceiverAdapter {
        protected JChannel channel;
        protected final String cluster_name;
        protected View view;

        protected Bridge(JChannel ch, String cluster_name, String channel_name, AddressGenerator addr_generator) throws Exception {
            this.channel = ch;
            this.channel.setName(channel_name);
            this.channel.setReceiver(this);
            this.channel.setAddressGenerator(addr_generator);
            this.cluster_name = cluster_name;
        }

        protected void start() throws Exception {
            this.channel.connect(this.cluster_name);
        }

        protected void stop() {
            Util.close((Channel)this.channel);
        }

        @Override
        public void receive(Message msg) {
            RELAY2.Relay2Header hdr = (RELAY2.Relay2Header)msg.getHeader(Relayer.this.relay.getId());
            if (hdr == null) {
                Relayer.this.log.warn("received a message without a relay header; discarding it");
                return;
            }
            Relayer.this.relay.handleRelayMessage(hdr, msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            short site;
            SiteUUID site_uuid;
            List<Address> left_mbrs = this.view != null ? Util.determineLeftMembers(this.view.getMembers(), new_view.getMembers()) : null;
            this.view = new_view;
            if (Relayer.this.log.isTraceEnabled()) {
                Relayer.this.log.trace("[Relayer " + this.channel.getAddress() + "] view: " + new_view);
            }
            if (left_mbrs != null) {
                for (Address addr : left_mbrs) {
                    if (!(addr instanceof SiteUUID)) continue;
                    site_uuid = (SiteUUID)addr;
                    site = site_uuid.getSite();
                    Relayer.this.removeRoute(site);
                }
            }
            for (Address addr : new_view.getMembers()) {
                if (!(addr instanceof SiteUUID)) continue;
                site_uuid = (SiteUUID)addr;
                site = site_uuid.getSite();
                Route route = new Route(site_uuid, this.channel);
                Relayer.this.addRoute(site, route);
            }
        }
    }

    public static class Route {
        protected final Address site_master;
        protected final JChannel bridge;

        public Route(Address site_master, JChannel bridge) {
            this.site_master = site_master;
            this.bridge = bridge;
        }

        public JChannel getBridge() {
            return this.bridge;
        }

        public Address getSiteMaster() {
            return this.site_master;
        }

        public String toString() {
            return this.site_master.toString();
        }
    }
}

