/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.common.services.workingset.client.events;

import org.uberfire.backend.vfs.Path;

/**
 *
 */
public class OnWorkingSetDisabled {

    private Path resource;
    private Path workingSet;

    public OnWorkingSetDisabled() {
    }

    public OnWorkingSetDisabled( final Path resource,
                                 final Path workingSet ) {
        this.resource = resource;
        this.workingSet = workingSet;
    }

    public Path getResource() {
        return resource;
    }

    public Path getWorkingSet() {
        return workingSet;
    }
}
