/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class FileUploadServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadServlet.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (request.getParameter("path") != null) {
                this.writeFile(this.ioService.get(new URI(request.getParameter("path"))), this.getFileItem(request));
                this.writeResponse(response, "OK");
            } else if (request.getParameter("folder") != null) {
                this.writeFile(this.ioService.get(new URI(request.getParameter("folder") + "/" + request.getParameter("fileName"))), this.getFileItem(request));
                this.writeResponse(response, "OK");
            }
        }
        catch (FileUploadException e) {
            this.logError(e);
            this.writeResponse(response, "FAIL");
        }
        catch (URISyntaxException e) {
            this.logError(e);
            this.writeResponse(response, "FAIL");
        }
    }

    private FileItem getFileItem(HttpServletRequest request) throws FileUploadException {
        for (FileItem item : this.getServletFileUpload().parseRequest(request)) {
            if (item.isFormField()) continue;
            return item;
        }
        return null;
    }

    private void writeResponse(HttpServletResponse response, String ok) throws IOException {
        response.setContentType("text/html");
        response.getWriter().write(ok);
    }

    private ServletFileUpload getServletFileUpload() {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        return upload;
    }

    private void writeFile(Path path, FileItem uploadedItem) throws IOException {
        if (!this.ioService.exists(path)) {
            this.ioService.createFile(path, new FileAttribute[0]);
        }
        this.ioService.write(path, IOUtils.toByteArray((InputStream)uploadedItem.getInputStream()), new OpenOption[0]);
        uploadedItem.getInputStream().close();
    }

    private void logError(Throwable e) {
        logger.error("Failed to upload a file.", e);
    }
}

