/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.CopyHelper;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.RenameHelper;
import org.guvnor.common.services.project.events.DeleteProjectEvent;
import org.guvnor.common.services.project.events.RenameProjectEvent;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.model.ProjectExplorerContent;
import org.kie.workbench.common.screens.explorer.service.ExplorerService;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.utils.Sorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.organizationalunit.OrganizationalUnit;
import org.uberfire.backend.organizationalunit.OrganizationalUnitService;
import org.uberfire.backend.repositories.Repository;
import org.uberfire.backend.server.UserServicesBackendImpl;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Identity;
import org.uberfire.security.Resource;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.server.cdi.AppResourcesAuthz;

@Service
@ApplicationScoped
public class ExplorerServiceImpl
implements ExplorerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplorerServiceImpl.class);
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="configIO")
    private IOService ioServiceConfig;
    @Inject
    private ProjectService projectService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    @AppResourcesAuthz
    private AuthorizationManager authorizationManager;
    @Inject
    @SessionScoped
    private Identity identity;
    @Inject
    @SessionScoped
    private SessionInfo sessionInfo;
    @Inject
    private UserServicesImpl userServices;
    @Inject
    private UserServicesBackendImpl userServicesBackend;
    @Inject
    private Instance<RenameHelper> renameHelpers;
    @Inject
    private Instance<CopyHelper> copyHelpers;
    private XStream xs = new XStream();

    public ExplorerServiceImpl() {
    }

    public ExplorerServiceImpl(IOService ioService, AuthorizationManager authorizationManager, ProjectService projectService, OrganizationalUnitService organizationalUnitService, Identity identity) {
        this.ioService = ioService;
        this.authorizationManager = authorizationManager;
        this.projectService = projectService;
        this.organizationalUnitService = organizationalUnitService;
        this.identity = identity;
    }

    public ProjectExplorerContent getContent(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg, FolderItem item, Set<Option> options) {
        Set<Project> projects;
        Set<Repository> repositories;
        Set<OrganizationalUnit> organizationalUnits;
        OrganizationalUnit selectedOrganizationalUnit = organizationalUnit;
        Repository selectedRepository = repository;
        Project selectedProject = project;
        Package selectedPackage = pkg;
        FolderItem selectedItem = item;
        UserExplorerLastData lastContent = this.getLastContent();
        UserExplorerData userContent = this.loadUserContent();
        if (!lastContent.isDataEmpty()) {
            if (organizationalUnit == null && repository == null && project == null) {
                if (options.contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                    selectedOrganizationalUnit = lastContent.getLastPackage().getOrganizationalUnit();
                    selectedRepository = lastContent.getLastPackage().getRepository();
                    selectedProject = lastContent.getLastPackage().getProject();
                    selectedPackage = lastContent.getLastPackage().getPkg();
                    selectedItem = null;
                } else if (options.contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null) {
                    selectedOrganizationalUnit = lastContent.getLastFolderItem().getOrganizationalUnit();
                    selectedRepository = lastContent.getLastFolderItem().getRepository();
                    selectedProject = lastContent.getLastFolderItem().getProject();
                    selectedItem = lastContent.getLastFolderItem().getItem();
                    selectedPackage = null;
                }
            } else if (options.contains(Option.BUSINESS_CONTENT) && lastContent.getLastPackage() != null) {
                if (!organizationalUnit.equals(lastContent.getLastPackage().getOrganizationalUnit()) || repository != null && !repository.equals(lastContent.getLastPackage().getRepository()) || project != null && !project.equals((Object)lastContent.getLastPackage().getProject())) {
                    selectedOrganizationalUnit = this.loadOrganizationalUnit(organizationalUnit, userContent);
                    selectedRepository = this.loadRepository(selectedOrganizationalUnit, repository, userContent);
                    selectedProject = this.loadProject(selectedOrganizationalUnit, selectedRepository, project, userContent);
                    selectedPackage = this.loadPackage(selectedOrganizationalUnit, selectedRepository, selectedProject, pkg, userContent);
                    selectedItem = null;
                }
            } else if (options.contains(Option.TECHNICAL_CONTENT) && lastContent.getLastFolderItem() != null && (!organizationalUnit.equals(lastContent.getLastFolderItem().getOrganizationalUnit()) || repository != null && !repository.equals(lastContent.getLastFolderItem().getRepository()) || project != null && !project.equals((Object)lastContent.getLastFolderItem().getProject()))) {
                selectedOrganizationalUnit = this.loadOrganizationalUnit(organizationalUnit, userContent);
                selectedRepository = this.loadRepository(selectedOrganizationalUnit, repository, userContent);
                selectedProject = this.loadProject(selectedOrganizationalUnit, selectedRepository, project, userContent);
                selectedItem = this.loadFolderItem(selectedOrganizationalUnit, selectedRepository, selectedProject, item, userContent);
                selectedPackage = null;
            }
        }
        if (!(organizationalUnits = this.getOrganizationalUnits()).contains(selectedOrganizationalUnit)) {
            OrganizationalUnit organizationalUnit2 = selectedOrganizationalUnit = organizationalUnits.isEmpty() ? null : organizationalUnits.iterator().next();
        }
        if (!(repositories = this.getRepositories(selectedOrganizationalUnit)).contains(selectedRepository)) {
            Repository repository2 = selectedRepository = repositories.isEmpty() ? null : repositories.iterator().next();
        }
        if (!(projects = this.getProjects(selectedRepository)).contains(selectedProject)) {
            Project project2 = selectedProject = projects.isEmpty() ? null : projects.iterator().next();
        }
        if (selectedOrganizationalUnit == null || selectedRepository == null || selectedProject == null) {
            return new ProjectExplorerContent((Set)new TreeSet<OrganizationalUnit>(Sorters.ORGANIZATIONAL_UNIT_SORTER){
                {
                    super(x0);
                    this.addAll(organizationalUnits);
                }
            }, selectedOrganizationalUnit, (Set)new TreeSet<Repository>(Sorters.REPOSITORY_SORTER){
                {
                    super(x0);
                    this.addAll(repositories);
                }
            }, selectedRepository, (Set)new TreeSet<Project>(Sorters.PROJECT_SORTER){
                {
                    super(x0);
                    this.addAll(projects);
                }
            }, selectedProject, new FolderListing(null, Collections.emptyList(), Collections.emptyList()));
        }
        FolderListing folderListing = null;
        if (selectedItem == null) {
            if (options.contains(Option.BUSINESS_CONTENT)) {
                List<Object> segments;
                Package defautlPackage;
                if (selectedPackage == null) {
                    defautlPackage = this.projectService.resolveDefaultPackage(selectedProject);
                    segments = Collections.emptyList();
                } else {
                    defautlPackage = selectedPackage;
                    segments = this.getPackageSegments(selectedPackage);
                }
                folderListing = new FolderListing(this.toFolderItem(defautlPackage), this.getItems(defautlPackage), segments);
            } else {
                folderListing = this.getFolderListing(selectedProject.getRootPath());
            }
        } else {
            folderListing = this.getFolderListing(selectedItem);
        }
        if (selectedPackage != null && folderListing == null) {
            folderListing = new FolderListing(this.toFolderItem(selectedPackage), this.getItems(selectedPackage), this.getPackageSegments(selectedPackage));
        }
        final Path userNavPath = this.userServices.buildPath("explorer", "user.nav");
        final Path lastUserNavPath = this.userServices.buildPath("explorer", "last.user.nav");
        final OrganizationalUnit _selectedOrganizationalUnit = selectedOrganizationalUnit;
        final Repository _selectedRepository = selectedRepository;
        final Project _selectedProject = selectedProject;
        FolderItem _selectedItem = folderListing.getItem();
        Object _selectedPackage = selectedPackage != null ? selectedPackage : (folderListing.getItem().getItem() instanceof Package ? (Package)folderListing.getItem().getItem() : null);
        new Thread((Package)_selectedPackage, _selectedItem, options){
            final /* synthetic */ Package val$_selectedPackage;
            final /* synthetic */ FolderItem val$_selectedItem;
            final /* synthetic */ Set val$options;
            {
                this.val$_selectedPackage = package_;
                this.val$_selectedItem = folderItem;
                this.val$options = set;
            }

            @Override
            public void run() {
                try {
                    ExplorerServiceImpl.this.store(userNavPath, lastUserNavPath, _selectedOrganizationalUnit, _selectedRepository, _selectedProject, this.val$_selectedPackage, this.val$_selectedItem, this.val$options);
                }
                catch (Exception e) {
                    LOGGER.error("Can't serialize user's state navigation", (Throwable)e);
                }
            }
        }.start();
        return new ProjectExplorerContent((Set)new TreeSet<OrganizationalUnit>(Sorters.ORGANIZATIONAL_UNIT_SORTER){
            {
                super(x0);
                this.addAll(organizationalUnits);
            }
        }, selectedOrganizationalUnit, (Set)new TreeSet<Repository>(Sorters.REPOSITORY_SORTER){
            {
                super(x0);
                this.addAll(repositories);
            }
        }, selectedRepository, (Set)new TreeSet<Project>(Sorters.PROJECT_SORTER){
            {
                super(x0);
                this.addAll(projects);
            }
        }, selectedProject, folderListing);
    }

    private OrganizationalUnit loadOrganizationalUnit(OrganizationalUnit organizationalUnit, UserExplorerData content) {
        if (organizationalUnit != null) {
            return organizationalUnit;
        }
        return content.getOrganizationalUnit();
    }

    private Repository loadRepository(OrganizationalUnit organizationalUnit, Repository repository, UserExplorerData content) {
        if (organizationalUnit == null) {
            return null;
        }
        if (repository != null) {
            return repository;
        }
        return content.get(organizationalUnit);
    }

    private Project loadProject(OrganizationalUnit organizationalUnit, Repository repository, Project project, UserExplorerData content) {
        if (repository == null) {
            return null;
        }
        if (project != null) {
            return project;
        }
        return content.get(organizationalUnit, repository);
    }

    private Package loadPackage(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg, UserExplorerData content) {
        if (project == null) {
            return null;
        }
        if (pkg != null) {
            return pkg;
        }
        return content.getPackage(organizationalUnit, repository, project);
    }

    private FolderItem loadFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Project project, FolderItem item, UserExplorerData content) {
        if (project == null) {
            return null;
        }
        if (item != null) {
            return item;
        }
        return content.getFolderItem(organizationalUnit, repository, project);
    }

    private UserExplorerData loadUserContent() {
        UserExplorerData userExplorerData = this.loadUserContent(this.userServices.buildPath("explorer", "user.nav"));
        if (userExplorerData != null) {
            return userExplorerData;
        }
        return new UserExplorerData();
    }

    private UserExplorerData loadUserContent(Path path) {
        try {
            if (this.ioServiceConfig.exists(path)) {
                String xml = this.ioServiceConfig.readAllString(path);
                return (UserExplorerData)this.xs.fromXML(xml);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private UserExplorerLastData getLastContent() {
        try {
            UserExplorerLastData lastData = this.getLastContent(this.userServices.buildPath("explorer", "last.user.nav"));
            if (lastData != null) {
                return lastData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new UserExplorerLastData();
    }

    private UserExplorerLastData getLastContent(Path path) {
        try {
            if (this.ioServiceConfig.exists(path)) {
                String xml = this.ioServiceConfig.readAllString(path);
                return (UserExplorerLastData)this.xs.fromXML(xml);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void store(Path userNav, Path lastUserNav, OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg, FolderItem item, Set<Option> options) {
        UserExplorerData _content = this.loadUserContent(userNav);
        UserExplorerData content = _content == null ? new UserExplorerData() : _content;
        UserExplorerLastData lastContent = new UserExplorerLastData();
        if (organizationalUnit != null) {
            content.setOrganizationalUnit(organizationalUnit);
        }
        if (repository != null && organizationalUnit != null) {
            content.addRepository(organizationalUnit, repository);
        }
        if (project != null && organizationalUnit != null && repository != null) {
            content.addProject(organizationalUnit, repository, project);
        }
        if (item != null && organizationalUnit != null && repository != null && project != null) {
            lastContent.setFolderItem(organizationalUnit, repository, project, item);
            content.addFolderItem(organizationalUnit, repository, project, item);
        }
        if (pkg != null && organizationalUnit != null && repository != null && project != null) {
            lastContent.setPackage(organizationalUnit, repository, project, pkg);
            content.addPackage(organizationalUnit, repository, project, pkg);
        }
        if (options != null && !options.isEmpty()) {
            lastContent.setOptions(options);
        }
        if (!content.isEmpty()) {
            this.ioServiceConfig.write(userNav, this.xs.toXML((Object)content), new OpenOption[0]);
            this.ioServiceConfig.write(lastUserNav, this.xs.toXML((Object)lastContent), new OpenOption[0]);
        }
    }

    private FolderItem toFolderItem(Package pkg) {
        if (pkg == null) {
            return null;
        }
        return new FolderItem((Object)pkg, pkg.getRelativeCaption(), FolderItemType.FOLDER);
    }

    private Set<OrganizationalUnit> getOrganizationalUnits() {
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        HashSet<OrganizationalUnit> authorizedOrganizationalUnits = new HashSet<OrganizationalUnit>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            if (!this.authorizationManager.authorize((Resource)organizationalUnit, (Subject)this.identity)) continue;
            authorizedOrganizationalUnits.add(organizationalUnit);
        }
        return authorizedOrganizationalUnits;
    }

    private Set<Repository> getRepositories(OrganizationalUnit organizationalUnit) {
        HashSet<Repository> authorizedRepositories = new HashSet<Repository>();
        if (organizationalUnit == null) {
            return authorizedRepositories;
        }
        Collection repositories = this.organizationalUnitService.getOrganizationalUnit(organizationalUnit.getName()).getRepositories();
        for (Repository repository : repositories) {
            if (!this.authorizationManager.authorize((Resource)repository, (Subject)this.identity)) continue;
            authorizedRepositories.add(repository);
        }
        return authorizedRepositories;
    }

    private Set<Project> getProjects(Repository repository) {
        HashSet<Project> authorizedProjects = new HashSet<Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        org.uberfire.backend.vfs.Path repositoryRoot = repository.getRoot();
        DirectoryStream nioRepositoryPaths = this.ioService.newDirectoryStream(Paths.convert((org.uberfire.backend.vfs.Path)repositoryRoot));
        for (Path nioRepositoryPath : nioRepositoryPaths) {
            org.uberfire.backend.vfs.Path projectPath;
            Project project;
            if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0]) || (project = this.projectService.resolveProject(projectPath = Paths.convert((Path)nioRepositoryPath))) == null || !this.authorizationManager.authorize((Resource)project, (Subject)this.identity)) continue;
            authorizedProjects.add(project);
        }
        return authorizedProjects;
    }

    private List<FolderItem> getItems(Package pkg) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        if (pkg == null) {
            return Collections.emptyList();
        }
        Set childPackages = this.projectService.resolvePackages(pkg);
        for (Package childPackage : childPackages) {
            folderItems.add(this.toFolderItem(childPackage));
        }
        folderItems.addAll(this.getItems(pkg.getPackageMainSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageMainResourcesPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestResourcesPath()));
        Collections.sort(folderItems, Sorters.ITEM_SORTER);
        return folderItems;
    }

    private List<FolderItem> getItems(org.uberfire.backend.vfs.Path packagePath) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        if (Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPackagePath, (DirectoryStream.Filter)this.dotFileFilter);
            for (Path nioPath : nioPaths) {
                if (!Files.isRegularFile((Path)nioPath, (LinkOption[])new LinkOption[0])) continue;
                org.uberfire.backend.vfs.Path path = Paths.convert((Path)nioPath);
                FolderItem folderItem = new FolderItem((Object)path, path.getFileName(), FolderItemType.FILE);
                folderItems.add(folderItem);
            }
        }
        return folderItems;
    }

    public FolderListing getFolderListing(final OrganizationalUnit organizationalUnit, final Repository repository, final Project project, final FolderItem item, final Set<Option> options) {
        FolderListing result = this.getFolderListing(item);
        if (result != null) {
            final Path userNavPath = this.userServices.buildPath("explorer", "user.nav");
            final Path lastUserNavPath = this.userServices.buildPath("explorer", "last.user.nav");
            new Thread(){

                @Override
                public void run() {
                    try {
                        Package pkg = null;
                        if (item.getItem() instanceof Package) {
                            pkg = (Package)item.getItem();
                        }
                        ExplorerServiceImpl.this.store(userNavPath, lastUserNavPath, organizationalUnit, repository, project, pkg, item, options);
                    }
                    catch (Exception e) {
                        LOGGER.error("Can't serialize user's state navigation", (Throwable)e);
                    }
                }
            }.start();
        }
        return result;
    }

    private FolderListing getFolderListing(FolderItem item) {
        FolderListing result = null;
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            result = this.getFolderListing((org.uberfire.backend.vfs.Path)item.getItem());
        } else if (item.getItem() instanceof Package) {
            result = this.getFolderListing((Package)item.getItem());
        }
        return result;
    }

    private FolderListing getFolderListing(org.uberfire.backend.vfs.Path path) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        while (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            nioPath = nioPath.getParent();
        }
        org.uberfire.backend.vfs.Path basePath = Paths.convert((Path)nioPath);
        DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPath, (DirectoryStream.Filter)this.dotFileFilter);
        for (Path np : nioPaths) {
            FolderItem folderItem;
            org.uberfire.backend.vfs.Path p;
            if (Files.isRegularFile((Path)np, (LinkOption[])new LinkOption[0])) {
                p = Paths.convert((Path)np);
                folderItem = new FolderItem((Object)p, p.getFileName(), FolderItemType.FILE);
                folderItems.add(folderItem);
                continue;
            }
            if (!Files.isDirectory((Path)np, (LinkOption[])new LinkOption[0])) continue;
            p = Paths.convert((Path)np);
            folderItem = new FolderItem((Object)p, p.getFileName(), FolderItemType.FOLDER);
            folderItems.add(folderItem);
        }
        Collections.sort(folderItems, Sorters.ITEM_SORTER);
        return new FolderListing(this.toFolderItem(nioPath), folderItems, this.getPathSegments(basePath));
    }

    private FolderListing getFolderListing(Package pkg) {
        return new FolderListing(this.toFolderItem(pkg), this.getItems(pkg), this.getPackageSegments(pkg));
    }

    private List<FolderItem> getPathSegments(org.uberfire.backend.vfs.Path path) {
        Path nioSegmentPath = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent();
        int segmentCount = nioSegmentPath.getNameCount();
        if (segmentCount < 1) {
            return new ArrayList<FolderItem>();
        }
        FolderItem[] segments = new FolderItem[segmentCount];
        for (int idx = segmentCount; idx > 0; --idx) {
            segments[idx - 1] = this.toFolderItem(nioSegmentPath);
            nioSegmentPath = nioSegmentPath.getParent();
        }
        return Arrays.asList(segments);
    }

    private List<FolderItem> getPackageSegments(Package _pkg) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Package pkg = _pkg;
        while (pkg != null) {
            Package parent = this.projectService.resolveParentPackage(pkg);
            if (parent != null) {
                result.add(this.toFolderItem(parent));
            }
            pkg = parent;
        }
        return Lists.reverse(result);
    }

    private FolderItem toFolderItem(Path path) {
        if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path p = Paths.convert((Path)path);
            return new FolderItem((Object)p, p.getFileName(), FolderItemType.FILE);
        }
        if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path p = Paths.convert((Path)path);
            return new FolderItem((Object)p, p.getFileName(), FolderItemType.FOLDER);
        }
        return null;
    }

    private Collection<org.uberfire.backend.vfs.Path> resolvePath(final FolderItem item) {
        if (item == null) {
            return Collections.emptyList();
        }
        if (item.getItem() instanceof Package) {
            final Package pkg = (Package)item.getItem();
            return new ArrayList<org.uberfire.backend.vfs.Path>(4){
                {
                    super(x0);
                    this.add(pkg.getPackageMainResourcesPath());
                    this.add(pkg.getPackageMainSrcPath());
                    this.add(pkg.getPackageTestResourcesPath());
                    this.add(pkg.getPackageTestSrcPath());
                }
            };
        }
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            return new ArrayList<org.uberfire.backend.vfs.Path>(1){
                {
                    super(x0);
                    this.add((org.uberfire.backend.vfs.Path)item.getItem());
                }
            };
        }
        return Collections.emptyList();
    }

    public Package resolvePackage(FolderItem item) {
        if (item == null) {
            return null;
        }
        if (item.getItem() instanceof Package) {
            return (Package)item.getItem();
        }
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            return this.projectService.resolvePackage((org.uberfire.backend.vfs.Path)item.getItem());
        }
        return null;
    }

    public Set<Option> getLastUserOptions() {
        return this.getLastContent().getOptions();
    }

    public void deleteItem(FolderItem folderItem, String comment) {
        Collection<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        try {
            if (paths.size() > 1) {
                this.ioService.startBatch(new org.uberfire.java.nio.file.Option[0]);
            }
            for (org.uberfire.backend.vfs.Path path : paths) {
                this.ioService.deleteIfExists(Paths.convert((org.uberfire.backend.vfs.Path)path), new DeleteOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getName(), null, comment), StandardDeleteOption.NON_EMPTY_DIRECTORIES});
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            if (paths.size() > 1) {
                this.ioService.endBatch(new org.uberfire.java.nio.file.Option[0]);
            }
        }
    }

    public void renameItem(FolderItem folderItem, String newName, String comment) {
        Collection<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        try {
            this.ioService.startBatch(new org.uberfire.java.nio.file.Option[0]);
            for (org.uberfire.backend.vfs.Path path : paths) {
                Path _target;
                Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
                if (!Files.exists((Path)_path, (LinkOption[])new LinkOption[0])) continue;
                if (Files.isDirectory((Path)_path, (LinkOption[])new LinkOption[0])) {
                    _target = _path.resolveSibling(newName);
                } else {
                    String originalFileName = _path.getFileName().toString();
                    String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
                    _target = _path.resolveSibling(newName + extension);
                }
                this.ioService.move(_path, _target, new CopyOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getName(), null, comment)});
                if (_target == null) continue;
                org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
                for (RenameHelper helper : this.renameHelpers) {
                    if (!helper.supports(targetPath)) continue;
                    helper.postProcess(path, targetPath);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch(new org.uberfire.java.nio.file.Option[0]);
        }
    }

    public void copyItem(FolderItem folderItem, String newName, String comment) {
        Collection<org.uberfire.backend.vfs.Path> paths = this.resolvePath(folderItem);
        try {
            this.ioService.startBatch(new org.uberfire.java.nio.file.Option[0]);
            for (org.uberfire.backend.vfs.Path path : paths) {
                Path _target;
                Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
                if (!Files.exists((Path)_path, (LinkOption[])new LinkOption[0])) continue;
                if (Files.isDirectory((Path)_path, (LinkOption[])new LinkOption[0])) {
                    _target = _path.resolveSibling(newName);
                } else {
                    String originalFileName = _path.getFileName().toString();
                    String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
                    _target = _path.resolveSibling(newName + extension);
                }
                this.ioService.copy(_path, _target, new CopyOption[]{new CommentedOption(this.sessionInfo.getId(), this.identity.getName(), null, comment)});
                if (_target == null) continue;
                org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
                for (CopyHelper helper : this.copyHelpers) {
                    if (!helper.supports(targetPath)) continue;
                    helper.postProcess(path, targetPath);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch(new org.uberfire.java.nio.file.Option[0]);
        }
    }

    void onProjectRename(@Observes RenameProjectEvent event) {
        this.cleanup(event.getOldProject());
    }

    void onProjectDelete(@Observes DeleteProjectEvent event) {
        this.cleanup(event.getProject());
    }

    private void cleanup(Project project) {
        Collection lastNavs = this.userServicesBackend.getAllUsersData("explorer", "last.user.nav");
        Collection userNavs = this.userServicesBackend.getAllUsersData("explorer", "user.nav");
        for (Path path : userNavs) {
            UserExplorerData userContent = this.loadUserContent(path);
            if (userContent == null || !userContent.deleteProject(project)) continue;
            this.ioServiceConfig.write(path, this.xs.toXML((Object)userContent), new OpenOption[0]);
        }
        for (Path lastNav : lastNavs) {
            UserExplorerLastData lastUserContent = this.getLastContent(lastNav);
            if (lastUserContent == null || !lastUserContent.deleteProject(project)) continue;
            this.ioServiceConfig.write(lastNav, this.xs.toXML((Object)lastUserContent), new OpenOption[0]);
        }
    }
}

