/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.builder.BuildExecutorServiceFactory;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.workbench.events.ResourceChange;

@ApplicationScoped
public class ResourceChangeIncrementalBuilder {
    private static final String INCREMENTAL_BUILD_PROPERTY_NAME = "build.enable-incremental";
    private static final Logger logger = LoggerFactory.getLogger(ResourceChangeIncrementalBuilder.class);
    @Inject
    private ProjectService projectService;
    @Inject
    private BuildService buildService;
    @Inject
    private AppConfigService appConfigService;
    @Inject
    private Event<BuildResults> buildResultsEvent;
    @Inject
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    @Inject
    private BuildExecutorServiceFactory executorServiceProducer;
    private ExecutorService executor;
    private boolean isIncrementalEnabled = false;

    @PostConstruct
    private void setup() {
        this.executor = this.executorServiceProducer.getExecutorService();
        this.isIncrementalEnabled = this.isIncrementalBuildEnabled();
    }

    public void configureOnEvent(@Observes ApplicationStarted applicationStartedEvent) {
        this.isIncrementalEnabled = this.isIncrementalBuildEnabled();
    }

    private boolean isIncrementalBuildEnabled() {
        String value = (String)this.appConfigService.loadPreferences().get(INCREMENTAL_BUILD_PROPERTY_NAME);
        return Boolean.parseBoolean(value);
    }

    @PreDestroy
    private void destroyExecutorService() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    logger.error("executor did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void addResource(final Path resource) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Incremental build request received for: " + resource.toURI() + " (added).");
        Package pkg = this.projectService.resolvePackage(resource);
        if (pkg == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Incremental build request being processed: " + resource.toURI() + " (added).");
                    Project project = ResourceChangeIncrementalBuilder.this.projectService.resolveProject(resource);
                    if (ResourceChangeIncrementalBuilder.this.buildService.isBuilt(project)) {
                        IncrementalBuildResults results = ResourceChangeIncrementalBuilder.this.buildService.addPackageResource(resource);
                        ResourceChangeIncrementalBuilder.this.incrementalBuildResultsEvent.fire((Object)results);
                    } else {
                        BuildResults results = ResourceChangeIncrementalBuilder.this.buildService.build(project);
                        ResourceChangeIncrementalBuilder.this.buildResultsEvent.fire((Object)results);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void deleteResource(final Path resource) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Incremental build request received for: " + resource.toURI() + " (deleted).");
        Package pkg = this.projectService.resolvePackage(resource);
        if (pkg == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Incremental build request being processed: " + resource.toURI() + " (deleted).");
                    Project project = ResourceChangeIncrementalBuilder.this.projectService.resolveProject(resource);
                    if (ResourceChangeIncrementalBuilder.this.buildService.isBuilt(project)) {
                        IncrementalBuildResults results = ResourceChangeIncrementalBuilder.this.buildService.deletePackageResource(resource);
                        ResourceChangeIncrementalBuilder.this.incrementalBuildResultsEvent.fire((Object)results);
                    } else {
                        BuildResults results = ResourceChangeIncrementalBuilder.this.buildService.build(project);
                        ResourceChangeIncrementalBuilder.this.buildResultsEvent.fire((Object)results);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void updateResource(Path resource) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Incremental build request received for: " + resource.toURI() + " (updated).");
        boolean isPomFile = this.projectService.isPom(resource);
        boolean isKModuleFile = this.projectService.isKModule(resource);
        if (isPomFile || isKModuleFile) {
            this.scheduleProjectResourceUpdate(resource);
        } else {
            Package pkg = this.projectService.resolvePackage(resource);
            if (pkg == null) {
                return;
            }
            this.schedulePackageResourceUpdate(resource);
        }
    }

    private void scheduleProjectResourceUpdate(Path resource) {
        final Project project = this.projectService.resolveProject(resource);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Incremental build request being processed: " + project.getRootPath() + " (updated).");
                    BuildResults results = ResourceChangeIncrementalBuilder.this.buildService.build(project);
                    ResourceChangeIncrementalBuilder.this.buildResultsEvent.fire((Object)results);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private void schedulePackageResourceUpdate(final Path resource) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Incremental build request being processed: " + resource.toURI() + " (updated).");
                    Project project = ResourceChangeIncrementalBuilder.this.projectService.resolveProject(resource);
                    if (ResourceChangeIncrementalBuilder.this.buildService.isBuilt(project)) {
                        IncrementalBuildResults results = ResourceChangeIncrementalBuilder.this.buildService.updatePackageResource(resource);
                        ResourceChangeIncrementalBuilder.this.incrementalBuildResultsEvent.fire((Object)results);
                    } else {
                        BuildResults results = ResourceChangeIncrementalBuilder.this.buildService.build(project);
                        ResourceChangeIncrementalBuilder.this.buildResultsEvent.fire((Object)results);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void batchResourceChanges(Map<Path, Collection<ResourceChange>> batch) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Batch incremental build request received.");
        HashMap projectBatchChanges = new HashMap();
        for (Map.Entry<Path, Collection<ResourceChange>> entry : batch.entrySet()) {
            for (ResourceChange change : entry.getValue()) {
                Map projectChanges;
                Path resource = entry.getKey();
                Project project = this.projectService.resolveProject(resource);
                Package pkg = this.projectService.resolvePackage(resource);
                if (project == null || pkg == null) continue;
                if (!projectBatchChanges.containsKey(project)) {
                    projectBatchChanges.put(project, new HashMap());
                }
                if (!(projectChanges = (Map)projectBatchChanges.get(project)).containsKey(entry.getKey())) {
                    projectChanges.put(entry.getKey(), new ArrayList());
                }
                ((Collection)projectChanges.get(entry.getKey())).add(change);
                logger.info("- Batch content: " + entry.getKey().toURI() + " (" + change.getType().toString() + ").");
            }
        }
        for (final Map.Entry<Object, Collection<Object>> entry : projectBatchChanges.entrySet()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.info("Batch incremental build request being processed.");
                        Project project = (Project)entry.getKey();
                        Map changes = (Map)entry.getValue();
                        if (ResourceChangeIncrementalBuilder.this.buildService.isBuilt(project)) {
                            IncrementalBuildResults results = ResourceChangeIncrementalBuilder.this.buildService.applyBatchResourceChanges(project, changes);
                            ResourceChangeIncrementalBuilder.this.incrementalBuildResultsEvent.fire((Object)results);
                        } else {
                            BuildResults results = ResourceChangeIncrementalBuilder.this.buildService.build(project);
                            ResourceChangeIncrementalBuilder.this.buildResultsEvent.fire((Object)results);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }
}

