/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.Role;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.impl.auth.UserNameCredential;
import org.uberfire.security.server.auth.source.adapter.RolesAdapter;

public class JACCAuthenticationSource
implements AuthenticationSource,
RoleProvider {
    public static final String DEFAULT_ROLE_PRINCIPLE_NAME = "Roles";
    private String rolePrincipleName = "Roles";
    private ServiceLoader<RolesAdapter> rolesAdapterServiceLoader = ServiceLoader.load(RolesAdapter.class);

    public void initialize(Map<String, ?> options) {
        if (options.containsKey("org.uf.context.roles")) {
            this.rolePrincipleName = (String)options.get("org.uf.context.roles");
        }
    }

    public boolean supportsCredential(Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential instanceof UserNameCredential;
    }

    public boolean authenticate(Credential credential, SecurityContext securityContext) {
        UserNameCredential userNameCredential = (UserNameCredential)Preconditions.checkInstanceOf((String)"credential", (Object)credential, UserNameCredential.class);
        try {
            Set<java.security.Principal> principals;
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            if (subject != null && (principals = subject.getPrincipals()) != null) {
                for (java.security.Principal p : principals) {
                    if (!p.getName().equals(userNameCredential.getUserName())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public List<Role> loadRoles(Principal principal) {
        ArrayList<Role> roles;
        block6: {
            roles = new ArrayList<Role>();
            try {
                Subject subject = this.getSubjectFromContainer();
                if (subject != null) {
                    Set<java.security.Principal> principals = subject.getPrincipals();
                    if (principals == null) break block6;
                    for (java.security.Principal p : principals) {
                        if (!(p instanceof Group) || !this.rolePrincipleName.equalsIgnoreCase(p.getName())) continue;
                        Enumeration groups = ((Group)p).members();
                        while (groups.hasMoreElements()) {
                            java.security.Principal groupPrincipal = (java.security.Principal)groups.nextElement();
                            roles.add((Role)new RoleImpl(groupPrincipal.getName()));
                        }
                        break block6;
                    }
                    break block6;
                }
                for (RolesAdapter adapter : this.rolesAdapterServiceLoader) {
                    List<Role> userRoles = adapter.getRoles(principal.getName());
                    if (userRoles == null) continue;
                    roles.addAll(userRoles);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return roles;
    }

    protected Subject getSubjectFromContainer() {
        try {
            return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        }
        catch (Exception e) {
            return null;
        }
    }
}

