/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.virtualfs;

import java.io.File;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.file.nativefs.NativeFileSystemView;
import org.apache.sshd.common.file.nativefs.NativeSshFile;

public class VirtualFileSystemView
extends NativeFileSystemView {
    private String location;

    public VirtualFileSystemView(String username, String location) {
        super(username);
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        this.location = location;
    }

    public String getVirtualUserDir() {
        return "/";
    }

    public String getPhysicalUserDir() {
        return this.location;
    }

    protected SshFile getFile(String dir, String file) {
        String location = this.getPhysicalUserDir();
        String physicalName = NativeSshFile.getPhysicalName(location, dir, file, false);
        File fileObj = new File(physicalName);
        String karafFileName = physicalName.substring(location.length());
        return this.createNativeSshFile(karafFileName, fileObj, this.getUserName());
    }
}

