/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement
public class CompleteWorkItemCommand
implements GenericCommand<Void> {
    @XmlAttribute(name="id", required=true)
    private long workItemId;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="result")
    private Map<String, Object> results = new HashMap<String, Object>();

    public CompleteWorkItemCommand() {
    }

    public CompleteWorkItemCommand(long workItemId) {
        this.workItemId = workItemId;
    }

    public CompleteWorkItemCommand(long workItemId, Map<String, Object> results) {
        this(workItemId);
        this.results = results;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void setWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public Map<String, Object> getResults() {
        return this.results;
    }

    public void setResults(Map<String, Object> results) {
        this.results = results;
    }

    @Override
    public Void execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        ksession.getWorkItemManager().completeWorkItem(this.workItemId, this.results);
        return null;
    }

    public String toString() {
        String result = "session.getWorkItemManager().completeWorkItem(" + this.workItemId + ", [";
        if (this.results != null) {
            int i = 0;
            for (Map.Entry<String, Object> entry : this.results.entrySet()) {
                if (i++ > 0) {
                    result = result + ", ";
                }
                result = result + entry.getKey() + "=" + entry.getValue();
            }
        }
        result = result + "]);";
        return result;
    }
}

