/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.LeftTupleSets;
import org.drools.core.reteoo.LeftTuple;

public class LeftTupleSetsImpl
implements LeftTupleSets {
    private LeftTuple insertFirst;
    private int insertSize;
    private LeftTuple deleteFirst;
    private int deleteSize;
    private LeftTuple updateFirst;
    private int updateSize;

    @Override
    public LeftTuple getInsertFirst() {
        return this.insertFirst;
    }

    @Override
    public LeftTuple getDeleteFirst() {
        return this.deleteFirst;
    }

    @Override
    public LeftTuple getUpdateFirst() {
        return this.updateFirst;
    }

    public void resetInsert() {
        this.insertFirst = null;
        this.insertSize = 0;
    }

    public void resetDelete() {
        this.deleteFirst = null;
        this.deleteSize = 0;
    }

    public void resetUpdate() {
        this.updateFirst = null;
        this.updateSize = 0;
    }

    @Override
    public void resetAll() {
        this.resetInsert();
        this.resetDelete();
        this.resetUpdate();
    }

    @Override
    public int insertSize() {
        return this.insertSize;
    }

    @Override
    public int deleteSize() {
        return this.deleteSize;
    }

    @Override
    public int updateSize() {
        return this.updateSize;
    }

    @Override
    public boolean addInsert(LeftTuple leftTuple) {
        if (leftTuple.getStagedType() == 2) {
            return false;
        }
        leftTuple.setStagedType((short)1);
        if (this.insertFirst == null) {
            this.insertFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.insertFirst);
            this.insertFirst.setStagePrevious(leftTuple);
            this.insertFirst = leftTuple;
        }
        return this.insertSize++ == 0;
    }

    @Override
    public boolean addDelete(LeftTuple leftTuple) {
        switch (leftTuple.getStagedType()) {
            case 1: {
                this.removeInsert(leftTuple);
                return this.deleteSize == 0;
            }
            case 2: {
                this.removeUpdate(leftTuple);
            }
        }
        leftTuple.setStagedType((short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.deleteFirst);
            this.deleteFirst.setStagePrevious(leftTuple);
            this.deleteFirst = leftTuple;
        }
        return this.deleteSize++ == 0;
    }

    @Override
    public boolean addUpdate(LeftTuple leftTuple) {
        if (leftTuple.getStagedType() == 1) {
            return false;
        }
        leftTuple.setStagedType((short)2);
        if (this.updateFirst == null) {
            this.updateFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.updateFirst);
            this.updateFirst.setStagePrevious(leftTuple);
            this.updateFirst = leftTuple;
        }
        return this.updateSize++ == 0;
    }

    @Override
    public void removeInsert(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.insertFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.insertFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.insertSize;
        leftTuple.clearStaged();
    }

    @Override
    public void removeDelete(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.deleteFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.deleteFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.deleteSize;
        leftTuple.clearStaged();
    }

    @Override
    public void removeUpdate(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.updateFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.updateFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        leftTuple.clearStaged();
        --this.updateSize;
    }

    @Override
    public void addAllInserts(LeftTupleSets tupleSets) {
        LeftTupleSetsImpl tupleSetsImpl = (LeftTupleSetsImpl)tupleSets;
        if (tupleSetsImpl.getInsertFirst() != null) {
            if (this.insertFirst == null) {
                this.insertFirst = tupleSetsImpl.getInsertFirst();
                this.insertSize = tupleSetsImpl.insertSize;
            } else {
                LeftTuple last = null;
                for (LeftTuple current = this.insertFirst; current != null; current = current.getStagedNext()) {
                    last = current;
                }
                LeftTuple leftTuple = tupleSetsImpl.getInsertFirst();
                last.setStagedNext(leftTuple);
                leftTuple.setStagePrevious(last);
                this.insertSize += tupleSetsImpl.insertSize();
            }
            tupleSetsImpl.insertSize = 0;
            tupleSetsImpl.insertFirst = null;
        }
    }

    @Override
    public void addAllDeletes(LeftTupleSets tupleSets) {
        LeftTupleSetsImpl tupleSetsImpl = (LeftTupleSetsImpl)tupleSets;
        if (tupleSetsImpl.getDeleteFirst() != null) {
            if (this.deleteFirst == null) {
                this.deleteFirst = tupleSetsImpl.getDeleteFirst();
                this.deleteSize = tupleSetsImpl.deleteSize;
            } else {
                LeftTuple last = null;
                for (LeftTuple current = this.deleteFirst; current != null; current = current.getStagedNext()) {
                    last = current;
                }
                LeftTuple leftTuple = tupleSets.getDeleteFirst();
                last.setStagedNext(leftTuple);
                leftTuple.setStagePrevious(last);
                this.deleteSize += tupleSetsImpl.deleteSize();
            }
            tupleSetsImpl.deleteFirst = null;
            tupleSetsImpl.deleteSize = 0;
        }
    }

    @Override
    public void addAllUpdates(LeftTupleSets tupleSets) {
        LeftTupleSetsImpl tupleSetsImpl = (LeftTupleSetsImpl)tupleSets;
        if (tupleSetsImpl.getUpdateFirst() != null) {
            if (this.updateFirst == null) {
                this.updateFirst = tupleSetsImpl.getUpdateFirst();
                this.updateSize = tupleSetsImpl.updateSize;
            } else {
                LeftTuple last = null;
                for (LeftTuple current = this.updateFirst; current != null; current = current.getStagedNext()) {
                    last = current;
                }
                LeftTuple leftTuple = tupleSetsImpl.getUpdateFirst();
                last.setStagedNext(leftTuple);
                leftTuple.setStagePrevious(last);
                this.updateSize += tupleSetsImpl.updateSize();
            }
            tupleSetsImpl.updateFirst = null;
            tupleSetsImpl.updateSize = 0;
        }
    }

    @Override
    public void addAll(LeftTupleSets source) {
        this.addAllInserts(source);
        this.addAllDeletes(source);
        this.addAllUpdates(source);
    }

    @Override
    public LeftTupleSets takeAll() {
        LeftTupleSetsImpl clone = new LeftTupleSetsImpl();
        clone.insertSize = this.insertSize;
        clone.deleteSize = this.deleteSize;
        clone.updateSize = this.updateSize;
        clone.insertFirst = this.insertFirst;
        clone.deleteFirst = this.deleteFirst;
        clone.updateFirst = this.updateFirst;
        this.insertSize = 0;
        this.deleteSize = 0;
        this.updateSize = 0;
        this.insertFirst = null;
        this.deleteFirst = null;
        this.updateFirst = null;
        return clone;
    }

    public void clear() {
        LeftTuple next;
        LeftTuple leftTuple = this.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = this.getDeleteFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = this.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        this.resetAll();
    }

    @Override
    public boolean isEmpty() {
        return this.getInsertFirst() == null && this.getDeleteFirst() == null && this.getUpdateFirst() == null;
    }

    @Override
    public String toStringSizes() {
        return "TupleSets[insertSize=" + this.insertSize + ", deleteSize=" + this.deleteSize + ", updateSize=" + this.updateSize + "]";
    }

    public String toString() {
        LeftTuple leftTuple;
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        for (leftTuple = this.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(" " + leftTuple + "\n");
        }
        sbuilder.append("Deleted:\n");
        for (leftTuple = this.getDeleteFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(" " + leftTuple + "\n");
        }
        sbuilder.append("Updated:\n");
        for (leftTuple = this.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(" " + leftTuple + "\n");
        }
        return sbuilder.toString();
    }
}

