/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.base.DroolsQuery;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.PropagationContext;
import org.kie.api.runtime.rule.Variable;

public class PhreakQueryNode {
    public void doNode(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, StackEntry stackEntry, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(qmem, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(queryNode, qmem, sink, wm, srcLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(queryNode, qmem, stackEntry, wm, srcLeftTuples);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, StackEntry stackEntry, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            PropagationContext pCtx = leftTuple.getPropagationContext();
            InternalFactHandle handle = queryNode.createFactHandle(pCtx, wm, leftTuple);
            DroolsQuery dquery = queryNode.createDroolsQuery(leftTuple, handle, stackEntry, qmem.getSegmentMemory().getPathMemories(), qmem, qmem.getResultLeftTuples(), stackEntry.getSink(), wm);
            LeftInputAdapterNode lian = (LeftInputAdapterNode)qmem.getQuerySegmentMemory().getRootNode();
            LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories().get(0);
            LeftInputAdapterNode.doInsertObject(handle, pCtx, lian, wm, lm, false, dquery.isOpen());
            this.flushTupleQuery(lm, wm);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(QueryElementNode queryNode, QueryElementNode.QueryElementNodeMemory qmem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            InternalFactHandle fh = (InternalFactHandle)leftTuple.getObject();
            DroolsQuery dquery = (DroolsQuery)fh.getObject();
            Object[] argTemplate = queryNode.getQueryElement().getArgTemplate();
            Object[] args = new Object[argTemplate.length];
            System.arraycopy(argTemplate, 0, args, 0, args.length);
            int[] declIndexes = queryNode.getQueryElement().getDeclIndexes();
            int length = declIndexes.length;
            for (int i = 0; i < length; ++i) {
                Object o;
                Declaration declr = (Declaration)argTemplate[declIndexes[i]];
                Object tupleObject = leftTuple.get(declr).getObject();
                if (tupleObject instanceof DroolsQuery) {
                    ArrayElementReader arrayReader = (ArrayElementReader)declr.getExtractor();
                    o = ((DroolsQuery)tupleObject).getVariables()[arrayReader.getIndex()] != null ? Variable.v : declr.getValue(wm, tupleObject);
                } else {
                    o = declr.getValue(wm, tupleObject);
                }
                args[declIndexes[i]] = o;
            }
            int[] varIndexes = queryNode.getQueryElement().getVariableIndexes();
            int length2 = varIndexes.length;
            for (int i = 0; i < length2; ++i) {
                if (argTemplate[varIndexes[i]] != Variable.v) continue;
                args[varIndexes[i]] = Variable.v;
            }
            dquery.setParameters(args);
            ((QueryElementNode.UnificationNodeViewChangedEventListener)dquery.getQueryResultCollector()).setVariables(varIndexes);
            SegmentMemory qsmem = qmem.getQuerySegmentMemory();
            LeftInputAdapterNode lian = (LeftInputAdapterNode)qsmem.getRootNode();
            LeftInputAdapterNode.LiaNodeMemory lmem = (LeftInputAdapterNode.LiaNodeMemory)qsmem.getNodeMemories().getFirst();
            if (dquery.isOpen()) {
                LeftTuple childLeftTuple = fh.getFirstLeftTuple();
                LeftInputAdapterNode.doUpdateObject(childLeftTuple, childLeftTuple.getPropagationContext(), wm, lian, false, lmem, qmem.getQuerySegmentMemory());
                this.flushTupleQuery(lmem, wm);
            } else {
                if (fh.getFirstLeftTuple() != null) {
                    throw new RuntimeException("defensive programming while testing");
                }
                LeftInputAdapterNode.LiaNodeMemory lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories().get(0);
                LeftInputAdapterNode.doInsertObject(fh, leftTuple.getPropagationContext(), lian, wm, lm, false, dquery.isOpen());
                this.flushTupleQuery(lm, wm);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(QueryElementNode.QueryElementNodeMemory qmem, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftInputAdapterNode.LiaNodeMemory lm;
            LeftTuple next = leftTuple.getStagedNext();
            InternalFactHandle fh = (InternalFactHandle)leftTuple.getObject();
            DroolsQuery dquery = (DroolsQuery)fh.getObject();
            if (dquery.isOpen()) {
                LeftInputAdapterNode lian = (LeftInputAdapterNode)qmem.getQuerySegmentMemory().getRootNode();
                lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories().get(0);
                LeftTuple childLeftTuple = fh.getFirstLeftTuple();
                LeftInputAdapterNode.doDeleteObject(childLeftTuple, childLeftTuple.getPropagationContext(), qmem.getQuerySegmentMemory(), wm, lian, false, lm);
                this.flushTupleQuery(lm, wm);
            } else {
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    lm = (LeftInputAdapterNode.LiaNodeMemory)qmem.getQuerySegmentMemory().getNodeMemories().get(0);
                    this.flushTupleQuery(lm, wm);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void flushTupleQuery(LeftInputAdapterNode.LiaNodeMemory lm, InternalWorkingMemory wm) {
        if (lm.getSegmentMemory().getTupleQueue() != null) {
            RuleExecutor.flushTupleQueue(lm.getSegmentMemory().getTupleQueue());
        }
    }
}

