/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJBException;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import org.jboss.ejb3.api.spi.EJBContainerWrapper;

public abstract class EJBContainer {
    public static final String EMBEDDABLE_APP_NAME_PROPERTY = "javax.ejb.embeddable.appName";
    public static final String EMBEDDABLE_INITIAL_PROPERTY = "javax.ejb.embeddable.initial";
    @Deprecated
    public static final String EMBEDDABLE_INITIAL = "javax.ejb.embeddable.initial";
    public static final String EMBEDDABLE_MODULES_PROPERTY = "javax.ejb.embeddable.modules";
    private static EJBContainerWrapper currentEJBContainer;
    private static final Pattern nonCommentPattern;
    private static List<EJBContainerProvider> factories;

    public abstract void close();

    public static EJBContainer createEJBContainer() throws EJBException {
        return EJBContainer.createEJBContainer(null);
    }

    public static EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        for (EJBContainerProvider factory : factories) {
            EJBContainer container = factory.createEJBContainer(properties);
            if (container == null) continue;
            currentEJBContainer = new EJBContainerWrapper(container);
            return currentEJBContainer;
        }
        throw new EJBException("Unable to instantiate container with factories " + factories);
    }

    private static List<String> factoryNamesFromReader(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> names = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m = nonCommentPattern.matcher(line = line.trim());
            if (!m.find()) continue;
            names.add(m.group().trim());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findAllFactories() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources("META-INF/services/" + EJBContainerProvider.class.getName());
            HashSet<String> names = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                try {
                    names.addAll(EJBContainer.factoryNamesFromReader(new BufferedReader(new InputStreamReader(is))));
                }
                finally {
                    is.close();
                }
            }
            for (String s : names) {
                Class<?> factoryClass = loader.loadClass(s);
                factories.add((EJBContainerProvider)EJBContainerProvider.class.cast(factoryClass.newInstance()));
            }
        }
        catch (IOException e) {
            throw new EJBException(e);
        }
        catch (InstantiationException e) {
            throw new EJBException(e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException(e);
        }
        catch (ClassNotFoundException e) {
            throw new EJBException(e);
        }
    }

    @Deprecated
    public static EJBContainer getCurrentEJBContainer() {
        if (currentEJBContainer != null && currentEJBContainer.isClosed()) {
            return null;
        }
        return currentEJBContainer;
    }

    public Context getContext() {
        throw new UnsupportedOperationException(this + " does not support a naming context");
    }

    static {
        nonCommentPattern = Pattern.compile("^([^#]+)");
        factories = new ArrayList<EJBContainerProvider>();
        EJBContainer.findAllFactories();
    }
}

