/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.backend.lucene;

import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.uberfire.metadata.MetadataConfig;
import org.uberfire.metadata.backend.lucene.fields.FieldFactory;
import org.uberfire.metadata.backend.lucene.index.LuceneIndexEngine;
import org.uberfire.metadata.backend.lucene.index.LuceneIndexFactory;
import org.uberfire.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.metadata.backend.lucene.search.LuceneSearchIndex;
import org.uberfire.metadata.engine.IndexManager;
import org.uberfire.metadata.engine.Indexer;
import org.uberfire.metadata.engine.MetaIndexEngine;
import org.uberfire.metadata.engine.MetaModelStore;
import org.uberfire.metadata.search.SearchIndex;

public class LuceneConfig
implements MetadataConfig {
    private final MetaModelStore metaModelStore;
    private final FieldFactory fieldFactory;
    private final LuceneIndexManager indexManager;
    private final Analyzer analyzer;
    private final LuceneSearchIndex searchIndex;
    private final LuceneIndexEngine indexEngine;
    private final Set<Indexer> indexers;

    public LuceneConfig(MetaModelStore metaModelStore, FieldFactory fieldFactory, LuceneIndexFactory indexFactory, Set<Indexer> indexers, Analyzer analyzer) {
        this.metaModelStore = metaModelStore;
        this.fieldFactory = fieldFactory;
        this.indexManager = new LuceneIndexManager(indexFactory);
        this.analyzer = analyzer;
        this.searchIndex = new LuceneSearchIndex(this.indexManager, this.analyzer);
        this.indexEngine = new LuceneIndexEngine(this.fieldFactory, this.metaModelStore, this.indexManager);
        this.indexers = indexers;
    }

    public SearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    public MetaIndexEngine getIndexEngine() {
        return this.indexEngine;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public MetaModelStore getMetaModelStore() {
        return this.metaModelStore;
    }

    public Set<Indexer> getIndexers() {
        return this.indexers;
    }

    public void dispose() {
        this.indexEngine.dispose();
        this.indexManager.dispose();
        this.metaModelStore.dispose();
        this.analyzer.close();
    }
}

