/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.backend.lucene.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.metadata.backend.lucene.fields.FieldFactory;
import org.uberfire.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.metadata.backend.lucene.index.LuceneIndexManager;
import org.uberfire.metadata.engine.Index;
import org.uberfire.metadata.engine.MetaIndexEngine;
import org.uberfire.metadata.engine.MetaModelStore;
import org.uberfire.metadata.model.KCluster;
import org.uberfire.metadata.model.KObject;
import org.uberfire.metadata.model.KObjectKey;
import org.uberfire.metadata.model.KProperty;
import org.uberfire.metadata.model.schema.MetaObject;
import org.uberfire.metadata.model.schema.MetaProperty;
import org.uberfire.metadata.model.schema.MetaType;

public class LuceneIndexEngine
implements MetaIndexEngine {
    private final FieldFactory fieldFactory;
    private final MetaModelStore metaModelStore;
    private final LuceneIndexManager indexManager;
    private final Map<KCluster, AtomicInteger> batchMode = new ConcurrentHashMap<KCluster, AtomicInteger>();
    private final Collection<Runnable> beforeDispose = new ArrayList<Runnable>();

    public LuceneIndexEngine(FieldFactory fieldFactory, MetaModelStore metaModelStore, LuceneIndexManager indexManager) {
        this.fieldFactory = (FieldFactory)Preconditions.checkNotNull((String)"fieldFactory", (Object)fieldFactory);
        this.metaModelStore = (MetaModelStore)Preconditions.checkNotNull((String)"metaModelStore", (Object)metaModelStore);
        this.indexManager = (LuceneIndexManager)Preconditions.checkNotNull((String)"indexManager", (Object)indexManager);
    }

    public boolean freshIndex(KCluster cluster) {
        Index index = this.indexManager.get(cluster);
        if (index == null) {
            return !this.batchMode.containsKey(cluster);
        }
        return index.freshIndex();
    }

    public void startBatch(KCluster cluster) {
        AtomicInteger batchStack = this.batchMode.get(cluster);
        if (batchStack == null) {
            this.batchMode.put(cluster, new AtomicInteger());
        } else if (batchStack.get() < 0) {
            batchStack.set(1);
        } else {
            batchStack.incrementAndGet();
        }
    }

    public void index(KObject object) {
        this.updateMetaModel(object);
        LuceneIndex index = this.indexManager.indexOf((KObjectKey)object);
        index.indexDocument(object.getId(), this.newDocument(object));
        this.commitIfNotBatchMode(index.getCluster());
    }

    private Document newDocument(KObject object) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", object.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("type", object.getType().getName(), Field.Store.YES));
        doc.add((IndexableField)new TextField("key", object.getKey(), Field.Store.YES));
        doc.add((IndexableField)new StringField("cluster.id", object.getClusterId(), Field.Store.YES));
        doc.add((IndexableField)new StringField("segment.id", object.getSegmentId(), Field.Store.YES));
        StringBuilder allText = new StringBuilder(object.getKey()).append('\n');
        for (KProperty property : object.getProperties()) {
            IndexableField[] fields;
            for (IndexableField field : fields = this.fieldFactory.build(property)) {
                doc.add(field);
                if (!(field instanceof TextField) || property.getValue() instanceof Boolean) continue;
                allText.append(field.stringValue()).append('\n');
            }
        }
        doc.add((IndexableField)new TextField("fullText", allText.toString().toLowerCase(), Field.Store.NO));
        return doc;
    }

    public void index(KObject ... objects) {
        for (KObject object : objects) {
            this.index(object);
        }
    }

    public void rename(KObjectKey from, KObject to) {
        Preconditions.checkNotNull((String)"from", (Object)from);
        Preconditions.checkNotNull((String)"to", (Object)to);
        Preconditions.checkCondition((String)"renames are allowed only from same cluster", (boolean)from.getClusterId().equals(to.getClusterId()));
        LuceneIndex index = this.indexManager.indexOf(from);
        index.rename(from.getId(), this.newDocument(to));
        this.commitIfNotBatchMode(index.getCluster());
    }

    public void delete(KCluster cluster) {
        this.indexManager.delete(cluster);
    }

    public void delete(KObjectKey objectKey) {
        LuceneIndex index = this.indexManager.indexOf(objectKey);
        index.deleteIfExists(objectKey.getId());
        this.commitIfNotBatchMode(index.getCluster());
    }

    public void delete(KObjectKey ... objectsKey) {
        HashMap<LuceneIndex, 1> execution = new HashMap<LuceneIndex, 1>();
        for (final KObjectKey key : objectsKey) {
            LuceneIndex index = this.indexManager.indexOf(key);
            List ids = (List)execution.get(index);
            if (ids == null) {
                execution.put(index, new ArrayList<String>(){
                    {
                        this.add(key.getId());
                    }
                });
                continue;
            }
            ids.add(key.getId());
        }
        for (Map.Entry entry : execution.entrySet()) {
            ((LuceneIndex)entry.getKey()).deleteIfExists(((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
    }

    public void commit(KCluster cluster) {
        Index index = this.indexManager.get(cluster);
        if (index == null) {
            return;
        }
        AtomicInteger batchStack = this.batchMode.get(cluster);
        if (batchStack != null) {
            int value = batchStack.decrementAndGet();
            if (value <= 0) {
                index.commit();
                this.batchMode.remove(cluster);
            }
        } else {
            index.commit();
        }
    }

    private synchronized void commitIfNotBatchMode(KCluster cluster) {
        AtomicInteger batchStack = this.batchMode.get(cluster);
        if (batchStack == null || batchStack.get() <= 0) {
            this.commit(cluster);
        }
    }

    public void dispose() {
        if (!this.beforeDispose.isEmpty()) {
            for (Runnable activeDispose : this.beforeDispose) {
                activeDispose.run();
            }
        }
    }

    public void beforeDispose(Runnable callback) {
        this.beforeDispose.add((Runnable)Preconditions.checkNotNull((String)"callback", (Object)callback));
    }

    private void updateMetaModel(KObject object) {
        MetaObject metaObject = this.metaModelStore.getMetaObject(object.getType().getName());
        if (metaObject == null) {
            this.metaModelStore.add(this.newMetaObect(object));
        } else {
            for (KProperty property : object.getProperties()) {
                MetaProperty metaProperty = metaObject.getProperty(property.getName());
                if (metaProperty == null) {
                    metaObject.addProperty(this.newMetaProperty(property));
                    continue;
                }
                metaProperty.addType(property.getValue().getClass());
                if (!property.isSearchable()) continue;
                metaProperty.setAsSearchable();
            }
            this.metaModelStore.update(metaObject);
        }
    }

    private MetaObject newMetaObect(final KObject object) {
        final HashSet<MetaProperty> properties = new HashSet<MetaProperty>();
        for (KProperty property : object.getProperties()) {
            properties.add(this.newMetaProperty(property));
        }
        return new MetaObject(){
            private final Map<String, MetaProperty> propertyMap = new ConcurrentHashMap<String, MetaProperty>(){
                {
                    for (MetaProperty property : properties) {
                        this.put(property.getName(), property);
                    }
                }
            };

            public MetaType getType() {
                return object.getType();
            }

            public Collection<MetaProperty> getProperties() {
                return this.propertyMap.values();
            }

            public MetaProperty getProperty(String name) {
                return this.propertyMap.get(name);
            }

            public void addProperty(MetaProperty metaProperty) {
                if (!this.propertyMap.containsKey(metaProperty.getName())) {
                    this.propertyMap.put(metaProperty.getName(), metaProperty);
                }
            }
        };
    }

    private MetaProperty newMetaProperty(final KProperty<?> property) {
        return new MetaProperty(){
            private boolean isSearchable;
            private Set<Class<?>> types;
            {
                this.isSearchable = property.isSearchable();
                this.types = new CopyOnWriteArraySet<Class<?>>(){
                    {
                        this.add(property.getValue().getClass());
                    }
                };
            }

            public String getName() {
                return property.getName();
            }

            public Set<Class<?>> getTypes() {
                return this.types;
            }

            public boolean isSearchable() {
                return this.isSearchable;
            }

            public void setAsSearchable() {
                this.isSearchable = true;
            }

            public void addType(Class<?> type) {
                this.types.add(type);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof MetaProperty)) {
                    return false;
                }
                return ((MetaProperty)obj).getName().equals(this.getName());
            }

            public int hashCode() {
                return this.getName().hashCode();
            }
        };
    }
}

