/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.uberfire.backend.server.AsyncWatchService;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ExecutorManager {
    @Inject
    private Event<ResourceBatchChangesEvent> resourceBatchChanges;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Event<ResourceRenamedEvent> resourceRenamedEvent;
    @Inject
    private Event<ResourceDeletedEvent> resourceDeletedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    private AtomicBoolean useExecService = new AtomicBoolean(false);

    @Asynchronous
    public void execute(final AsyncWatchService watchService) {
        if (this.useExecService.get()) {
            new Thread("WatchService"){

                @Override
                public void run() {
                    watchService.execute((Event<ResourceBatchChangesEvent>)ExecutorManager.this.resourceBatchChanges, (Event<ResourceUpdatedEvent>)ExecutorManager.this.resourceUpdatedEvent, (Event<ResourceRenamedEvent>)ExecutorManager.this.resourceRenamedEvent, (Event<ResourceDeletedEvent>)ExecutorManager.this.resourceDeletedEvent, (Event<ResourceAddedEvent>)ExecutorManager.this.resourceAddedEvent);
                }
            }.start();
        } else {
            watchService.execute(this.resourceBatchChanges, this.resourceUpdatedEvent, this.resourceRenamedEvent, this.resourceDeletedEvent, this.resourceAddedEvent);
        }
    }

    public void setEvents(Event<ResourceBatchChangesEvent> resourceBatchChanges, Event<ResourceUpdatedEvent> resourceUpdatedEvent, Event<ResourceRenamedEvent> resourceRenamedEvent, Event<ResourceDeletedEvent> resourceDeletedEvent, Event<ResourceAddedEvent> resourceAddedEvent) {
        this.resourceBatchChanges = resourceBatchChanges;
        this.resourceUpdatedEvent = resourceUpdatedEvent;
        this.resourceRenamedEvent = resourceRenamedEvent;
        this.resourceDeletedEvent = resourceDeletedEvent;
        this.resourceAddedEvent = resourceAddedEvent;
        this.useExecService.set(true);
    }
}

