/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.nativefs;

import java.io.File;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.file.nativefs.NativeSshFile;
import org.apache.sshd.common.file.nativefs.NativeSshFileNio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeFileSystemView
implements FileSystemView {
    private final Logger LOG = LoggerFactory.getLogger(NativeFileSystemView.class);
    private String currDir;
    private String userName;
    private boolean caseInsensitive = false;
    static boolean isJava7;
    static boolean isWindows;

    protected NativeFileSystemView(String userName) {
        this(userName, false);
    }

    public NativeFileSystemView(String userName, boolean caseInsensitive) {
        if (userName == null) {
            throw new IllegalArgumentException("user can not be null");
        }
        this.caseInsensitive = caseInsensitive;
        this.currDir = this.getVirtualUserDir();
        this.userName = userName;
        this.LOG.debug("Native filesystem view created for user \"{}\" with root \"{}\"", (Object)userName, (Object)this.currDir);
    }

    public String getUserName() {
        return this.userName;
    }

    public SshFile getFile(String file) {
        return this.getFile(this.currDir, file);
    }

    public SshFile getFile(SshFile baseDir, String file) {
        return this.getFile(baseDir.getAbsolutePath(), file);
    }

    protected SshFile getFile(String dir, String file) {
        String physicalName = NativeSshFile.getPhysicalName(this.getPhysicalUserDir(), dir, file, this.caseInsensitive);
        File fileObj = new File(physicalName);
        String userFileName = physicalName.substring(this.getPhysicalUserDir().length() - 1);
        return this.createNativeSshFile(userFileName, fileObj, this.userName);
    }

    public String getPhysicalUserDir() {
        return "/";
    }

    public String getVirtualUserDir() {
        return System.getProperty("user.dir");
    }

    public NativeSshFile createNativeSshFile(String fileName2, File fileObj, String userName2) {
        if (isJava7 && !isWindows) {
            return new NativeSshFileNio(this, fileName2, fileObj, userName2);
        }
        return new NativeSshFile(this, fileName2, fileObj, userName2);
    }

    static {
        boolean j7 = false;
        try {
            ClassLoader.getSystemClassLoader().loadClass("java.nio.file.Files");
            j7 = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        isJava7 = j7;
        boolean win = false;
        try {
            win = System.getProperty("os.name").toLowerCase().contains("win");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isWindows = win;
    }
}

