/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.sftp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.IoUtils;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpSubsystem
implements Command,
Runnable,
SessionAware,
FileSystemAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String MAX_OPEN_HANDLES_PER_SESSION = "max-open-handles-per-session";
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 3;
    public static final String ALL_SFTP_IMPL = "3";
    public static final int MAX_PACKET_LENGTH = 16384;
    public static final int SSH_FXP_INIT = 1;
    public static final int SSH_FXP_VERSION = 2;
    public static final int SSH_FXP_OPEN = 3;
    public static final int SSH_FXP_CLOSE = 4;
    public static final int SSH_FXP_READ = 5;
    public static final int SSH_FXP_WRITE = 6;
    public static final int SSH_FXP_LSTAT = 7;
    public static final int SSH_FXP_FSTAT = 8;
    public static final int SSH_FXP_SETSTAT = 9;
    public static final int SSH_FXP_FSETSTAT = 10;
    public static final int SSH_FXP_OPENDIR = 11;
    public static final int SSH_FXP_READDIR = 12;
    public static final int SSH_FXP_REMOVE = 13;
    public static final int SSH_FXP_MKDIR = 14;
    public static final int SSH_FXP_RMDIR = 15;
    public static final int SSH_FXP_REALPATH = 16;
    public static final int SSH_FXP_STAT = 17;
    public static final int SSH_FXP_RENAME = 18;
    public static final int SSH_FXP_READLINK = 19;
    public static final int SSH_FXP_SYMLINK = 20;
    public static final int SSH_FXP_STATUS = 101;
    public static final int SSH_FXP_HANDLE = 102;
    public static final int SSH_FXP_DATA = 103;
    public static final int SSH_FXP_NAME = 104;
    public static final int SSH_FXP_ATTRS = 105;
    public static final int SSH_FXP_EXTENDED = 200;
    public static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    public static final int SSH_FILEXFER_ATTR_SIZE = 1;
    public static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    public static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    public static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    public static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FXF_READ = 1;
    public static final int SSH_FXF_WRITE = 2;
    public static final int SSH_FXF_APPEND = 4;
    public static final int SSH_FXF_CREAT = 8;
    public static final int SSH_FXF_TRUNC = 16;
    public static final int SSH_FXF_EXCL = 32;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private ExitCallback callback;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private Environment env;
    private ServerSession session;
    private boolean closed = false;
    private FileSystemView root;
    private int version;
    private Map<String, Handle> handles = new HashMap<String, Handle>();
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    @Override
    public void setSession(ServerSession session) {
        this.session = session;
    }

    @Override
    public void setFileSystemView(FileSystemView view) {
        this.root = view;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void start(Environment env) throws IOException {
        this.env = env;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(this.in);
                while (true) {
                    int l;
                    int length;
                    if ((length = dis.readInt()) < 5) {
                        throw new IllegalArgumentException();
                    }
                    Buffer buffer = new Buffer(length + 4);
                    buffer.putInt(length);
                    for (int nb = length; nb > 0; nb -= l) {
                        l = dis.read(buffer.array(), buffer.wpos(), nb);
                        if (l < 0) {
                            throw new IllegalArgumentException();
                        }
                        buffer.wpos(buffer.wpos() + l);
                    }
                    this.process(buffer);
                }
            }
            catch (Throwable t) {
                if (!this.closed && !(t instanceof EOFException)) {
                    this.log.error("Exception caught in SFTP subsystem", t);
                }
                Object var7_7 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Could not close DataInputStream", (Throwable)ioe);
                    }
                }
                if (this.handles != null) {
                    for (Map.Entry<String, Handle> entry : this.handles.entrySet()) {
                        Handle handle = entry.getValue();
                        try {
                            handle.close();
                        }
                        catch (IOException ioe) {
                            this.log.error("Could not close open handle: " + entry.getKey(), (Throwable)ioe);
                        }
                    }
                }
                dis = null;
                this.callback.onExit(0);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {
                    this.log.error("Could not close DataInputStream", (Throwable)ioe);
                }
            }
            if (this.handles != null) {
                for (Map.Entry<String, Handle> entry : this.handles.entrySet()) {
                    Handle handle = entry.getValue();
                    try {
                        handle.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Could not close open handle: " + entry.getKey(), (Throwable)ioe);
                    }
                }
            }
            dis = null;
            this.callback.onExit(0);
            throw throwable;
        }
    }

    protected void process(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        switch (type) {
            case 1: {
                this.log.debug("Received SSH_FXP_INIT (version={})", (Object)this.version);
                if (length != 5) {
                    throw new IllegalArgumentException();
                }
                this.version = id;
                if (this.version >= 3) {
                    this.version = Math.min(this.version, 3);
                    buffer.clear();
                    buffer.putByte((byte)2);
                    buffer.putInt(this.version);
                    this.send(buffer);
                    break;
                }
                this.sendStatus(id, 8, "SFTP server only support versions 3");
                break;
            }
            case 3: {
                String maxHandlesString;
                if (this.session.getFactoryManager().getProperties() != null && (maxHandlesString = this.session.getFactoryManager().getProperties().get(MAX_OPEN_HANDLES_PER_SESSION)) != null) {
                    int maxHandleCount = Integer.parseInt(maxHandlesString);
                    if (this.handles.size() > maxHandleCount) {
                        this.sendStatus(id, 4, "Too many open handles");
                        break;
                    }
                }
                String path = buffer.getString();
                int pflags = buffer.getInt();
                Map<SshFile.Attribute, Object> attrs = this.readAttrs(buffer);
                this.log.debug("Received SSH_FXP_OPEN (path={}, pflags={}, attrs={})", new Object[]{path, pflags, attrs});
                try {
                    SshFile file = this.resolveFile(path);
                    if (file.doesExist()) {
                        if ((pflags & 8) != 0 && (pflags & 0x20) != 0) {
                            this.sendStatus(id, 4, path);
                            return;
                        }
                    } else if ((pflags & 8) != 0) {
                        if (!file.isWritable()) {
                            this.sendStatus(id, 3, "Can not create " + path);
                            return;
                        }
                        file.create();
                    }
                    String acc = ((pflags & 3) != 0 ? "r" : "") + ((pflags & 2) != 0 ? "w" : "");
                    if ((pflags & 0x10) != 0) {
                        file.truncate();
                    }
                    if ((pflags & 8) != 0) {
                        file.setAttributes(attrs);
                    }
                    String handle = UUID.randomUUID().toString();
                    this.handles.put(handle, new FileHandle(file));
                    this.sendHandle(id, handle);
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage() == null ? "" : e.getMessage());
                }
                break;
            }
            case 4: {
                String handle = buffer.getString();
                this.log.debug("Received SSH_FXP_CLOSE (handle={})", (Object)handle);
                try {
                    Handle h = this.handles.get(handle);
                    if (h == null) {
                        this.sendStatus(id, 4, handle, "");
                        break;
                    }
                    this.handles.remove(handle);
                    h.close();
                    this.sendStatus(id, 0, "", "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 5: {
                String handle = buffer.getString();
                long offset = buffer.getLong();
                int len = buffer.getInt();
                this.log.debug("Received SSH_FXP_READ (handle={}, offset={}, length={})", new Object[]{handle, offset, len});
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof FileHandle)) {
                        this.sendStatus(id, 4, handle);
                        break;
                    }
                    FileHandle fh = (FileHandle)p;
                    byte[] b = new byte[Math.min(len, 65536)];
                    if ((len = fh.read(b, offset)) >= 0) {
                        Buffer buf = new Buffer(len + 5);
                        buf.putByte((byte)103);
                        buf.putInt(id);
                        buf.putBytes(b, 0, len);
                        this.send(buf);
                        break;
                    }
                    this.sendStatus(id, 1, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 6: {
                String handle = buffer.getString();
                long offset = buffer.getLong();
                byte[] data = buffer.getBytes();
                this.log.debug("Received SSH_FXP_WRITE (handle={}, offset={}, data=byte[{}])", new Object[]{handle, offset, data.length});
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof FileHandle)) {
                        this.sendStatus(id, 4, handle);
                        break;
                    }
                    FileHandle fh = (FileHandle)p;
                    fh.write(data, offset);
                    SshFile sshFile = fh.getFile();
                    sshFile.setLastModified(new Date().getTime());
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 7: {
                String path = buffer.getString();
                this.log.debug("Received SSH_FXP_LSTAT (path={})", (Object)path);
                try {
                    SshFile p = this.resolveFile(path);
                    this.sendAttrs(id, p, false);
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 8: {
                String handle = buffer.getString();
                this.log.debug("Received SSH_FXP_FSTAT (handle={})", (Object)handle);
                try {
                    Handle p = this.handles.get(handle);
                    if (p == null) {
                        this.sendStatus(id, 4, handle);
                        break;
                    }
                    this.sendAttrs(id, p.getFile(), true);
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 9: {
                String path = buffer.getString();
                Map<SshFile.Attribute, Object> attrs = this.readAttrs(buffer);
                this.log.debug("Received SSH_FXP_SETSTAT (path={}, attrs={})", (Object)path, attrs);
                try {
                    SshFile p = this.resolveFile(path);
                    p.setAttributes(attrs);
                    this.sendStatus(id, 0, "");
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                catch (UnsupportedOperationException e) {
                    this.sendStatus(id, 4, "");
                }
                break;
            }
            case 10: {
                String handle = buffer.getString();
                Map<SshFile.Attribute, Object> attrs = this.readAttrs(buffer);
                this.log.debug("Received SSH_FXP_FSETSTAT (handle={}, attrs={})", (Object)handle, attrs);
                try {
                    Handle p = this.handles.get(handle);
                    if (p == null) {
                        this.sendStatus(id, 4, handle);
                        break;
                    }
                    p.getFile().setAttributes(attrs);
                    this.sendStatus(id, 0, "");
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                catch (UnsupportedOperationException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 11: {
                String path = buffer.getString();
                this.log.debug("Received SSH_FXP_OPENDIR (path={})", (Object)path);
                try {
                    SshFile p = this.resolveFile(path);
                    if (!p.doesExist()) {
                        this.sendStatus(id, 2, path);
                        break;
                    }
                    if (!p.isDirectory()) {
                        this.sendStatus(id, 2, path);
                        break;
                    }
                    if (!p.isReadable()) {
                        this.sendStatus(id, 3, path);
                        break;
                    }
                    String handle = UUID.randomUUID().toString();
                    this.handles.put(handle, new DirectoryHandle(p));
                    this.sendHandle(id, handle);
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 12: {
                String handle = buffer.getString();
                this.log.debug("Received SSH_FXP_READDIR (handle={})", (Object)handle);
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof DirectoryHandle)) {
                        this.sendStatus(id, 4, handle);
                        break;
                    }
                    if (((DirectoryHandle)p).isDone()) {
                        this.sendStatus(id, 1, "", "");
                        break;
                    }
                    if (!p.getFile().doesExist()) {
                        this.sendStatus(id, 2, p.getFile().getAbsolutePath());
                        break;
                    }
                    if (!p.getFile().isDirectory()) {
                        this.sendStatus(id, 2, p.getFile().getAbsolutePath());
                        break;
                    }
                    if (!p.getFile().isReadable()) {
                        this.sendStatus(id, 3, p.getFile().getAbsolutePath());
                        break;
                    }
                    DirectoryHandle dh = (DirectoryHandle)p;
                    if (dh.hasNext()) {
                        this.sendName(id, dh);
                        if (dh.hasNext()) break;
                        dh.setDone(true);
                        dh.clearFileList();
                        break;
                    }
                    dh.setDone(true);
                    dh.clearFileList();
                    this.sendStatus(id, 1, "", "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 13: {
                String path = buffer.getString();
                this.log.debug("Received SSH_FXP_REMOVE (path={})", (Object)path);
                try {
                    SshFile p = this.resolveFile(path);
                    if (!p.doesExist()) {
                        this.sendStatus(id, 2, p.getAbsolutePath());
                        break;
                    }
                    if (p.isDirectory()) {
                        this.sendStatus(id, 2, p.getAbsolutePath());
                        break;
                    }
                    if (!p.delete()) {
                        this.sendStatus(id, 4, "Failed to delete file");
                        break;
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 14: {
                String path = buffer.getString();
                Map<SshFile.Attribute, Object> attrs = this.readAttrs(buffer);
                this.log.debug("Received SSH_FXP_MKDIR (path={})", (Object)path);
                try {
                    SshFile p = this.resolveFile(path);
                    if (p.doesExist()) {
                        if (p.isDirectory()) {
                            this.sendStatus(id, 4, p.getAbsolutePath());
                            break;
                        }
                        this.sendStatus(id, 2, p.getAbsolutePath());
                        break;
                    }
                    if (!p.isWritable()) {
                        this.sendStatus(id, 3, p.getAbsolutePath());
                        break;
                    }
                    if (!p.mkdir()) {
                        throw new IOException("Error creating dir " + path);
                    }
                    p.setAttributes(attrs);
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 15: {
                String path = buffer.getString();
                this.log.debug("Received SSH_FXP_RMDIR (path={})", (Object)path);
                try {
                    SshFile p = this.resolveFile(path);
                    if (p.isDirectory()) {
                        if (p.doesExist()) {
                            if (p.listSshFiles().size() == 0) {
                                if (p.delete()) {
                                    this.sendStatus(id, 0, "");
                                    break;
                                }
                                this.sendStatus(id, 4, "Unable to delete directory " + path);
                                break;
                            }
                            this.sendStatus(id, 4, path);
                            break;
                        }
                        this.sendStatus(id, 2, path);
                        break;
                    }
                    this.sendStatus(id, 2, p.getAbsolutePath());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 16: {
                String path = buffer.getString();
                this.log.debug("Received SSH_FXP_REALPATH (path={})", (Object)path);
                if (path.trim().length() == 0) {
                    path = ".";
                }
                try {
                    SshFile p = this.resolveFile(path);
                    this.sendPath(id, p);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 17: {
                String path = buffer.getString();
                this.log.debug("Received SSH_FXP_STAT (path={})", (Object)path);
                try {
                    SshFile p = this.resolveFile(path);
                    this.sendAttrs(id, p, true);
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 18: {
                String oldPath = buffer.getString();
                String newPath = buffer.getString();
                this.log.debug("Received SSH_FXP_RENAME (oldPath={}, newPath={})", (Object)oldPath, (Object)newPath);
                try {
                    SshFile o = this.resolveFile(oldPath);
                    SshFile n = this.resolveFile(newPath);
                    if (!o.doesExist()) {
                        this.sendStatus(id, 2, o.getAbsolutePath());
                        break;
                    }
                    if (n.doesExist()) {
                        this.sendStatus(id, 4, n.getAbsolutePath());
                        break;
                    }
                    if (!o.move(n)) {
                        this.sendStatus(id, 4, "Failed to rename file");
                        break;
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 19: {
                String path = buffer.getString();
                this.log.debug("Received SSH_FXP_READLINK (path={})", (Object)path);
                try {
                    SshFile f = this.resolveFile(path);
                    String l = f.readSymbolicLink();
                    this.sendLink(id, l);
                }
                catch (UnsupportedOperationException e) {
                    this.sendStatus(id, 8, "Command " + type + " is unsupported or not implemented");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            default: {
                this.log.error("Received: {}", (Object)type);
                this.sendStatus(id, 8, "Command " + type + " is unsupported or not implemented");
            }
        }
    }

    protected void sendHandle(int id, String handle) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)102);
        buffer.putInt(id);
        buffer.putString(handle);
        this.send(buffer);
    }

    protected void sendAttrs(int id, SshFile file, boolean followLinks) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, file, followLinks);
        this.send(buffer);
    }

    protected void sendPath(int id, SshFile f) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        String normalizedPath = SelectorUtils.normalizePath(f.getAbsolutePath(), "/");
        if (normalizedPath.length() == 0) {
            normalizedPath = "/";
        }
        buffer.putString(normalizedPath);
        f = this.resolveFile(normalizedPath);
        if (f.getName().length() == 0) {
            f = this.resolveFile(".");
        }
        buffer.putString(this.getLongName(f));
        buffer.putInt(0L);
        this.send(buffer);
    }

    protected void sendLink(int id, String link) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        buffer.putString(link);
        buffer.putString(link);
        buffer.putInt(0L);
        this.send(buffer);
    }

    protected void sendName(int id, Iterator<SshFile> files) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt(id);
        int wpos = buffer.wpos();
        buffer.putInt(0L);
        int nb = 0;
        while (files.hasNext() && buffer.wpos() < 16384) {
            SshFile f = files.next();
            buffer.putString(f.getName());
            buffer.putString(this.getLongName(f));
            this.writeAttrs(buffer, f, false);
            ++nb;
        }
        int oldpos = buffer.wpos();
        buffer.wpos(wpos);
        buffer.putInt(nb);
        buffer.wpos(oldpos);
        this.send(buffer);
    }

    private String getLongName(SshFile f) throws IOException {
        Map<SshFile.Attribute, Object> attributes = f.getAttributes(true);
        String username = (String)attributes.get((Object)SshFile.Attribute.Owner);
        if (username.length() > 8) {
            username = username.substring(0, 8);
        } else {
            for (int i = username.length(); i < 8; ++i) {
                username = username + " ";
            }
        }
        String group = (String)attributes.get((Object)SshFile.Attribute.Group);
        if (group.length() > 8) {
            group = group.substring(0, 8);
        } else {
            for (int i = group.length(); i < 8; ++i) {
                group = group + " ";
            }
        }
        long length = (Long)attributes.get((Object)SshFile.Attribute.Size);
        String lengthString = String.format("%1$8s", length);
        boolean isDirectory = (Boolean)attributes.get((Object)SshFile.Attribute.IsDirectory);
        boolean isLink = (Boolean)attributes.get((Object)SshFile.Attribute.IsSymbolicLink);
        int perms = this.getPermissions(attributes);
        StringBuilder sb = new StringBuilder();
        sb.append(isDirectory ? "d" : (isLink ? "l" : "-"));
        sb.append((perms & 0x100) != 0 ? "r" : "-");
        sb.append((perms & 0x80) != 0 ? "w" : "-");
        sb.append((perms & 0x40) != 0 ? "x" : "-");
        sb.append((perms & 0x20) != 0 ? "r" : "-");
        sb.append((perms & 0x10) != 0 ? "w" : "-");
        sb.append((perms & 8) != 0 ? "x" : "-");
        sb.append((perms & 4) != 0 ? "r" : "-");
        sb.append((perms & 2) != 0 ? "w" : "-");
        sb.append((perms & 1) != 0 ? "x" : "-");
        sb.append(" ");
        sb.append("  1");
        sb.append(" ");
        sb.append(username);
        sb.append(" ");
        sb.append(group);
        sb.append(" ");
        sb.append(lengthString);
        sb.append(" ");
        sb.append(SftpSubsystem.getUnixDate((Long)attributes.get((Object)SshFile.Attribute.LastModifiedTime)));
        sb.append(" ");
        sb.append(f.getName());
        return sb.toString();
    }

    protected Map<SshFile.Attribute, Object> getPermissions(int perms) {
        HashMap<SshFile.Attribute, Object> attrs = new HashMap<SshFile.Attribute, Object>();
        if ((perms & 0xF000) == 32768) {
            attrs.put(SshFile.Attribute.IsRegularFile, Boolean.TRUE);
        }
        if ((perms & 0xF000) == 16384) {
            attrs.put(SshFile.Attribute.IsDirectory, Boolean.TRUE);
        }
        if ((perms & 0xF000) == 40960) {
            attrs.put(SshFile.Attribute.IsSymbolicLink, Boolean.TRUE);
        }
        EnumSet<SshFile.Permission> p = EnumSet.noneOf(SshFile.Permission.class);
        if ((perms & 0x100) != 0) {
            p.add(SshFile.Permission.UserRead);
        }
        if ((perms & 0x80) != 0) {
            p.add(SshFile.Permission.UserWrite);
        }
        if ((perms & 0x40) != 0) {
            p.add(SshFile.Permission.UserExecute);
        }
        if ((perms & 0x20) != 0) {
            p.add(SshFile.Permission.GroupRead);
        }
        if ((perms & 0x10) != 0) {
            p.add(SshFile.Permission.GroupWrite);
        }
        if ((perms & 8) != 0) {
            p.add(SshFile.Permission.GroupExecute);
        }
        if ((perms & 4) != 0) {
            p.add(SshFile.Permission.OthersRead);
        }
        if ((perms & 2) != 0) {
            p.add(SshFile.Permission.OthersWrite);
        }
        if ((perms & 1) != 0) {
            p.add(SshFile.Permission.OthersExecute);
        }
        attrs.put(SshFile.Attribute.Permissions, p);
        return attrs;
    }

    protected int getPermissions(Map<SshFile.Attribute, Object> attributes) {
        boolean isReg = (Boolean)attributes.get((Object)SshFile.Attribute.IsRegularFile);
        boolean isDir = (Boolean)attributes.get((Object)SshFile.Attribute.IsDirectory);
        boolean isLnk = (Boolean)attributes.get((Object)SshFile.Attribute.IsSymbolicLink);
        int pf = 0;
        EnumSet perms = (EnumSet)attributes.get((Object)SshFile.Attribute.Permissions);
        for (SshFile.Permission p : perms) {
            switch (p) {
                case UserRead: {
                    pf |= 0x100;
                    break;
                }
                case UserWrite: {
                    pf |= 0x80;
                    break;
                }
                case UserExecute: {
                    pf |= 0x40;
                    break;
                }
                case GroupRead: {
                    pf |= 0x20;
                    break;
                }
                case GroupWrite: {
                    pf |= 0x10;
                    break;
                }
                case GroupExecute: {
                    pf |= 8;
                    break;
                }
                case OthersRead: {
                    pf |= 4;
                    break;
                }
                case OthersWrite: {
                    pf |= 2;
                    break;
                }
                case OthersExecute: {
                    pf |= 1;
                }
            }
        }
        pf |= isReg ? 32768 : 0;
        pf |= isDir ? 16384 : 0;
        return pf |= isLnk ? 40960 : 0;
    }

    protected void writeAttrs(Buffer buffer, SshFile file, boolean followLinks) throws IOException {
        if (!file.doesExist()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        Map<SshFile.Attribute, Object> attributes = file.getAttributes(followLinks);
        boolean isReg = this.getBool((Boolean)attributes.get((Object)SshFile.Attribute.IsRegularFile));
        boolean isDir = this.getBool((Boolean)attributes.get((Object)SshFile.Attribute.IsDirectory));
        boolean isLnk = this.getBool((Boolean)attributes.get((Object)SshFile.Attribute.IsSymbolicLink));
        int flags = 0;
        if ((isReg || isLnk) && attributes.containsKey((Object)SshFile.Attribute.Size)) {
            flags |= 1;
        }
        if (attributes.containsKey((Object)SshFile.Attribute.Uid) && attributes.containsKey((Object)SshFile.Attribute.Gid)) {
            flags |= 2;
        }
        if (attributes.containsKey((Object)SshFile.Attribute.Permissions)) {
            flags |= 4;
        }
        if (attributes.containsKey((Object)SshFile.Attribute.LastAccessTime) && attributes.containsKey((Object)SshFile.Attribute.LastModifiedTime)) {
            flags |= 8;
        }
        buffer.putInt(flags);
        if ((flags & 1) != 0) {
            buffer.putLong((Long)attributes.get((Object)SshFile.Attribute.Size));
        }
        if ((flags & 2) != 0) {
            buffer.putInt(((Integer)attributes.get((Object)SshFile.Attribute.Uid)).intValue());
            buffer.putInt(((Integer)attributes.get((Object)SshFile.Attribute.Gid)).intValue());
        }
        if ((flags & 4) != 0) {
            buffer.putInt(this.getPermissions(attributes));
        }
        if ((flags & 8) != 0) {
            buffer.putInt((Long)attributes.get((Object)SshFile.Attribute.LastAccessTime) / 1000L);
            buffer.putInt((Long)attributes.get((Object)SshFile.Attribute.LastModifiedTime) / 1000L);
        }
    }

    protected boolean getBool(Boolean bool) {
        return bool != null && bool != false;
    }

    protected Map<SshFile.Attribute, Object> readAttrs(Buffer buffer) throws IOException {
        HashMap<SshFile.Attribute, Object> attrs = new HashMap<SshFile.Attribute, Object>();
        int flags = buffer.getInt();
        if ((flags & 1) != 0) {
            attrs.put(SshFile.Attribute.Size, buffer.getLong());
        }
        if ((flags & 2) != 0) {
            attrs.put(SshFile.Attribute.Uid, buffer.getInt());
            attrs.put(SshFile.Attribute.Gid, buffer.getInt());
        }
        if ((flags & 4) != 0) {
            attrs.putAll(this.getPermissions(buffer.getInt()));
        }
        if ((flags & 8) != 0) {
            attrs.put(SshFile.Attribute.LastAccessTime, (long)buffer.getInt() * 1000L);
            attrs.put(SshFile.Attribute.LastModifiedTime, (long)buffer.getInt() * 1000L);
        }
        return attrs;
    }

    protected void sendStatus(int id, int substatus, String msg) throws IOException {
        this.sendStatus(id, substatus, msg, "");
    }

    protected void sendStatus(int id, int substatus, String msg, String lang) throws IOException {
        this.log.debug("Send SSH_FXP_STATUS (substatus={}, msg={})", (Object)substatus, (Object)msg);
        Buffer buffer = new Buffer();
        buffer.putByte((byte)101);
        buffer.putInt(id);
        buffer.putInt(substatus);
        buffer.putString(msg);
        buffer.putString(lang);
        this.send(buffer);
    }

    protected void send(Buffer buffer) throws IOException {
        DataOutputStream dos = new DataOutputStream(this.out);
        dos.writeInt(buffer.available());
        dos.write(buffer.array(), buffer.rpos(), buffer.available());
        dos.flush();
    }

    @Override
    public void destroy() {
        this.closed = true;
    }

    private SshFile resolveFile(String path) {
        return this.root.getFile(path);
    }

    private static final String getUnixDate(long millis) {
        if (millis < 0L) {
            return "------------";
        }
        StringBuffer sb = new StringBuffer(16);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(MONTHS[cal.get(2)]);
        sb.append(' ');
        int day = cal.get(5);
        if (day < 10) {
            sb.append(' ');
        }
        sb.append(day);
        sb.append(' ');
        long sixMonth = 15811200000L;
        long nowTime = System.currentTimeMillis();
        if (Math.abs(nowTime - millis) > sixMonth) {
            int year = cal.get(1);
            sb.append(' ');
            sb.append(year);
        } else {
            int hh = cal.get(11);
            if (hh < 10) {
                sb.append('0');
            }
            sb.append(hh);
            sb.append(':');
            int mm = cal.get(12);
            if (mm < 10) {
                sb.append('0');
            }
            sb.append(mm);
        }
        return sb.toString();
    }

    protected static class FileHandle
    extends Handle {
        OutputStream output;
        long outputPos;
        InputStream input;
        long inputPos;
        long length;

        public FileHandle(SshFile sshFile) {
            super(sshFile);
        }

        public int read(byte[] data, long offset) throws IOException {
            if (this.input != null && offset >= this.length) {
                return -1;
            }
            if (this.input != null && offset != this.inputPos) {
                IoUtils.closeQuietly(this.input);
                this.input = null;
            }
            if (this.input == null) {
                this.input = this.file.createInputStream(offset);
                this.length = this.file.getSize();
                this.inputPos = offset;
            }
            if (offset >= this.length) {
                return -1;
            }
            int read = this.input.read(data);
            this.inputPos += (long)read;
            return read;
        }

        public void write(byte[] data, long offset) throws IOException {
            if (this.output != null && offset != this.outputPos) {
                IoUtils.closeQuietly(this.output);
                this.output = null;
            }
            if (this.output == null) {
                this.output = this.file.createOutputStream(offset);
            }
            this.output.write(data);
            this.outputPos += (long)data.length;
        }

        public void close() throws IOException {
            IoUtils.closeQuietly(this.output, this.input);
            this.output = null;
            this.input = null;
            super.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DirectoryHandle
    extends Handle
    implements Iterator<SshFile> {
        boolean done;
        List<SshFile> fileList = null;
        int fileIndex;

        public DirectoryHandle(SshFile file) {
            super(file);
            this.fileList = file.listSshFiles();
            this.fileIndex = 0;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        @Override
        public boolean hasNext() {
            return this.fileIndex < this.fileList.size();
        }

        @Override
        public SshFile next() {
            SshFile f = this.fileList.get(this.fileIndex);
            ++this.fileIndex;
            return f;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void clearFileList() {
            this.fileList = null;
        }
    }

    protected static abstract class Handle {
        SshFile file;

        public Handle(SshFile file) {
            this.file = file;
        }

        public SshFile getFile() {
            return this.file;
        }

        public void close() throws IOException {
            this.file.handleClose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Command> {
        @Override
        public Command create() {
            return new SftpSubsystem();
        }

        @Override
        public String getName() {
            return "sftp";
        }
    }
}

