/*
 * Decompiled with CFR 0.152.
 */
package org.kie.config.cli.support;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.config.SecureConfigItem;
import org.guvnor.structure.server.repositories.RepositoryFactoryHelper;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class SimplifiedGitRepoHelper
implements RepositoryFactoryHelper {
    @Inject
    private PasswordService secureService;

    public boolean accept(ConfigGroup repoConfig) {
        PortablePreconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        PortablePreconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        return "git".equals(schemeConfigItem.getValue());
    }

    public Repository newRepository(ConfigGroup repoConfig) {
        PortablePreconditions.checkNotNull((String)"repoConfig", (Object)repoConfig);
        ConfigItem schemeConfigItem = repoConfig.getConfigItem("scheme");
        PortablePreconditions.checkNotNull((String)"schemeConfigItem", (Object)schemeConfigItem);
        String branch = repoConfig.getConfigItemValue("branch");
        if (branch == null) {
            branch = "master";
        }
        GitRepository repo = new GitRepository(repoConfig.getName());
        repo.setCurrentBranch(branch);
        for (ConfigItem item : repoConfig.getItems()) {
            if (item instanceof SecureConfigItem) {
                repo.addEnvironmentParameter(item.getName(), (Object)this.secureService.decrypt(item.getValue().toString()));
                continue;
            }
            repo.addEnvironmentParameter(item.getName(), item.getValue());
        }
        if (!repo.isValid()) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " not valid");
        }
        return repo;
    }
}

