/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.service.Option;

public class UserExplorerLastData {
    public static final UserExplorerLastData EMPTY = new UserExplorerLastData();
    private LastPackage lastPackage = null;
    private LastFolderItem lastFolderItem = null;
    private Set<Option> options = new HashSet<Option>();

    public boolean isDataEmpty() {
        return this.lastPackage == null && this.lastFolderItem == null;
    }

    public boolean isEmpty() {
        return this.isDataEmpty() && this.options.isEmpty();
    }

    public void setFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Project project, FolderItem item) {
        this.lastFolderItem = new LastFolderItem(organizationalUnit, repository, project, item);
    }

    public void setPackage(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg) {
        this.lastPackage = new LastPackage(organizationalUnit, repository, project, pkg);
    }

    public void setOptions(Set<Option> options) {
        this.options.clear();
        this.options.addAll(options);
    }

    public LastPackage getLastPackage() {
        return this.lastPackage;
    }

    public LastFolderItem getLastFolderItem() {
        return this.lastFolderItem;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean deleteProject(Project project) {
        boolean changed = false;
        if (this.lastPackage != null && this.lastPackage.getProject().equals((Object)project)) {
            this.lastPackage = null;
            changed = true;
        }
        if (this.lastFolderItem != null && this.lastFolderItem.getProject().equals((Object)project)) {
            this.lastFolderItem = null;
            changed = true;
        }
        return changed;
    }

    static class LastFolderItem {
        OrganizationalUnit organizationalUnit;
        Repository repository;
        Project project;
        FolderItem item;

        LastFolderItem() {
        }

        LastFolderItem(OrganizationalUnit organizationalUnit, Repository repository, Project project, FolderItem item) {
            this.organizationalUnit = organizationalUnit;
            this.repository = repository;
            this.project = project;
            this.item = item;
        }

        OrganizationalUnit getOrganizationalUnit() {
            return this.organizationalUnit;
        }

        Repository getRepository() {
            return this.repository;
        }

        Project getProject() {
            return this.project;
        }

        FolderItem getItem() {
            return this.item;
        }
    }

    static class LastPackage {
        OrganizationalUnit organizationalUnit;
        Repository repository;
        Project project;
        Package pkg;

        LastPackage() {
        }

        LastPackage(OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg) {
            this.organizationalUnit = organizationalUnit;
            this.repository = repository;
            this.project = project;
            this.pkg = pkg;
        }

        OrganizationalUnit getOrganizationalUnit() {
            return this.organizationalUnit;
        }

        Repository getRepository() {
            return this.repository;
        }

        Project getProject() {
            return this.project;
        }

        Package getPkg() {
            return this.pkg;
        }
    }
}

