/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.config.watch;

import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.config.OrgUnit;
import org.guvnor.structure.backend.config.Repository;
import org.guvnor.structure.backend.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.backend.config.watch.AsyncWatchServiceCallback;
import org.guvnor.structure.backend.config.watch.ConfigServiceWatchServiceExecutor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchKey;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ConfigServiceWatchServiceExecutorImpl
implements ConfigServiceWatchServiceExecutor {
    @Inject
    @Named(value="system")
    private org.guvnor.structure.repositories.Repository systemRepository;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Repository
    private Event<SystemRepositoryChangedEvent> repoChangedEvent;
    @Inject
    @OrgUnit
    private Event<SystemRepositoryChangedEvent> orgUnitChangedEvent;
    @Inject
    private Event<SystemRepositoryChangedEvent> changedEvent;

    public void setConfig(org.guvnor.structure.repositories.Repository systemRepository, IOService ioService, Event<SystemRepositoryChangedEvent> repoChangedEvent, Event<SystemRepositoryChangedEvent> orgUnitChangedEvent, Event<SystemRepositoryChangedEvent> changedEvent) {
        this.systemRepository = systemRepository;
        this.ioService = ioService;
        this.repoChangedEvent = repoChangedEvent;
        this.orgUnitChangedEvent = orgUnitChangedEvent;
        this.changedEvent = changedEvent;
    }

    @Override
    public void execute(WatchKey watchKey, long localLastModifiedValue, AsyncWatchServiceCallback callback) {
        long currentValue = this.getLastModified();
        if (currentValue > localLastModifiedValue) {
            callback.callback(currentValue);
            this.repoChangedEvent.fire((Object)new SystemRepositoryChangedEvent());
            this.orgUnitChangedEvent.fire((Object)new SystemRepositoryChangedEvent());
            this.changedEvent.fire((Object)new SystemRepositoryChangedEvent());
        }
    }

    private long getLastModified() {
        Path lastModifiedPath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(".lastmodified");
        return this.ioService.getLastModifiedTime(lastModifiedPath).toMillis();
    }
}

