/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.ConstraintItem;
import org.apache.log4j.Logger;

public class ConstraintItemBuilder {
    private static Logger LOG = Logger.getLogger(ConstraintItemBuilder.class);
    final Map<ClusterConstraints.ConstraintAttribute, String> _attributes = new TreeMap<ClusterConstraints.ConstraintAttribute, String>();
    String _constraintValue = null;

    public ConstraintItemBuilder addConstraintAttribute(String attribute, String value) {
        block10: {
            try {
                ClusterConstraints.ConstraintAttribute attr = ClusterConstraints.ConstraintAttribute.valueOf(attribute.toUpperCase());
                if (attr == ClusterConstraints.ConstraintAttribute.CONSTRAINT_VALUE) {
                    try {
                        ClusterConstraints.ConstraintValue.valueOf(value);
                        if (this._constraintValue == null) {
                            LOG.info((Object)("overwrite existing constraint-value. old-value: " + this._constraintValue + ", new-value: " + value));
                        }
                        this._constraintValue = value;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            Integer.parseInt(value);
                            if (this._constraintValue == null) {
                                LOG.info((Object)("overwrite existing constraint-value. old-value: " + this._constraintValue + ", new-value: " + value));
                            }
                            this._constraintValue = value;
                            break block10;
                        }
                        catch (NumberFormatException ne) {
                            LOG.error((Object)("fail to add constraint attribute. Invalid constraintValue. " + attribute + ": " + attribute + ", value: " + value));
                        }
                    }
                    break block10;
                }
                if (this._attributes.containsKey((Object)attr)) {
                    LOG.info((Object)("overwrite existing constraint attribute. attribute: " + attribute + ", old-value: " + this._attributes.get((Object)attr) + ", new-value: " + value));
                }
                this._attributes.put(attr, value);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)("fail to add constraint attribute. Invalid attribute type. attribute: " + attribute + ", value: " + value));
            }
        }
        return this;
    }

    public ConstraintItemBuilder addConstraintAttributes(Map<String, String> attributes) {
        for (String attr : attributes.keySet()) {
            this.addConstraintAttribute(attr, attributes.get(attr));
        }
        return this;
    }

    public Map<ClusterConstraints.ConstraintAttribute, String> getAttributes() {
        return this._attributes;
    }

    public String getConstraintValue() {
        return this._constraintValue;
    }

    public ConstraintItem build() {
        return new ConstraintItem(this._attributes, this._constraintValue);
    }
}

