/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.Enricher;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="enrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EnrichDefinition
extends NoOutputDefinition<EnrichDefinition> {
    @XmlAttribute(name="uri")
    private String resourceUri;
    @XmlAttribute(name="ref")
    private String resourceRef;
    @XmlAttribute(name="strategyRef")
    private String aggregationStrategyRef;
    @XmlAttribute(name="strategyMethodName")
    private String aggregationStrategyMethodName;
    @XmlAttribute(name="strategyMethodAllowNull")
    private Boolean aggregationStrategyMethodAllowNull;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public EnrichDefinition() {
        this(null, null);
    }

    public EnrichDefinition(String resourceUri) {
        this(null, resourceUri);
    }

    public EnrichDefinition(AggregationStrategy aggregationStrategy, String resourceUri) {
        this.aggregationStrategy = aggregationStrategy;
        this.resourceUri = resourceUri;
    }

    public String toString() {
        return "Enrich[" + this.description() + " " + this.aggregationStrategy + "]";
    }

    protected String description() {
        return FromDefinition.description(this.resourceUri, this.resourceRef, null);
    }

    @Override
    public String getLabel() {
        return "enrich[" + this.description() + "]";
    }

    @Override
    public String getShortName() {
        return "enrich";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (ObjectHelper.isEmpty(this.resourceUri) && ObjectHelper.isEmpty(this.resourceRef)) {
            throw new IllegalArgumentException("Either uri or ref must be provided for resource endpoint");
        }
        Endpoint endpoint = this.resourceUri != null ? routeContext.resolveEndpoint(this.resourceUri) : routeContext.resolveEndpoint(null, this.resourceRef);
        Enricher enricher = new Enricher(null, endpoint.createProducer());
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        if (strategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(strategy);
        }
        return enricher;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.aggregationStrategyRef != null) {
            Object aggStrategy = routeContext.lookup(this.aggregationStrategyRef, Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.getAggregationStrategyMethodName());
                if (this.getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.getAggregationStrategyMethodAllowNull());
                    adapter.setAllowNullOldExchange(this.getAggregationStrategyMethodAllowNull());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + this.aggregationStrategyRef);
            }
        }
        if (strategy != null && strategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)strategy)).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public String getResourceRef() {
        return this.resourceRef;
    }

    public void setResourceRef(String resourceRef) {
        this.resourceRef = resourceRef;
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.aggregationStrategyRef = aggregationStrategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public Boolean getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(Boolean aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }
}

