/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Repository;

@Dependent
public class POMContentHandler {
    private static String MULTI_MODULE = "pom";
    private static String PACKAGING = "kjar";
    private static String KIE_PLUGIN_VERSION_FILENAME = "/kie-plugin-version.properties";
    private static String KIE_PLUGIN_VERSION_PROPERTY_NAME = "kie_plugin_version";
    private static String kieMavenPluginGroupId = "org.kie";
    private static String kieMavenPluginArtifactId = "kie-maven-plugin";
    private static String kieMavenPluginVersion = POMContentHandler.getKiePluginVersion();
    private static Plugin kieMavenPlugin = POMContentHandler.getKieMavenPlugin();

    public String toString(POM pomModel) throws IOException {
        return this.toString(pomModel, new Model());
    }

    private String toString(POM pom, Model model) throws IOException {
        model.setName(pom.getName());
        model.setDescription(pom.getDescription());
        model.setArtifactId(pom.getGav().getArtifactId());
        model.setModelVersion(pom.getModelVersion());
        if (pom.isMultiModule()) {
            model.setPackaging(MULTI_MODULE);
            model.setGroupId(pom.getGav().getGroupId());
            model.setVersion(pom.getGav().getVersion());
            model.getModules().clear();
            for (String module : pom.getModules()) {
                model.addModule(module);
            }
            model.getRepositories().clear();
            for (Repository repository : pom.getRepositories()) {
                model.addRepository(this.fromClientModelToPom(repository));
            }
        } else {
            model.setPackaging(PACKAGING);
            if (pom.getParent() != null) {
                Parent parent = new Parent();
                parent.setGroupId(pom.getParent().getGroupId());
                parent.setArtifactId(pom.getParent().getArtifactId());
                parent.setVersion(pom.getParent().getVersion());
                model.setParent(parent);
            }
            model.setGroupId(pom.getGav().getGroupId());
            model.setVersion(pom.getGav().getVersion());
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            if (!build.getPlugins().contains(kieMavenPlugin)) {
                build.addPlugin(kieMavenPlugin);
            }
            model.getDependencies().clear();
            for (org.guvnor.common.services.project.model.Dependency dependency : pom.getDependencies()) {
                model.addDependency(this.fromClientModelToPom(dependency));
            }
        }
        StringWriter stringWriter = new StringWriter();
        new MavenXpp3Writer().write((Writer)stringWriter, model);
        return stringWriter.toString();
    }

    public String toString(POM gavModel, String originalPomAsText) throws IOException, XmlPullParserException {
        return this.toString(gavModel, new MavenXpp3Reader().read((Reader)new StringReader(originalPomAsText)));
    }

    private org.apache.maven.model.Repository fromClientModelToPom(Repository from) {
        org.apache.maven.model.Repository to = new org.apache.maven.model.Repository();
        to.setId(from.getId());
        to.setName(from.getName());
        to.setUrl(from.getUrl());
        return to;
    }

    public POM toModel(String pomAsString) throws IOException, XmlPullParserException {
        Model model = new MavenXpp3Reader().read((Reader)new StringReader(pomAsString));
        POM gavModel = new POM(model.getName(), model.getDescription(), new GAV(model.getGroupId() == null ? model.getParent().getGroupId() : model.getGroupId(), model.getArtifactId() == null ? model.getParent().getArtifactId() : model.getArtifactId(), model.getVersion() == null ? model.getParent().getVersion() : model.getVersion()));
        if (model.getParent() != null) {
            gavModel.setParent(new GAV(model.getParent().getGroupId(), model.getParent().getArtifactId(), model.getParent().getVersion()));
        }
        gavModel.getModules().clear();
        for (String module : model.getModules()) {
            gavModel.getModules().add(module);
            gavModel.setMultiModule(true);
        }
        for (org.apache.maven.model.Repository repository : model.getRepositories()) {
            gavModel.addRepository(this.fromPomModelToClientModel(repository));
        }
        for (Dependency dependency : model.getDependencies()) {
            gavModel.getDependencies().add(this.fromPomModelToClientModel(dependency));
        }
        return gavModel;
    }

    private Repository fromPomModelToClientModel(org.apache.maven.model.Repository from) {
        Repository to = new Repository();
        to.setId(from.getId());
        to.setName(from.getName());
        to.setUrl(from.getUrl());
        return to;
    }

    private org.guvnor.common.services.project.model.Dependency fromPomModelToClientModel(Dependency from) {
        org.guvnor.common.services.project.model.Dependency dependency = new org.guvnor.common.services.project.model.Dependency();
        dependency.setArtifactId(from.getArtifactId());
        dependency.setGroupId(from.getGroupId());
        dependency.setVersion(from.getVersion());
        return dependency;
    }

    private Dependency fromClientModelToPom(org.guvnor.common.services.project.model.Dependency from) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(from.getArtifactId());
        dependency.setGroupId(from.getGroupId());
        dependency.setVersion(from.getVersion());
        return dependency;
    }

    private static Plugin getKieMavenPlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId(kieMavenPluginGroupId);
        plugin.setArtifactId(kieMavenPluginArtifactId);
        plugin.setVersion(kieMavenPluginVersion);
        plugin.setExtensions(true);
        return plugin;
    }

    public static String getKiePluginVersion() {
        Properties p = new Properties();
        try {
            p.load(POMContentHandler.class.getResourceAsStream(KIE_PLUGIN_VERSION_FILENAME));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p.getProperty(KIE_PLUGIN_VERSION_PROPERTY_NAME);
    }
}

