/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.compiler.RuleBuildWarning;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELObjectExpressionBuilder;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.TypeResolver;
import org.drools.core.base.mvel.MVELObjectExpression;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.Salience;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.impl.CronExpression;
import org.drools.core.time.impl.CronTimer;
import org.drools.core.time.impl.ExpressionIntervalTimer;
import org.drools.core.time.impl.IntervalTimer;
import org.drools.core.time.impl.Timer;
import org.drools.core.type.DateFormats;
import org.drools.core.util.DateUtils;
import org.drools.core.util.MVELSafeHelper;
import org.drools.core.util.StringUtils;
import org.kie.api.definition.rule.ActivationListener;
import org.kie.api.definition.rule.DataDriven;
import org.kie.api.definition.rule.Direct;
import org.kie.api.definition.rule.Eager;

public class RuleBuilder {
    public void preProcess(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        if (null != ruleDescr.getParentName() && null != context.getPkg().getRule(ruleDescr.getParentName())) {
            context.getRule().setParent(context.getPkg().getRule(ruleDescr.getParentName()));
        }
        this.buildMetaAttributes(context);
        if (context.getRuleDescr() instanceof QueryDescr) {
            context.getDialect().getQueryBuilder().build(context, (QueryDescr)context.getRuleDescr());
        }
    }

    public void build(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(ruleDescr.getLhs().getClass());
        if (builder == null) {
            throw new RuntimeException("BUG: builder not found for descriptor class " + ruleDescr.getLhs().getClass());
        }
        Pattern prefixPattern = context.getPrefixPattern();
        GroupElement ce = (GroupElement)builder.build(context, ruleDescr.getLhs(), prefixPattern);
        context.getRule().setLhs(ce);
        this.buildAttributes(context);
        if (!(ruleDescr instanceof QueryDescr)) {
            ConsequenceBuilder consequenceBuilder = context.getDialect().getConsequenceBuilder();
            consequenceBuilder.build(context, "default");
            for (String name : ruleDescr.getNamedConsequences().keySet()) {
                consequenceBuilder.build(context, name);
            }
        }
    }

    public void buildMetaAttributes(RuleBuildContext context) {
        RuleImpl rule = context.getRule();
        for (String metaAttr : context.getRuleDescr().getAnnotationNames()) {
            AnnotationDescr ad = context.getRuleDescr().getAnnotation(metaAttr);
            try {
                AnnotationDefinition annotationDefinition = AnnotationDefinition.build((Class)context.getDialect().getTypeResolver().resolveType(ad.getFullyQualifiedName()), ad.getValueMap(), (TypeResolver)context.getDialect().getTypeResolver());
                if (annotationDefinition.getValues().size() == 1 && annotationDefinition.getValues().containsKey("value")) {
                    rule.addMetaAttribute(metaAttr, annotationDefinition.getPropertyValue("value"));
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>(annotationDefinition.getValues().size());
                for (String key : annotationDefinition.getValues().keySet()) {
                    map.put(key, annotationDefinition.getPropertyValue(key));
                }
                rule.addMetaAttribute(metaAttr, map);
            }
            catch (Exception e) {
                if (ad.hasValue()) {
                    if (ad.getValues().size() == 1) {
                        rule.addMetaAttribute(metaAttr, this.resolveValue(ad.getSingleValueAsString()));
                        continue;
                    }
                    rule.addMetaAttribute(metaAttr, ad.getValueMap());
                    continue;
                }
                rule.addMetaAttribute(metaAttr, null);
            }
        }
    }

    private Object resolveValue(String value) {
        Object result = value;
        try {
            Object resolvedValue;
            result = resolvedValue = MVELSafeHelper.getEvaluator().eval(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void buildAttributes(RuleBuildContext context) {
        RuleImpl rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        boolean enforceEager = false;
        for (AttributeDescr attributeDescr : ruleDescr.getAttributes().values()) {
            RuleBuildError err;
            Calendar cal;
            String name = attributeDescr.getName();
            if (name.equals("no-loop")) {
                rule.setNoLoop(this.getBooleanValue(attributeDescr, true));
                enforceEager = true;
                continue;
            }
            if (name.equals("auto-focus")) {
                rule.setAutoFocus(this.getBooleanValue(attributeDescr, true));
                continue;
            }
            if (name.equals("agenda-group")) {
                if (StringUtils.isEmpty((CharSequence)rule.getRuleFlowGroup())) {
                    rule.setAgendaGroup(attributeDescr.getValue());
                    continue;
                }
                if (!rule.getRuleFlowGroup().equals(attributeDescr.getValue())) continue;
                RuleBuildWarning warn = new RuleBuildWarning(rule, context.getParentDescr(), null, "Both an agenda-group ( " + attributeDescr.getValue() + " ) and a ruleflow-group ( " + rule.getRuleFlowGroup() + " ) are defined for rule " + rule.getName() + ". Since version 6.x the " + "two concepts have been unified, the ruleflow-group name will override the agenda-group. ");
                context.addWarning(warn);
                continue;
            }
            if (name.equals("activation-group")) {
                rule.setActivationGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("ruleflow-group")) {
                rule.setRuleFlowGroup(attributeDescr.getValue());
                if (!rule.getAgendaGroup().equals("MAIN") && !rule.getAgendaGroup().equals(attributeDescr.getValue())) {
                    RuleBuildWarning warn = new RuleBuildWarning(rule, context.getParentDescr(), null, "Both an agenda-group ( " + attributeDescr.getValue() + " ) and a ruleflow-group ( " + rule.getRuleFlowGroup() + " ) are defined for rule " + rule.getName() + ". Since version 6.x the " + "two concepts have been unified, the ruleflow-group name will override the agenda-group. ");
                    context.addWarning(warn);
                }
                rule.setAgendaGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("lock-on-active")) {
                boolean lockOnActive = this.getBooleanValue(attributeDescr, true);
                rule.setLockOnActive(lockOnActive);
                enforceEager |= lockOnActive;
                continue;
            }
            if (name.equals("duration") || name.equals("timer")) {
                String duration = attributeDescr.getValue();
                this.buildTimer(rule, duration, context);
                continue;
            }
            if (name.equals("calendars")) {
                this.buildCalendars(rule, attributeDescr.getValue(), context);
                continue;
            }
            if (name.equals("date-effective")) {
                try {
                    Date date = DateUtils.parseDate((String)attributeDescr.getValue(), (DateFormats)context.getKnowledgeBuilder().getDateFormats());
                    cal = Calendar.getInstance();
                    cal.setTime(date);
                    rule.setDateEffective(cal);
                }
                catch (Exception e) {
                    err = new RuleBuildError(rule, context.getParentDescr(), null, "Wrong date-effective value: " + e.getMessage());
                    context.addError(err);
                }
                continue;
            }
            if (!name.equals("date-expires")) continue;
            try {
                Date date = DateUtils.parseDate((String)attributeDescr.getValue(), (DateFormats)context.getKnowledgeBuilder().getDateFormats());
                cal = Calendar.getInstance();
                cal.setTime(date);
                rule.setDateExpires(cal);
            }
            catch (Exception e) {
                err = new RuleBuildError(rule, context.getParentDescr(), null, "Wrong date-expires value: " + e.getMessage());
                context.addError(err);
            }
        }
        this.buildSalience(context);
        this.buildEnabled(context);
        this.parseAnnotation(context, rule, ruleDescr, enforceEager);
    }

    private void parseAnnotation(RuleBuildContext context, RuleImpl rule, RuleDescr ruleDescr, boolean enforceEager) {
        try {
            ActivationListener activationListener = ruleDescr.getTypedAnnotation(ActivationListener.class);
            if (activationListener != null) {
                rule.setActivationListener(MVELSafeHelper.getEvaluator().evalToString(activationListener.value()));
            }
            if (enforceEager) {
                rule.setEager(true);
            } else {
                Eager eager = ruleDescr.getTypedAnnotation(Eager.class);
                if (eager != null) {
                    rule.setEager(eager.value());
                }
            }
            Direct direct = ruleDescr.getTypedAnnotation(Direct.class);
            if (direct != null && direct.value()) {
                rule.setActivationListener("direct");
            }
            rule.setDataDriven(ruleDescr.hasAnnotation(DataDriven.class));
        }
        catch (Exception e) {
            RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, e.getMessage());
            context.addError(err);
        }
    }

    private boolean trueOrDefault(String singleValue) {
        return StringUtils.isEmpty((CharSequence)singleValue) || "true".equals(singleValue);
    }

    private boolean getBooleanValue(AttributeDescr attributeDescr, boolean defaultValue) {
        return attributeDescr.getValue() == null || "".equals(attributeDescr.getValue().trim()) ? defaultValue : Boolean.valueOf(attributeDescr.getValue());
    }

    private void buildEnabled(RuleBuildContext context) {
        String enabledText = context.getRuleDescr().getEnabled();
        if (enabledText != null) {
            if ("true".equalsIgnoreCase(enabledText.trim()) || "false".equalsIgnoreCase(enabledText.trim())) {
                if (Boolean.parseBoolean(enabledText)) {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_TRUE);
                } else {
                    context.getRule().setEnabled(EnabledBoolean.ENABLED_FALSE);
                }
            } else {
                context.getDialect().getEnabledBuilder().build(context);
            }
        }
    }

    private void buildSalience(RuleBuildContext context) {
        String salienceText = context.getRuleDescr().getSalience();
        if (salienceText != null && !salienceText.equals("")) {
            try {
                SalienceInteger salience = new SalienceInteger(Integer.parseInt(salienceText));
                context.getRule().setSalience((Salience)salience);
            }
            catch (Exception e) {
                context.getDialect().getSalienceBuilder().build(context);
            }
        }
    }

    private void buildCalendars(RuleImpl rule, String calendarsString, RuleBuildContext context) {
        Object val = null;
        try {
            val = MVELSafeHelper.getEvaluator().eval(calendarsString);
            String[] calNames = null;
            if (val instanceof List) {
                calNames = ((List)val).toArray(new String[((List)val).size()]);
            } else if (val instanceof String) {
                calNames = new String[]{(String)val};
            } else {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Calendars attribute did not return a String or String[] '" + val + "'");
                context.addError(err);
            }
            if (calNames != null) {
                rule.setCalendars(calNames);
            }
        }
        catch (Exception e) {
            RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Unable to build Calendars attribute '" + val + "'" + e.getMessage());
            context.addError(err);
        }
    }

    private void buildTimer(RuleImpl rule, String timerString, RuleBuildContext context) {
        if (timerString.indexOf(40) >= 0) {
            timerString = timerString.substring(timerString.indexOf(40) + 1, timerString.lastIndexOf(41)).trim();
        }
        int colonPos = timerString.indexOf(":");
        int semicolonPos = timerString.indexOf(";");
        String protocol = "int";
        if (colonPos == -1) {
            if (timerString.startsWith("int") || timerString.startsWith("cron") || timerString.startsWith("expr")) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect timer definition '" + timerString + "' - missing colon?");
                context.addError(err);
                return;
            }
        } else {
            protocol = timerString.substring(0, colonPos);
        }
        String startDate = this.extractParam(timerString, "start");
        String endDate = this.extractParam(timerString, "end");
        String repeatLimitString = this.extractParam(timerString, "repeat-limit");
        int repeatLimit = repeatLimitString != null ? Integer.parseInt(repeatLimitString) : -1;
        String body = timerString.substring(colonPos + 1, semicolonPos > 0 ? semicolonPos : timerString.length()).trim();
        CronTimer timer = null;
        if ("cron".equals(protocol)) {
            try {
                timer = new CronTimer(this.createMVELExpr(startDate, context), this.createMVELExpr(endDate, context), repeatLimit, new CronExpression(body));
            }
            catch (ParseException e) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Unable to build set timer '" + timerString + "'");
                context.addError(err);
                return;
            }
        }
        if ("int".equals(protocol)) {
            String[] times = body.trim().split("\\s");
            long delay = 0L;
            long period = 0L;
            if (times.length > 2) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect number of arguments for interval timer '" + timerString + "'");
                context.addError(err);
                return;
            }
            try {
                if (times.length == 1) {
                    delay = TimeUtils.parseTimeString((String)times[0]);
                } else {
                    delay = TimeUtils.parseTimeString((String)times[0]);
                    period = TimeUtils.parseTimeString((String)times[1]);
                }
            }
            catch (RuntimeException e) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect timer definition '" + timerString + "' " + e.getMessage());
                context.addError(err);
                return;
            }
            timer = new IntervalTimer(this.createMVELExpr(startDate, context), this.createMVELExpr(endDate, context), repeatLimit, delay, period);
        } else if ("expr".equals(protocol)) {
            StringTokenizer tok = new StringTokenizer(body = body.trim(), ",;");
            if (tok.countTokens() > 2) {
                RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Incorrect number of arguments for expression timer '" + timerString + "'");
                context.addError(err);
                return;
            }
            MVELObjectExpression times = MVELObjectExpressionBuilder.build(tok.nextToken().trim(), context);
            MVELObjectExpression period = null;
            period = tok.hasMoreTokens() ? MVELObjectExpressionBuilder.build(tok.nextToken().trim(), context) : MVELObjectExpressionBuilder.build("0", context);
            timer = new ExpressionIntervalTimer(this.createMVELExpr(startDate, context), this.createMVELExpr(endDate, context), repeatLimit, times, period);
        } else {
            RuleBuildError err = new RuleBuildError(rule, context.getParentDescr(), null, "Protocol for timer does not exist '" + timerString + "'");
            context.addError(err);
            return;
        }
        rule.setTimer((Timer)timer);
    }

    private String extractParam(String timerString, String name) {
        int paramPos = timerString.indexOf(name);
        if (paramPos < 0) {
            return null;
        }
        int equalsPos = timerString.indexOf(61, paramPos);
        int sepPos = timerString.indexOf(44, equalsPos);
        int endPos = sepPos > 0 ? sepPos : timerString.length();
        return timerString.substring(equalsPos + 1, endPos).trim();
    }

    private MVELObjectExpression createMVELExpr(String expr, RuleBuildContext context) {
        if (expr == null) {
            return null;
        }
        try {
            DateUtils.parseDate((String)expr, (DateFormats)context.getKnowledgeBuilder().getDateFormats());
            expr = "\"" + expr + "\"";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MVELObjectExpressionBuilder.build(expr, context);
    }
}

