/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.jbpm.query.jpa.data.QueryWhere;

@XmlRootElement
@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"parameters"})
public class QueryCriteria {
    @XmlAttribute
    private String listId;
    @XmlAttribute
    private Boolean union = null;
    @XmlAttribute
    private QueryWhere.ParameterType type = QueryWhere.ParameterType.NORMAL;
    @XmlElement(name="parameter")
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
    private List<Object> values;
    @XmlElement
    private List<QueryCriteria> criteria;
    private static DatatypeFactory datatypeFactory;

    public QueryCriteria() {
    }

    public QueryCriteria(String listId, QueryWhere.ParameterType type) {
        this.listId = listId;
        this.type = type;
    }

    public QueryCriteria(String listId, boolean union, QueryWhere.ParameterType type) {
        this(listId, type);
        this.union = union;
    }

    public QueryCriteria(String listId, boolean union, QueryWhere.ParameterType type, int valueListSize) {
        this(listId, union, type);
        this.values = new ArrayList<Object>(valueListSize);
    }

    public String getListId() {
        return this.listId;
    }

    public void setListId(String listId) {
        this.listId = listId;
    }

    public Boolean isUnion() {
        return this.union;
    }

    public void setUnion(Boolean union) {
        this.union = union;
    }

    public QueryWhere.ParameterType getType() {
        return this.type;
    }

    public void setType(QueryWhere.ParameterType type) {
        this.type = type;
    }

    public List<Object> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public List<QueryCriteria> getCriteria() {
        if (this.criteria == null) {
            this.criteria = new ArrayList<QueryCriteria>();
        }
        return this.criteria;
    }

    public void setCriteria(List<QueryCriteria> criteria) {
        this.criteria = criteria;
    }

    public List<Object> getParameters() {
        List<Object> values = this.getValues();
        if (values.isEmpty()) {
            return values;
        }
        ArrayList<Object> parameters = new ArrayList<Object>(values.size());
        for (Object obj : this.values) {
            parameters.add(QueryCriteria.convertSerializableVariantToObject(obj));
        }
        return parameters;
    }

    void addParameter(Object value) {
        Object xmlValue = QueryCriteria.convertObjectToSerializableVariant(value);
        this.getValues().add(xmlValue);
    }

    void setParameter(int index, Object value) {
        Object xmlValue = QueryCriteria.convertObjectToSerializableVariant(value);
        List<Object> values = this.getValues();
        while (values.size() <= index) {
            values.add(null);
        }
        this.getValues().set(index, xmlValue);
    }

    void addCriteria(QueryCriteria criteria) {
        this.getCriteria().add(criteria);
    }

    private static Object convertObjectToSerializableVariant(Object obj) {
        if (obj instanceof Date) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime((Date)obj);
            return datatypeFactory.newXMLGregorianCalendar(cal);
        }
        return obj;
    }

    private static Object convertSerializableVariantToObject(Object obj) {
        if (obj instanceof XMLGregorianCalendar) {
            return ((XMLGregorianCalendar)obj).toGregorianCalendar().getTime();
        }
        return obj;
    }

    public QueryCriteria(QueryCriteria queryCriteria) {
        this.listId = queryCriteria.listId;
        this.union = queryCriteria.union;
        this.type = queryCriteria.type;
        this.values = new ArrayList<Object>(queryCriteria.getValues());
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (this.union != null) {
            out.append(this.union != false ? "OR" : "AND");
            out.append(" ");
        }
        out.append(this.listId);
        if (this.values != null && !this.values.isEmpty()) {
            out.append(" =");
            if (this.type.equals((Object)QueryWhere.ParameterType.REGEXP)) {
                out.append("~");
            }
            out.append(" ");
            if (this.type.equals((Object)QueryWhere.ParameterType.RANGE)) {
                out.append("[");
            }
            out.append(this.values.get(0));
            for (int i = 1; i < this.values.size(); ++i) {
                out.append(", ").append(this.values.get(i));
            }
            if (this.type.equals((Object)QueryWhere.ParameterType.RANGE)) {
                out.append("]");
            }
        }
        return out.toString();
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            System.out.println("Unable to instantiate a " + DatatypeFactory.class.getName());
        }
    }
}

