/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.drools.core.QueryResultsRowImpl;
import org.drools.core.WorkingMemory;
import org.drools.core.base.QueryRowWithSubruleIndex;
import org.drools.core.rule.Declaration;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

public class QueryResultsImpl
implements QueryResults {
    private Map<String, Declaration>[] declarations;
    protected List<QueryRowWithSubruleIndex> results;
    protected WorkingMemory workingMemory;
    protected Declaration[] parameters;
    private String[] identifiers;

    public QueryResultsImpl(List<QueryRowWithSubruleIndex> results, Map<String, Declaration>[] declarations, WorkingMemory workingMemory, Declaration[] parameters) {
        this.results = results;
        this.workingMemory = workingMemory;
        this.declarations = declarations;
        this.parameters = parameters;
    }

    public Map<String, Declaration>[] getDeclarations() {
        return this.declarations;
    }

    public Declaration[] getParameters() {
        return this.parameters;
    }

    public Map<String, Declaration> getDeclarations(int subruleIndex) {
        if (this.declarations == null || this.declarations.length == 0) {
            return Collections.emptyMap();
        }
        return this.declarations[subruleIndex];
    }

    public QueryResultsRowImpl get(int i) {
        if (i > this.results.size()) {
            throw new NoSuchElementException();
        }
        return new QueryResultsRowImpl(this.results.get(i), this.workingMemory, this);
    }

    public int size() {
        return this.results.size();
    }

    public String[] getIdentifiers() {
        if (this.identifiers != null) {
            return this.identifiers;
        }
        Declaration[] parameters = this.getParameters();
        HashSet<String> set = new HashSet<String>();
        for (Declaration declr : parameters) {
            set.add(declr.getIdentifier());
        }
        ArrayList<Declaration> declrCollection = new ArrayList<Declaration>(this.getDeclarations(0).values());
        Iterator it = declrCollection.iterator();
        while (it.hasNext()) {
            Declaration declr = (Declaration)it.next();
            if (!set.contains(declr.getIdentifier())) continue;
            it.remove();
        }
        String[] declrs = new String[parameters.length + declrCollection.size()];
        int i = 0;
        for (Declaration declr : parameters) {
            declrs[i++] = declr.getIdentifier();
        }
        for (Declaration declr : declrCollection) {
            declrs[i++] = declr.getIdentifier();
        }
        this.identifiers = declrs;
        return this.identifiers;
    }

    public Iterator<QueryResultsRow> iterator() {
        return new QueryResultsIterator(this.results.iterator());
    }

    private class QueryResultsIterator
    implements Iterator<QueryResultsRow> {
        private Iterator<QueryRowWithSubruleIndex> iterator;

        public QueryResultsIterator(Iterator<QueryRowWithSubruleIndex> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public QueryResultsRow next() {
            return new QueryResultsRowImpl(this.iterator.next(), QueryResultsImpl.this.workingMemory, QueryResultsImpl.this);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

