/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitFieldTMS;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitTypeMap;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.metadata.Metadatable;
import org.drools.core.metadata.Modify;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.HierarchyEncoderImpl;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.KieBase;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.runtime.beliefs.Mode;

public class TraitHelper
implements Externalizable {
    private InternalWorkingMemoryActions workingMemory;
    private NamedEntryPoint entryPoint;

    public TraitHelper(InternalWorkingMemoryActions workingMemory, NamedEntryPoint nep) {
        this.workingMemory = workingMemory;
        this.entryPoint = nep;
    }

    public <T, K> T don(Activation activation, K core, Collection<Class<? extends Thing>> traits, boolean logical, Mode ... modes) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(activation, ((Thing)core).getCore(), traits, logical, modes);
        }
        if (traits.isEmpty()) {
            return (T)this.don(activation, core, Thing.class, logical, new Mode[0]);
        }
        try {
            T thing = this.applyManyTraits(activation, core, traits, null, logical, modes);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    public <T, K> T don(Activation activation, K core, Class<T> trait, boolean logical, Mode ... modes) {
        return this.don(activation, core, trait, null, logical, modes);
    }

    public <T, K> T don(Activation activation, K core, Class<T> trait, Modify initArgs, boolean logical, Mode ... modes) {
        if (core instanceof Thing && ((Thing)core).getCore() != core) {
            return this.don(activation, ((Thing)core).getCore(), trait, initArgs, logical, modes);
        }
        try {
            T thing = this.applyTrait(activation, core, trait, initArgs, logical, modes);
            return thing;
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    protected <T> T doInsertTrait(Activation activation, T thing, Object core, boolean logical, Mode ... modes) {
        if (thing == core) {
            return thing;
        }
        if (logical) {
            this.insertLogical(activation, thing, modes);
        } else {
            this.insert(thing, activation);
        }
        return thing;
    }

    private void updateTraits(Object object, BitMask mask, Thing originator, Class<?> modifiedClass, Collection<Thing> traits, Activation activation) {
        this.updateManyTraits(object, mask, Arrays.asList(originator), modifiedClass, traits, activation);
    }

    private void updateManyTraits(Object object, BitMask mask, Collection<Thing> originators, Class<?> modifiedClass, Collection<Thing> traits, Activation activation) {
        for (Thing t : traits) {
            InternalFactHandle h;
            if (originators.contains(t) || (h = (InternalFactHandle)this.lookupFactHandle(t)) == null) continue;
            NamedEntryPoint nep = (NamedEntryPoint)h.getEntryPoint();
            PropagationContext propagationContext = nep.getPctxFactory().createPropagationContext(nep.getInternalWorkingMemory().getNextPropagationIdCounter(), 2, activation != null ? activation.getRule() : null, activation != null ? activation.getTuple() : null, h, nep.getEntryPoint(), mask, modifiedClass, null);
            nep.update(h, t, t, nep.getObjectTypeConfigurationRegistry().getObjectTypeConf(nep.getEntryPoint(), t), activation != null ? activation.getRule() : null, propagationContext);
        }
    }

    public void updateTraits(InternalFactHandle handle, BitMask mask, Class<?> modifiedClass, Activation activation) {
        Thing x;
        if (handle.isTraitable()) {
            if (((TraitableBean)handle.getObject()).hasTraits()) {
                this.updateTraits(handle.getObject(), mask, null, modifiedClass, ((TraitableBean)handle.getObject())._getTraitMap().values(), activation);
            }
        } else if (handle.isTraiting() && (x = (Thing)handle.getObject()) != x.getCore()) {
            Object core = x.getCore();
            InternalFactHandle coreHandle = (InternalFactHandle)this.getFactHandle(core);
            ((NamedEntryPoint)coreHandle.getEntryPoint()).update(coreHandle, core, mask, modifiedClass, activation);
            this.updateTraits(core, mask, x, modifiedClass, ((TraitableBean)core)._getTraitMap().values(), activation);
        }
    }

    private <T, K> void refresh(T thing, K core, TraitableBean inner, Class<T> trait, Collection<Thing> mostSpecificTraits, boolean logical, Activation activation) {
        if (mostSpecificTraits != null) {
            this.updateCore(inner, core, trait, logical, activation);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateTraits(inner, PropertySpecificUtil.onlyTraitBitSetMask(), (Thing)thing, trait, mostSpecificTraits, activation);
            }
        } else if (Thing.class == trait) {
            this.updateCore(inner, core, trait, logical, activation);
        }
    }

    protected <T, K> T applyManyTraits(Activation activation, K core, Collection<Class<? extends Thing>> traits, Object value, boolean logical, Mode ... modes) throws LogicalTypeInconsistencyException {
        TraitFactory builder = TraitFactory.getTraitBuilderForKnowledgeBase((KieBase)this.entryPoint.getKnowledgeBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical, activation);
        Collection<Thing> mostSpecificTraits = inner.getMostSpecificTraits();
        boolean newTraitsAdded = false;
        Thing firstThing = null;
        ArrayList<Thing> things = new ArrayList<Thing>(traits.size());
        this.checkStaticTypeCode(inner);
        for (Class<? extends Thing> trait : traits) {
            boolean needsUpdate;
            boolean needsProxy = trait.isAssignableFrom(inner.getClass());
            boolean hasTrait = inner.hasTrait(trait.getName());
            boolean bl = needsUpdate = needsProxy || core != inner;
            if (hasTrait) continue;
            Thing thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical, activation);
            this.configureTrait(thing, value);
            things.add(thing);
            if (newTraitsAdded || trait == Thing.class) continue;
            firstThing = thing;
            newTraitsAdded = true;
        }
        for (Thing t : things) {
            this.doInsertTrait(activation, t, core, logical, modes);
        }
        if (newTraitsAdded && mostSpecificTraits != null) {
            this.updateCore(inner, core, null, logical, activation);
            if (!mostSpecificTraits.isEmpty()) {
                this.updateManyTraits(inner, PropertySpecificUtil.onlyTraitBitSetMask(), things, core.getClass(), mostSpecificTraits, activation);
            }
        }
        return (T)firstThing;
    }

    private void checkStaticTypeCode(TraitableBean inner) {
        TraitTypeMap ttm;
        if (!inner.hasTraits() && (ttm = (TraitTypeMap)inner._getTraitMap()) != null && ttm.getStaticTypeCode() == null) {
            TraitRegistry registry = this.workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry();
            BitSet staticCode = registry.getStaticTypeCode(inner.getClass().getName());
            ttm.setStaticTypeCode(staticCode);
            if (staticCode != null) {
                for (String staticTrait : registry.getStaticTypes(inner.getClass().getName())) {
                    ttm.addStaticTrait(staticTrait, registry.getHierarchy().getCode(staticTrait));
                }
            }
        }
    }

    protected <T, K> T applyTrait(Activation activation, K core, Class<T> trait, Object value, boolean logical, Mode ... modes) throws LogicalTypeInconsistencyException {
        TraitFactory builder = TraitFactory.getTraitBuilderForKnowledgeBase((KieBase)this.entryPoint.getKnowledgeBase());
        TraitableBean inner = this.makeTraitable(core, builder, logical, activation);
        boolean needsProxy = trait.isAssignableFrom(inner.getClass());
        boolean hasTrait = inner.hasTrait(trait.getName());
        boolean needsUpdate = needsProxy || core != inner;
        this.checkStaticTypeCode(inner);
        BitSet boundary = inner.getCurrentTypeCode() != null ? (BitSet)inner.getCurrentTypeCode().clone() : null;
        Collection<Thing> mostSpecificTraits = this.getTraitBoundary(inner, needsProxy, hasTrait, trait);
        T thing = this.asTrait(core, inner, trait, needsProxy, hasTrait, needsUpdate, builder, logical, activation);
        this.configureTrait(thing, value);
        thing = this.doInsertTrait(activation, thing, core, logical, modes);
        this.refresh(thing, core, inner, trait, mostSpecificTraits, logical, activation);
        if (trait != Thing.class && inner._getFieldTMS() != null) {
            inner._getFieldTMS().resetModificationMask();
        }
        return thing;
    }

    private <T> void updateCore(TraitableBean inner, Object core, Class<T> trait, boolean logical, Activation activation) {
        FactHandle handle = this.lookupFactHandle(inner);
        InternalFactHandle h = (InternalFactHandle)handle;
        if (handle != null) {
            TraitFieldTMS fieldTMS = inner._getFieldTMS();
            BitMask mask = fieldTMS == null ? PropertySpecificUtil.onlyTraitBitSetMask() : fieldTMS.getModificationMask();
            Object o = h.getObject();
            NamedEntryPoint nep = (NamedEntryPoint)h.getEntryPoint();
            PropagationContext propagationContext = nep.getPctxFactory().createPropagationContext(nep.getInternalWorkingMemory().getNextPropagationIdCounter(), 2, activation.getRule(), activation.getTuple(), h, nep.getEntryPoint(), mask, core.getClass(), null);
            nep.update(h, o, o, nep.getObjectTypeConfigurationRegistry().getObjectTypeConf(nep.getEntryPoint(), o), activation.getRule(), propagationContext);
        } else {
            handle = this.workingMemory.insert(inner, null, false, logical, activation.getRule(), activation);
        }
    }

    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait, Activation activation) {
        Collection removedTypes;
        if (trait.isAssignableFrom(core.getClass())) {
            Collection removedTypes2 = core.removeTrait(trait.getName());
            if (!removedTypes2.isEmpty()) {
                this.reassignNodes(core, removedTypes2);
                this.update(this.getFactHandle(core), PropertySpecificUtil.onlyTraitBitSetMask(), core.getClass(), activation);
            }
            if (core instanceof Thing) {
                return (Thing)((Object)core);
            }
            return null;
        }
        Thing thing = core.getTrait(Thing.class.getName());
        if (trait == Thing.class) {
            ArrayList removedTypes3 = new ArrayList(core._getTraitMap().values());
            for (Thing thing2 : removedTypes3) {
                if (((TraitType)((Object)thing2))._isVirtual()) continue;
                this.delete(this.getFactHandle(thing2), activation);
            }
            core._getTraitMap().clear();
            core._setTraitMap(null);
            return thing;
        }
        if (core.hasTrait(trait.getName())) {
            removedTypes = core.removeTrait(trait.getName());
        } else {
            HierarchyEncoder<String> hier = this.workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
            BitSet bitSet = hier.getCode(trait.getName());
            removedTypes = core.removeTrait(bitSet);
        }
        removedTypes = new ArrayList(removedTypes);
        this.reassignNodes(core, removedTypes);
        for (Thing thing3 : removedTypes) {
            if (((TraitType)((Object)thing3))._isVirtual()) continue;
            InternalFactHandle handle = (InternalFactHandle)this.getFactHandle(thing3);
            if (handle.getEqualityKey() != null && handle.getEqualityKey().getLogicalFactHandle() == handle) {
                this.entryPoint.getTruthMaintenanceSystem().delete(handle);
                continue;
            }
            this.delete(this.getFactHandle(thing3), activation);
        }
        if (!core.hasTraits()) {
            this.don(activation, core, Thing.class, false, new Mode[0]);
        } else if (!removedTypes.isEmpty()) {
            this.update(this.getFactHandle(core), PropertySpecificUtil.onlyTraitBitSetMask(), core.getClass(), activation);
        }
        return thing;
    }

    private <K, X extends TraitableBean> void reassignNodes(TraitableBean<K, X> core, Collection<Thing<K>> removedTraits) {
        if (!core.hasTraits()) {
            return;
        }
        Collection mst = ((TraitTypeMap)core._getTraitMap()).getMostSpecificTraits();
        for (Thing<K> shedded : removedTraits) {
            for (BitSet bs : ((TraitProxy)((Object)shedded)).listAssignedOtnTypeCodes()) {
                boolean found = false;
                for (Thing tp : mst) {
                    TraitProxy candidate = (TraitProxy)((Object)tp);
                    if (!HierarchyEncoderImpl.supersetOrEqualset(candidate._getTypeCode(), bs)) continue;
                    candidate.assignOtn(bs);
                    found = true;
                    break;
                }
                if (!found) continue;
            }
        }
    }

    protected <K> Collection<Thing> getTraitBoundary(TraitableBean<K, ?> inner, boolean needsProxy, boolean hasTrait, Class trait) {
        boolean refresh;
        boolean bl = refresh = !needsProxy && !hasTrait && Thing.class != trait;
        if (!refresh) {
            return null;
        }
        if (inner._getTraitMap() == null || inner instanceof Thing) {
            return Collections.EMPTY_LIST;
        }
        if (inner._getTraitMap().isEmpty()) {
            return null;
        }
        ArrayList<Thing> ts = new ArrayList<Thing>();
        for (Thing<K> t : inner._getTraitMap().values()) {
            if (!(t instanceof TraitProxy) || !((TraitProxy)((Object)t)).hasOtns()) continue;
            ts.add(t);
        }
        return ts;
    }

    private <T, K> T asTrait(K core, TraitableBean inner, Class<T> trait, boolean needsProxy, boolean hasTrait, boolean needsUpdate, TraitFactory builder, boolean logical, Activation activation) throws LogicalTypeInconsistencyException {
        Thing<Object> thing;
        if (needsProxy) {
            thing = inner;
            inner.addTrait(trait.getName(), (Thing)core);
        } else {
            thing = hasTrait ? inner.getTrait(trait.getName()) : builder.getProxy(inner, trait, logical);
        }
        if (needsUpdate) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            if (h == null) {
                h = this.lookupHandleForWrapper(core);
            }
            if (h == null) {
                h = (InternalFactHandle)this.workingMemory.insert(core, null, false, logical, activation.getRule(), activation);
            }
            if (!h.isTraitOrTraitable()) {
                throw new IllegalStateException("A traited working memory element is being used with a default fact handle. Please verify that its class was declared as @Traitable : " + core.getClass().getName());
            }
            this.update(h, inner, activation);
        }
        return (T)thing;
    }

    private <K> TraitableBean makeTraitable(K core, TraitFactory builder, boolean logical, Activation activation) {
        TraitableBean<K, CoreWrapper<K>> inner;
        boolean needsWrapping = !(core instanceof TraitableBean);
        ClassDefinition coreDef = this.lookupClassDefinition(core);
        TraitableBean<K, CoreWrapper<K>> traitableBean = inner = needsWrapping ? builder.asTraitable(core, coreDef) : (TraitableBean<K, CoreWrapper<K>>)core;
        if (needsWrapping) {
            InternalFactHandle h = (InternalFactHandle)this.lookupFactHandle(core);
            InternalWorkingMemoryEntryPoint ep = h != null ? (InternalWorkingMemoryEntryPoint)h.getEntryPoint() : (InternalWorkingMemoryEntryPoint)((StatefulKnowledgeSessionImpl)this.workingMemory).getEntryPoint("DEFAULT");
            ObjectTypeConfigurationRegistry reg = ep.getObjectTypeConfigurationRegistry();
            ObjectTypeConf coreConf = reg.getObjectTypeConf(ep.getEntryPoint(), core);
            ObjectTypeConf innerConf = reg.getObjectTypeConf(ep.getEntryPoint(), inner);
            if (coreConf.isTMSEnabled()) {
                innerConf.enableTMS();
            }
            if (inner._getFieldTMS() != null && inner._getFieldTMS().needsInit()) {
                inner._getFieldTMS().init(this.workingMemory);
            }
        } else {
            TraitFieldTMS ftms = inner._getFieldTMS();
            if (ftms != null) {
                FactHandle handle = this.lookupFactHandle(inner);
                if (handle == null) {
                    handle = this.workingMemory.insert(inner, null, false, logical, activation.getRule(), activation);
                }
                if (ftms.needsInit()) {
                    ftms.init(this.workingMemory);
                }
            }
        }
        return inner;
    }

    protected <K> ClassDefinition lookupClassDefinition(K core) {
        TypeDeclaration decl;
        InternalKnowledgePackage pack = this.workingMemory.getKnowledgeBase().getPackage(core.getClass().getPackage().getName());
        if (pack != null && (decl = pack.getTypeDeclaration(core.getClass())) != null) {
            return decl.getTypeClassDef();
        }
        return null;
    }

    private <K> InternalFactHandle lookupHandleForWrapper(K core) {
        for (EntryPoint entryPoint : this.workingMemory.getEntryPoints()) {
            ObjectStore store = ((InternalWorkingMemoryEntryPoint)entryPoint).getObjectStore();
            Iterator<InternalFactHandle> iter = store.iterateFactHandles();
            while (iter.hasNext()) {
                InternalFactHandle handle = iter.next();
                if (!handle.isTraitable() || !(handle.getObject() instanceof CoreWrapper) || ((CoreWrapper)handle.getObject()).getCore() != core) continue;
                return handle;
            }
        }
        return null;
    }

    public FactHandle lookupFactHandle(Object object) {
        FactHandle handle = null;
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        return handle;
    }

    protected <T> void configureTrait(T thing, Object value) {
        if (value instanceof Modify && thing instanceof Metadatable) {
            Modify modify = (Modify)value;
            modify.call((Metadatable)thing);
        }
    }

    private FactHandle getFactHandleFromWM(Object object) {
        FactHandle handle = null;
        handle = this.entryPoint.getFactHandle(object);
        if (handle != null) {
            // empty if block
        }
        return handle;
    }

    public FactHandle getFactHandle(Object object) {
        FactHandle handle = null;
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            if (object instanceof CoreWrapper) {
                handle = this.getFactHandleFromWM(((CoreWrapper)object).getCore());
            }
            if (handle == null) {
                throw new RuntimeException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
            }
        }
        return handle;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
    }

    public void update(FactHandle handle, Object newObject, Activation activation) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, newObject, PropertySpecificUtil.onlyTraitBitSetMask(), newObject.getClass(), activation);
    }

    public void update(FactHandle handle, BitMask mask, Class<?> modifiedClass, Activation activation) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((NamedEntryPoint)h.getEntryPoint()).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, activation);
        if (h.isTraitOrTraitable()) {
            this.workingMemory.updateTraits(h, mask, modifiedClass, activation);
        }
    }

    public void delete(FactHandle handle, Activation activation) {
        Object o = ((InternalFactHandle)handle).getObject();
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).delete(handle, activation.getRule(), activation);
    }

    public FactHandle insert(Object object, Activation activation) {
        FactHandle handle = this.workingMemory.insert(object, null, false, false, activation.getRule(), activation);
        return handle;
    }

    public void insertLogical(Activation activation, Object object, Mode ... modes) {
        if (!activation.isMatched()) {
            return;
        }
        InternalFactHandle handle = this.workingMemory.getTruthMaintenanceSystem().insert(object, modes, activation.getRule(), activation);
    }

    public void deleteWMAssertedTraitProxies(InternalFactHandle handle, RuleImpl rule, Activation activation) {
        TraitableBean traitableBean = (TraitableBean)handle.getObject();
        if (traitableBean.hasTraits()) {
            PriorityQueue removedTypes = new PriorityQueue(traitableBean._getTraitMap().values().size());
            removedTypes.addAll(traitableBean._getTraitMap().values());
            while (!removedTypes.isEmpty()) {
                InternalFactHandle proxyHandle;
                TraitProxy proxy = (TraitProxy)removedTypes.poll();
                if (proxy._isVirtual() || (proxyHandle = (InternalFactHandle)this.getFactHandle(proxy)).getEqualityKey() != null && proxyHandle.getEqualityKey().getLogicalFactHandle() == proxyHandle) continue;
                this.entryPoint.delete(proxyHandle, rule, activation);
            }
        }
    }

    public static <K> K extractTrait(InternalFactHandle handle, Class<K> klass) {
        TraitableBean tb;
        if (handle.isTraitable()) {
            tb = (TraitableBean)handle.getObject();
        } else if (handle.isTraiting()) {
            tb = ((TraitProxy)handle.getObject()).getObject();
        } else {
            return null;
        }
        Thing k = tb.getTrait(klass.getCanonicalName());
        if (k != null) {
            return (K)k;
        }
        for (Thing t : tb.getMostSpecificTraits()) {
            if (!klass.isAssignableFrom(t.getClass())) continue;
            return (K)t;
        }
        return null;
    }

    public void replaceCore(InternalFactHandle handle, Object object, Object originalObject, BitMask modificationMask, Class<? extends Object> aClass, Activation activation) {
        TraitableBean src = (TraitableBean)originalObject;
        TraitableBean tgt = (TraitableBean)object;
        tgt._setTraitMap(src._getTraitMap());
        tgt._setDynamicProperties(src._getDynamicProperties());
        tgt._setFieldTMS(src._getFieldTMS());
        this.updateTraits(handle, modificationMask, object.getClass(), activation);
    }
}

