/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Iterator;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.ExecutableEntry;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.PropagationList;

public class SynchronizedPropagationList
implements PropagationList {
    private final InternalWorkingMemory workingMemory;
    private volatile PropagationEntry head;
    private volatile PropagationEntry tail;

    public SynchronizedPropagationList(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public void addEntry(final PropagationEntry entry) {
        if (entry.requiresImmediateFlushing()) {
            this.workingMemory.getAgenda().executeTask(new ExecutableEntry(){

                @Override
                public void execute() {
                    ((PhreakTimerNode.TimerAction)entry).execute(SynchronizedPropagationList.this.workingMemory, true);
                }

                @Override
                public void enqueue() {
                    SynchronizedPropagationList.this.internalAddEntry(entry);
                }
            });
        } else {
            this.internalAddEntry(entry);
        }
    }

    private synchronized void internalAddEntry(PropagationEntry entry) {
        boolean wasEmpty;
        boolean bl = wasEmpty = this.head == null;
        if (wasEmpty) {
            this.head = entry;
        } else {
            this.tail.setNext(entry);
        }
        this.tail = entry;
        if (wasEmpty) {
            this.notifyHalt();
        }
    }

    @Override
    public void flush() {
        PropagationEntry currentHead = this.takeAll();
        while (currentHead != null) {
            SynchronizedPropagationList.flush(this.workingMemory, currentHead);
            currentHead = this.takeAll();
        }
    }

    @Override
    public void flushOnFireUntilHalt(boolean fired) {
        this.flushOnFireUntilHalt(fired, this.takeAll());
    }

    @Override
    public void flushOnFireUntilHalt(boolean fired, PropagationEntry currentHead) {
        if (!fired && currentHead == null) {
            this.halt();
            currentHead = this.takeAll();
        }
        while (currentHead != null) {
            SynchronizedPropagationList.flush(this.workingMemory, currentHead);
            currentHead = this.takeAll();
        }
    }

    public static void flush(InternalWorkingMemory workingMemory, PropagationEntry currentHead) {
        for (PropagationEntry entry = currentHead; entry != null; entry = entry.getNext()) {
            entry.execute(workingMemory);
        }
    }

    @Override
    public synchronized PropagationEntry takeAll() {
        PropagationEntry currentHead = this.head;
        this.head = null;
        this.tail = null;
        return currentHead;
    }

    @Override
    public synchronized void flushNonMarshallable() {
        PropagationEntry newHead = null;
        PropagationEntry newTail = null;
        for (PropagationEntry entry = this.head; entry != null; entry = entry.getNext()) {
            if (entry.isMarshallable()) {
                if (newHead == null) {
                    newHead = entry;
                } else {
                    newTail.setNext(entry);
                }
                newTail = entry;
                continue;
            }
            entry.execute(this.workingMemory);
        }
        this.head = newHead;
        this.tail = newTail;
    }

    private synchronized void halt() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void reset() {
        this.head = null;
        this.tail = null;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public synchronized void notifyHalt() {
        this.notifyAll();
    }

    @Override
    public synchronized Iterator<PropagationEntry> iterator() {
        return new PropagationEntryIterator(this.head);
    }

    public static class PropagationEntryIterator
    implements Iterator<PropagationEntry> {
        private PropagationEntry next;

        public PropagationEntryIterator(PropagationEntry head) {
            this.next = head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public PropagationEntry next() {
            PropagationEntry current = this.next;
            this.next = current.getNext();
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

