/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.constraint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IntervalProviderConstraint;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.time.Interval;

public class EvaluatorConstraint
extends MutableTypeConstraint
implements IntervalProviderConstraint {
    protected Declaration[] declarations;
    protected Evaluator evaluator;
    protected InternalReadAccessor rightReadAccessor;
    protected FieldValue field;

    public EvaluatorConstraint() {
    }

    public EvaluatorConstraint(FieldValue field, Evaluator evaluator, InternalReadAccessor extractor) {
        this.field = field;
        this.declarations = new Declaration[0];
        this.evaluator = evaluator;
        this.rightReadAccessor = extractor;
    }

    public EvaluatorConstraint(Declaration[] declarations, Evaluator evaluator, InternalReadAccessor extractor) {
        this.declarations = declarations;
        this.evaluator = evaluator;
        this.rightReadAccessor = extractor;
    }

    protected boolean isLiteral() {
        return this.declarations.length == 0;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(workingMemory, this.rightReadAccessor, handle, this.field);
        }
        return this.evaluator.evaluate(workingMemory, this.rightReadAccessor, handle, this.declarations[0].getExtractor(), handle);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(((LiteralContextEntry)context).workingMemory, ((LiteralContextEntry)context).getFieldExtractor(), handle, this.field);
        }
        return this.evaluator.evaluateCachedLeft(((VariableRestriction.VariableContextEntry)context).workingMemory, (VariableRestriction.VariableContextEntry)context, handle);
    }

    @Override
    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        if (this.isLiteral()) {
            return this.evaluator.evaluate(((LiteralContextEntry)context).workingMemory, ((LiteralContextEntry)context).getFieldExtractor(), ((LiteralContextEntry)context).getFactHandle(), this.field);
        }
        return this.evaluator.evaluateCachedRight(((VariableRestriction.VariableContextEntry)context).workingMemory, (VariableRestriction.VariableContextEntry)context, tuple.get(this.declarations[0]));
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.declarations[0].equals(oldDecl)) {
            this.declarations[0] = newDecl;
        }
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    @Override
    public boolean isTemporal() {
        return this.evaluator != null && this.evaluator.isTemporal();
    }

    public boolean isSelf() {
        return this.rightReadAccessor.isSelfReference();
    }

    @Override
    public Interval getInterval() {
        return this.evaluator == null ? null : this.evaluator.getInterval();
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public FieldValue getField() {
        return this.field;
    }

    protected InternalReadAccessor getRightReadAccessor() {
        return this.rightReadAccessor;
    }

    @Override
    public EvaluatorConstraint clone() {
        if (this.isLiteral()) {
            return new EvaluatorConstraint(this.field, this.evaluator, this.rightReadAccessor);
        }
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        System.arraycopy(this.declarations, 0, clonedDeclarations, 0, this.declarations.length);
        return new EvaluatorConstraint(clonedDeclarations, this.evaluator, this.rightReadAccessor);
    }

    @Override
    public ContextEntry createContextEntry() {
        return this.isLiteral() ? new LiteralContextEntry(this.rightReadAccessor) : VariableRestriction.createContextEntry(this.rightReadAccessor, this.declarations[0], this.evaluator);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.field);
        out.writeObject(this.declarations);
        out.writeObject(this.rightReadAccessor);
        out.writeObject(this.evaluator);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.field = (FieldValue)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.rightReadAccessor = (InternalReadAccessor)in.readObject();
        this.evaluator = (Evaluator)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvaluatorConstraint)) {
            return false;
        }
        EvaluatorConstraint that = (EvaluatorConstraint)o;
        if (!Arrays.equals(this.declarations, that.declarations)) {
            return false;
        }
        if (this.evaluator != null ? !this.evaluator.equals(that.evaluator) : that.evaluator != null) {
            return false;
        }
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        return !(this.rightReadAccessor != null ? !this.rightReadAccessor.equals(that.rightReadAccessor) : that.rightReadAccessor != null);
    }

    public int hashCode() {
        int result = this.declarations != null ? Arrays.hashCode(this.declarations) : 0;
        result = 31 * result + (this.evaluator != null ? this.evaluator.hashCode() : 0);
        result = 31 * result + (this.rightReadAccessor != null ? this.rightReadAccessor.hashCode() : 0);
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }

    protected static class LiteralContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public InternalReadAccessor extractor;
        public InternalFactHandle factHandle;
        public ContextEntry next;
        public InternalWorkingMemory workingMemory;

        public LiteralContextEntry() {
        }

        public LiteralContextEntry(InternalReadAccessor extractor) {
            this.extractor = extractor;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.extractor = (InternalReadAccessor)in.readObject();
            this.factHandle = (InternalFactHandle)in.readObject();
            this.next = (ContextEntry)in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.extractor);
            out.writeObject(this.factHandle);
            out.writeObject(this.next);
            out.writeObject(this.workingMemory);
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.extractor;
        }

        public InternalFactHandle getFactHandle() {
            return this.factHandle;
        }

        @Override
        public ContextEntry getNext() {
            return this.next;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.factHandle = handle;
            this.workingMemory = workingMemory;
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
        }

        @Override
        public void resetTuple() {
        }

        @Override
        public void resetFactHandle() {
            this.factHandle = null;
        }
    }
}

