/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.helix.monitoring.StatCollector;
import org.apache.helix.monitoring.mbeans.HelixStageLatencyMonitorMBean;
import org.apache.log4j.Logger;

public class HelixStageLatencyMonitor
implements HelixStageLatencyMonitorMBean {
    private static final Logger LOG = Logger.getLogger(HelixStageLatencyMonitor.class);
    private final StatCollector _stgLatency;
    private final MBeanServer _beanServer;
    private final String _clusterName;
    private final String _stageName;
    private final ObjectName _objectName;

    public HelixStageLatencyMonitor(String clusterName, String stageName) throws Exception {
        this._clusterName = clusterName;
        this._stageName = stageName;
        this._stgLatency = new StatCollector();
        this._beanServer = ManagementFactory.getPlatformMBeanServer();
        this._objectName = new ObjectName("StageLatencyMonitor: cluster=" + this._clusterName + ",stage=" + this._stageName);
        try {
            this.register(this, this._objectName);
        }
        catch (Exception e) {
            LOG.error((Object)("Couldn't register " + this._objectName + " mbean"), (Throwable)e);
            throw e;
        }
    }

    private void register(Object bean, ObjectName name) throws Exception {
        try {
            this._beanServer.unregisterMBean(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._beanServer.registerMBean(bean, name);
    }

    private void unregister(ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Couldn't unregister " + this._objectName + " mbean"), (Throwable)e);
        }
    }

    public void addStgLatency(long time) {
        this._stgLatency.addData(time);
    }

    public void reset() {
        this._stgLatency.reset();
        this.unregister(this._objectName);
    }

    @Override
    public long getMaxStgLatency() {
        return (long)this._stgLatency.getMax();
    }

    @Override
    public long getMeanStgLatency() {
        return (long)this._stgLatency.getMean();
    }

    @Override
    public long get95StgLatency() {
        return (long)this._stgLatency.getPercentile(95);
    }
}

