/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.impl.cluster;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.cluster.LockExecuteNotifySyncReleaseTemplate;
import org.uberfire.commons.data.Pair;
import org.uberfire.commons.lock.LockExecuteReleaseTemplate;
import org.uberfire.commons.lock.LockService;
import org.uberfire.commons.message.AsyncCallback;
import org.uberfire.commons.message.MessageHandler;
import org.uberfire.commons.message.MessageHandlerResolver;
import org.uberfire.commons.message.MessageType;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceLockable;
import org.uberfire.io.impl.cluster.ClusterMessageType;
import org.uberfire.io.impl.cluster.FileSystemSyncLock;
import org.uberfire.io.impl.cluster.FileSystemSyncNonLock;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.base.FileSystemStateAware;
import org.uberfire.java.nio.base.SeekableByteChannelWrapperImpl;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;

public class IOServiceClusterImpl
implements IOService {
    private static final Logger logger = LoggerFactory.getLogger(IOServiceClusterImpl.class);
    private final IOServiceLockable service;
    private final ClusterService clusterService;
    private final Set<String> batchFileSystems = Collections.newSetFromMap(new ConcurrentHashMap());
    private IOService.NewFileSystemListener newFileSystemListener = null;

    public IOServiceClusterImpl(IOService service, ClusterServiceFactory clusterServiceFactory) {
        this(service, clusterServiceFactory, true);
    }

    public IOServiceClusterImpl(IOService service, ClusterServiceFactory clusterServiceFactory, boolean autoStart) {
        PortablePreconditions.checkNotNull((String)"clusterServiceFactory", (Object)clusterServiceFactory);
        this.service = (IOServiceLockable)Preconditions.checkInstanceOf((String)"service", (Object)service, IOServiceLockable.class);
        logger.debug("Creating instance of cluster service with auto start {}", (Object)autoStart);
        this.clusterService = clusterServiceFactory.build(new MessageHandlerResolver(){
            final MessageHandler newFs;
            final MessageHandler syncFs;
            final MessageHandler queryFs;
            {
                this.newFs = new NewFileSystemMessageHandler();
                this.syncFs = new SyncFileSystemMessageHandler();
                this.queryFs = new QueryFileSystemMessageHandler();
            }

            public String getServiceId() {
                return IOServiceClusterImpl.this.service.getId();
            }

            public MessageHandler resolveHandler(String serviceId, MessageType type) {
                if (serviceId.equals(IOServiceClusterImpl.this.service.getId())) {
                    if (ClusterMessageType.NEW_FS.equals(type)) {
                        return this.newFs;
                    }
                    if (ClusterMessageType.SYNC_FS.equals(type)) {
                        return this.syncFs;
                    }
                    if (ClusterMessageType.QUERY_FOR_FS.equals(type)) {
                        return this.queryFs;
                    }
                }
                return null;
            }
        });
        this.start();
    }

    private void start() {
        logger.debug("Starting IO Cluster service {}", (Object)this);
        new LockExecuteReleaseTemplate().execute((LockService)this.clusterService, new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int timeout = 10000;
                final AtomicBoolean msgAnsweredOrTimedout = new AtomicBoolean(false);
                final AtomicBoolean onSync = new AtomicBoolean(false);
                final HashMap fileSystems = new HashMap();
                IOServiceClusterImpl.this.clusterService.broadcastAndWait(IOServiceClusterImpl.this.service.getId(), (MessageType)ClusterMessageType.QUERY_FOR_FS, Collections.emptyMap(), timeout, new AsyncCallback(){

                    public void onTimeOut() {
                        msgAnsweredOrTimedout.set(true);
                    }

                    public void onReply(MessageType type, final Map<String, String> content) {
                        if (msgAnsweredOrTimedout.get() || onSync.get()) {
                            return;
                        }
                        onSync.set(true);
                        SimpleAsyncExecutorService.getUnmanagedInstance().execute((Runnable)new DescriptiveRunnable(){

                            public String getDescription() {
                                return "Cluster Messaging Reply [" + IOServiceClusterImpl.this.service.getId() + "/QUERY_FOR_FS]";
                            }

                            public void run() {
                                for (Map.Entry entry : content.entrySet()) {
                                    if (!((String)entry.getKey()).startsWith("fs_")) continue;
                                    int index = Integer.valueOf(((String)entry.getKey()).substring(((String)entry.getKey()).lastIndexOf("_") + 1));
                                    if (!fileSystems.containsKey(index)) {
                                        fileSystems.put(index, new FileSystemInfo());
                                    }
                                    FileSystemInfo fsInfo = (FileSystemInfo)fileSystems.get(index);
                                    if (((String)entry.getKey()).startsWith("fs_id_")) {
                                        fsInfo.setId((String)entry.getValue());
                                        continue;
                                    }
                                    if (((String)entry.getKey()).startsWith("fs_scheme_")) {
                                        fsInfo.setScheme((String)entry.getValue());
                                        continue;
                                    }
                                    if (!((String)entry.getKey()).startsWith("fs_uri_")) continue;
                                    fsInfo.setUri((String)entry.getValue());
                                }
                                for (FileSystemInfo fileSystemInfo : new HashSet(fileSystems.values())) {
                                    try {
                                        URI newFS = URI.create(fileSystemInfo.getScheme() + "://" + fileSystemInfo.getId());
                                        IOServiceClusterImpl.this.service.newFileSystem(newFS, Collections.emptyMap());
                                    }
                                    catch (FileSystemAlreadyExistsException ex) {
                                        // empty catch block
                                    }
                                    URI fs = URI.create(fileSystemInfo.getScheme() + "://" + fileSystemInfo.getId() + "?sync=" + fileSystemInfo.getUri().split("\n")[0] + "&force");
                                    IOServiceClusterImpl.this.service.getFileSystem(fs);
                                }
                                msgAnsweredOrTimedout.set(true);
                            }
                        });
                    }
                });
                while (!msgAnsweredOrTimedout.get()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ignored) {}
                }
                return null;
            }
        }));
    }

    @Override
    public void startBatch(FileSystem fs) {
        this.startBatch(new FileSystem[]{fs});
    }

    @Override
    public void startBatch(FileSystem[] fs, Option ... options) {
        this.clusterService.lock();
        for (FileSystem f : fs) {
            if (!(f instanceof FileSystemId)) continue;
            this.batchFileSystems.add(((FileSystemId)f).id());
        }
        this.service.startBatch(fs, options);
    }

    @Override
    public void startBatch(FileSystem fs, Option ... options) {
        this.clusterService.lock();
        if (fs instanceof FileSystemId) {
            this.batchFileSystems.add(((FileSystemId)fs).id());
        }
        this.service.startBatch(fs, options);
    }

    @Override
    public void startBatch(FileSystem ... fs) {
        this.clusterService.lock();
        for (FileSystem f : fs) {
            if (!(f instanceof FileSystemId)) continue;
            this.batchFileSystems.add(((FileSystemId)f).id());
        }
        this.service.startBatch(fs);
    }

    @Override
    public void endBatch() {
        this.service.endBatch();
        if (this.service.getLockControl().getHoldCount() == 0) {
            final AtomicInteger process = new AtomicInteger(this.batchFileSystems.size());
            for (FileSystem fs : this.service.getFileSystems()) {
                if (!(fs instanceof FileSystemId) || !this.batchFileSystems.contains(((FileSystemId)fs).id())) continue;
                try {
                    new FileSystemSyncNonLock<Void>(this.service.getId(), fs).execute(this.clusterService, new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            if (process.decrementAndGet() == 0) {
                                IOServiceClusterImpl.this.clusterService.unlock();
                            }
                            return null;
                        }
                    }));
                }
                catch (Exception ex) {
                    logger.error("End batch error", (Throwable)ex);
                    if (process.decrementAndGet() != 0) continue;
                    this.clusterService.unlock();
                }
            }
            this.batchFileSystems.clear();
        } else {
            this.clusterService.unlock();
        }
    }

    @Override
    public FileAttribute<?>[] convert(Map<String, ?> attrs) {
        return this.service.convert(attrs);
    }

    @Override
    public Path get(String first, String ... more) throws IllegalArgumentException {
        return this.service.get(first, more);
    }

    @Override
    public Path get(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        return this.service.get(uri);
    }

    @Override
    public Iterable<FileSystem> getFileSystems() {
        return this.service.getFileSystems();
    }

    @Override
    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        return this.service.getFileSystem(uri);
    }

    @Override
    public FileSystem newFileSystem(final URI uri, final Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        if (env.containsKey("internal")) {
            return this.service.newFileSystem(uri, env);
        }
        return (FileSystem)new LockExecuteNotifySyncReleaseTemplate<FileSystem>(){

            public MessageType getMessageType() {
                return ClusterMessageType.NEW_FS;
            }

            public String getServiceId() {
                return IOServiceClusterImpl.this.service.getId();
            }

            public Map<String, String> buildContent() {
                return new HashMap<String, String>(){
                    {
                        this.put("uri", uri.toString());
                        for (Map.Entry entry : env.entrySet()) {
                            this.put(entry.getKey(), entry.getValue().toString());
                        }
                    }
                };
            }

            public int timeOut() {
                return TIMEOUT;
            }
        }.execute(this.clusterService, new FutureTask<FileSystem>(new Callable<FileSystem>(){

            @Override
            public FileSystem call() throws Exception {
                return IOServiceClusterImpl.this.service.newFileSystem(uri, new HashMap<String, Object>(env){
                    {
                        this.put("clusterService", IOServiceClusterImpl.this.clusterService);
                    }
                });
            }
        }));
    }

    @Override
    public void onNewFileSystem(IOService.NewFileSystemListener listener) {
        this.newFileSystemListener = listener;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        return this.service.newInputStream(path, options);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        return this.service.newDirectoryStream(dir);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<Path> filter) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException {
        return this.service.newDirectoryStream(dir, filter);
    }

    @Override
    public Path createFile(final Path path, final FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.createFile(path, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.createFile(path, attrs);
            }
        }));
    }

    @Override
    public Path createDirectory(final Path dir, final FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (this.isBatch(dir.getFileSystem())) {
            return this.service.createDirectory(dir, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), dir.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.createDirectory(dir, attrs);
            }
        }));
    }

    @Override
    public Path createDirectories(final Path dir, final FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (this.isBatch(dir.getFileSystem())) {
            return this.service.createDirectories(dir, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), dir.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.createDirectories(dir, attrs);
            }
        }));
    }

    @Override
    public Path createDirectory(final Path dir, final Map<String, ?> attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (this.isBatch(dir.getFileSystem())) {
            return this.service.createDirectory(dir, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), dir.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.createDirectory(dir, attrs);
            }
        }));
    }

    @Override
    public Path createDirectories(final Path dir, final Map<String, ?> attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        if (this.isBatch(dir.getFileSystem())) {
            return this.service.createDirectories(dir, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), dir.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.createDirectories(dir, attrs);
            }
        }));
    }

    @Override
    public void delete(final Path path, final DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            this.service.delete(path, options);
        } else {
            new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    IOServiceClusterImpl.this.service.delete(path, options);
                    return null;
                }
            }));
        }
    }

    @Override
    public boolean deleteIfExists(final Path path, final DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.deleteIfExists(path, options);
        }
        return (Boolean)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return IOServiceClusterImpl.this.service.deleteIfExists(path, options);
            }
        }));
    }

    @Override
    public Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.service.createTempFile(prefix, suffix, attrs);
    }

    @Override
    public Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.service.createTempFile(dir, prefix, suffix, attrs);
    }

    @Override
    public Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.service.createTempDirectory(prefix, attrs);
    }

    @Override
    public Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.service.createTempDirectory(dir, prefix, attrs);
    }

    @Override
    public Path copy(final Path source, final Path target, final CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        if (this.isBatch(source.getFileSystem())) {
            return this.service.copy(source, target, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), target.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.copy(source, target, options);
            }
        }));
    }

    @Override
    public long copy(final InputStream in, final Path target, final CopyOption ... options) throws IOException, FileAlreadyExistsException, DirectoryNotEmptyException, UnsupportedOperationException, SecurityException {
        if (this.isBatch(target.getFileSystem())) {
            return this.service.copy(in, target, options);
        }
        return (Long)new FileSystemSyncLock(this.service.getId(), target.getFileSystem()).execute(this.clusterService, new FutureTask<Long>(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return IOServiceClusterImpl.this.service.copy(in, target, options);
            }
        }));
    }

    @Override
    public long copy(Path source, OutputStream out) throws IOException, SecurityException {
        return this.service.copy(source, out);
    }

    @Override
    public Path move(final Path source, final Path target, final CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        if (this.isBatch(source.getFileSystem())) {
            return this.service.move(source, target, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), source.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return (Path)new FileSystemSyncLock(IOServiceClusterImpl.this.service.getId(), target.getFileSystem()).execute(IOServiceClusterImpl.this.clusterService, new FutureTask<Path>(new Callable<Path>(){

                    @Override
                    public Path call() throws Exception {
                        return IOServiceClusterImpl.this.service.move(source, target, options);
                    }
                }));
            }
        }));
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type) throws IllegalArgumentException {
        return this.service.getFileAttributeView(path, type);
    }

    @Override
    public Map<String, Object> readAttributes(Path path) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException {
        return this.service.readAttributes(path);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException {
        return this.service.readAttributes(path, attributes);
    }

    @Override
    public Path setAttributes(final Path path, final FileAttribute<?> ... attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.setAttributes(path, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.setAttributes(path, attrs);
            }
        }));
    }

    @Override
    public Path setAttributes(final Path path, final Map<String, Object> attrs) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.setAttributes(path, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.setAttributes(path, attrs);
            }
        }));
    }

    @Override
    public Path setAttribute(final Path path, final String attribute, final Object value) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.setAttribute(path, attribute, value);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.setAttribute(path, attribute, value);
            }
        }));
    }

    @Override
    public Object getAttribute(Path path, String attribute) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        return this.service.getAttribute(path, attribute);
    }

    @Override
    public FileTime getLastModifiedTime(Path path) throws IllegalArgumentException, IOException, SecurityException {
        return this.service.getLastModifiedTime(path);
    }

    @Override
    public long size(Path path) throws IllegalArgumentException, IOException, SecurityException {
        return this.service.size(path);
    }

    @Override
    public boolean exists(Path path) throws IllegalArgumentException, SecurityException {
        return this.service.exists(path);
    }

    @Override
    public boolean notExists(Path path) throws IllegalArgumentException, SecurityException {
        return this.service.notExists(path);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IllegalArgumentException, IOException, SecurityException {
        return this.service.isSameFile(path, path2);
    }

    @Override
    public BufferedReader newBufferedReader(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        return this.service.newBufferedReader(path, cs);
    }

    @Override
    public byte[] readAllBytes(Path path) throws IOException, OutOfMemoryError, SecurityException {
        return this.service.readAllBytes(path);
    }

    @Override
    public List<String> readAllLines(Path path) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        return this.service.readAllLines(path);
    }

    @Override
    public List<String> readAllLines(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        return this.service.readAllLines(path, cs);
    }

    @Override
    public String readAllString(Path path, Charset cs) throws IllegalArgumentException, NoSuchFileException, IOException {
        return this.service.readAllString(path, cs);
    }

    @Override
    public String readAllString(Path path) throws IllegalArgumentException, NoSuchFileException, IOException {
        return this.service.readAllString(path);
    }

    @Override
    public Path write(final Path path, final byte[] bytes, final OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, bytes, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, bytes, options);
            }
        }));
    }

    @Override
    public Path write(final Path path, final byte[] bytes, final Map<String, ?> attrs, final OpenOption ... options) throws IOException, UnsupportedOperationException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, bytes, attrs, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, bytes, attrs, options);
            }
        }));
    }

    @Override
    public Path write(final Path path, final byte[] bytes, final Set<? extends OpenOption> options, final FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, bytes, options, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, bytes, (Set<? extends OpenOption>)options, attrs);
            }
        }));
    }

    @Override
    public Path write(final Path path, final Iterable<? extends CharSequence> lines, final Charset cs, final OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, lines, cs, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, lines, cs, options);
            }
        }));
    }

    @Override
    public Path write(final Path path, final String content, final OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, content, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, content, options);
            }
        }));
    }

    @Override
    public Path write(final Path path, final String content, final Charset cs, final OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, content, cs, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, content, cs, options);
            }
        }));
    }

    @Override
    public Path write(final Path path, final String content, final Set<? extends OpenOption> options, final FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, content, options, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, content, (Set<? extends OpenOption>)options, attrs);
            }
        }));
    }

    @Override
    public Path write(final Path path, final String content, final Charset cs, final Set<? extends OpenOption> options, final FileAttribute<?> ... attrs) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, content, cs, options, attrs);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, content, cs, options, attrs);
            }
        }));
    }

    @Override
    public Path write(final Path path, final String content, final Map<String, ?> attrs, final OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, content, attrs, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, content, attrs, options);
            }
        }));
    }

    @Override
    public Path write(final Path path, final String content, final Charset cs, final Map<String, ?> attrs, final OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (this.isBatch(path.getFileSystem())) {
            return this.service.write(path, content, cs, attrs, options);
        }
        return (Path)new FileSystemSyncLock(this.service.getId(), path.getFileSystem()).execute(this.clusterService, new FutureTask<Path>(new Callable<Path>(){

            @Override
            public Path call() throws Exception {
                return IOServiceClusterImpl.this.service.write(path, content, cs, attrs, options);
            }
        }));
    }

    @Override
    public OutputStream newOutputStream(final Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        final OutputStream out = this.service.newOutputStream(path, options);
        return new OutputStream(){

            @Override
            public void write(int b) throws java.io.IOException {
                out.write(b);
            }

            @Override
            public void close() throws java.io.IOException {
                if (IOServiceClusterImpl.this.isBatch(path.getFileSystem())) {
                    out.close();
                } else {
                    new FileSystemSyncLock(IOServiceClusterImpl.this.service.getId(), path.getFileSystem()).execute(IOServiceClusterImpl.this.clusterService, new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            out.close();
                            return null;
                        }
                    }));
                }
            }
        };
    }

    @Override
    public SeekableByteChannel newByteChannel(final Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        final SeekableByteChannel sbc = this.service.newByteChannel(path, options);
        return new SeekableByteChannelWrapperImpl(sbc){

            public void close() throws java.io.IOException {
                if (IOServiceClusterImpl.this.isBatch(path.getFileSystem())) {
                    sbc.close();
                } else {
                    new FileSystemSyncLock(IOServiceClusterImpl.this.service.getId(), path.getFileSystem()).execute(IOServiceClusterImpl.this.clusterService, new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            sbc.close();
                            return null;
                        }
                    }));
                }
            }
        };
    }

    @Override
    public SeekableByteChannel newByteChannel(final Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        final SeekableByteChannel sbc = this.service.newByteChannel(path, options, attrs);
        return new SeekableByteChannelWrapperImpl(sbc){

            public void close() throws java.io.IOException {
                if (IOServiceClusterImpl.this.isBatch(path.getFileSystem())) {
                    sbc.close();
                } else {
                    new FileSystemSyncLock(IOServiceClusterImpl.this.service.getId(), path.getFileSystem()).execute(IOServiceClusterImpl.this.clusterService, new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            sbc.close();
                            return null;
                        }
                    }));
                }
            }
        };
    }

    @Override
    public BufferedWriter newBufferedWriter(final Path path, Charset cs, OpenOption ... options) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException {
        return new BufferedWriter(this.service.newBufferedWriter(path, cs, options)){

            @Override
            public void close() throws java.io.IOException {
                if (IOServiceClusterImpl.this.isBatch(path.getFileSystem())) {
                    this.superClose();
                } else {
                    new FileSystemSyncLock(IOServiceClusterImpl.this.service.getId(), path.getFileSystem()).execute(IOServiceClusterImpl.this.clusterService, new FutureTask<Void>(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            this.superClose();
                            return null;
                        }
                    }));
                }
            }

            private void superClose() {
                try {
                    super.close();
                }
                catch (java.io.IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private boolean isBatch(FileSystem fs) {
        return fs instanceof FileSystemStateAware && ((FileSystemStateAware)fs).getState().equals((Object)FileSystemState.BATCH);
    }

    public void dispose() {
        this.service.dispose();
    }

    public int priority() {
        return this.service.priority() - 1;
    }

    static class FileSystemInfo {
        private String id;
        private String scheme;
        private String uri;

        FileSystemInfo() {
        }

        FileSystemInfo(String id, String scheme, String uri) {
            this.id = id;
            this.scheme = scheme;
            this.uri = uri;
        }

        String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        String getScheme() {
            return this.scheme;
        }

        void setScheme(String scheme) {
            this.scheme = scheme;
        }

        String getUri() {
            return this.uri;
        }

        void setUri(String uri) {
            this.uri = uri;
        }
    }

    class QueryFileSystemMessageHandler
    implements MessageHandler {
        QueryFileSystemMessageHandler() {
        }

        public Pair<MessageType, Map<String, String>> handleMessage(MessageType type, Map<String, String> content) {
            if (ClusterMessageType.QUERY_FOR_FS.equals(type)) {
                HashMap<String, String> replyContent = new HashMap<String, String>();
                int i = 0;
                HashSet<FileSystem> fileSystems = new HashSet<FileSystem>();
                for (FileSystem fs : IOServiceClusterImpl.this.service.getFileSystems()) {
                    fileSystems.add(fs);
                }
                for (FileSystem fs : fileSystems) {
                    replyContent.put("fs_scheme_" + i, ((Path)fs.getRootDirectories().iterator().next()).toUri().getScheme());
                    replyContent.put("fs_id_" + i, ((FileSystemId)fs).id());
                    replyContent.put("fs_uri_" + i, fs.toString());
                    ++i;
                }
                return new Pair((Object)ClusterMessageType.QUERY_FOR_FS_RESULT, replyContent);
            }
            return null;
        }
    }

    class SyncFileSystemMessageHandler
    implements MessageHandler {
        SyncFileSystemMessageHandler() {
        }

        public Pair<MessageType, Map<String, String>> handleMessage(MessageType type, Map<String, String> content) {
            if (ClusterMessageType.SYNC_FS.equals(type)) {
                String[] supportedUris;
                String scheme = content.get("fs_scheme");
                String id = content.get("fs_id");
                for (String supportedUri : supportedUris = this.cleanup(content.get("fs_uri").split("\n"))) {
                    try {
                        String origin;
                        try {
                            origin = URLEncoder.encode(supportedUri, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            origin = supportedUri;
                        }
                        URI fs = URI.create(scheme + "://" + id + "?sync=" + origin + "&force");
                        IOServiceClusterImpl.this.service.getFileSystem(fs);
                        break;
                    }
                    catch (Exception e) {
                        logger.warn("File system synchronization for origin {} failed with error {}, trying another if available", (Object)supportedUri, (Object)e.getMessage());
                    }
                }
            }
            return null;
        }

        private String[] cleanup(String ... split) {
            ArrayList<String> result = new ArrayList<String>(split.length);
            for (String s : split) {
                if (!s.startsWith("git://")) continue;
                result.add(s);
            }
            return result.toArray(new String[result.size()]);
        }
    }

    class NewFileSystemMessageHandler
    implements MessageHandler {
        NewFileSystemMessageHandler() {
        }

        public Pair<MessageType, Map<String, String>> handleMessage(MessageType type, Map<String, String> content) {
            if (ClusterMessageType.NEW_FS.equals(type)) {
                String _uri = content.get("uri");
                HashMap<String, String> env = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : content.entrySet()) {
                    if (entry.getKey().equals("uri") || entry.getKey().equals("type")) continue;
                    env.put(entry.getKey(), entry.getValue());
                }
                URI uri = URI.create(_uri);
                FileSystem fs = IOServiceClusterImpl.this.service.newFileSystem(uri, env);
                if (IOServiceClusterImpl.this.newFileSystemListener != null) {
                    IOServiceClusterImpl.this.newFileSystemListener.execute(fs, uri.getScheme(), ((FileSystemId)fs).id(), env);
                }
            }
            return null;
        }
    }
}

