/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.api.FormProviderService;
import org.jbpm.kie.services.impl.form.FormProvider;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormProviderServiceImpl
implements FormProviderService {
    private static Logger logger = LoggerFactory.getLogger(FormProviderServiceImpl.class);
    private TaskService taskService;
    private DefinitionService bpmn2Service;
    private RuntimeDataService dataService;
    private DeploymentService deploymentService;
    private Set<FormProvider> providers;

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setBpmn2Service(DefinitionService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public void setDataService(RuntimeDataService dataService) {
        this.dataService = dataService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setProviders(Set<FormProvider> providers) {
        this.providers = providers;
    }

    @Override
    public String getFormDisplayProcess(String deploymentId, String processId) {
        ProcessDefinition processDesc = this.dataService.getProcessesByDeploymentIdProcessId(deploymentId, processId);
        HashMap processData = this.bpmn2Service.getProcessVariables(deploymentId, processId);
        if (processData == null) {
            processData = new HashMap();
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        renderContext.put("marshallerContext", this.getMarshallerContext(deploymentId, processId));
        for (FormProvider provider : this.providers) {
            String template = provider.render(processDesc.getName(), processDesc, renderContext);
            if (StringUtils.isEmpty((CharSequence)template)) continue;
            return template;
        }
        logger.warn("Unable to find form to render for process '{}'", (Object)processDesc.getName());
        return "";
    }

    @Override
    public String getFormDisplayTask(long taskId) {
        Task task = this.taskService.getTaskById(taskId);
        if (task == null) {
            return "";
        }
        String name = task.getName();
        ProcessDefinition processDesc = this.dataService.getProcessesByDeploymentIdProcessId(task.getTaskData().getDeploymentId(), task.getTaskData().getProcessId());
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        ContentMarshallerContext marshallerContext = this.getMarshallerContext(task);
        Object input = null;
        long inputContentId = task.getTaskData().getDocumentContentId();
        if (inputContentId != -1L) {
            Content content = this.taskService.getContentById(inputContentId);
            input = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)marshallerContext.getEnvironment(), (ClassLoader)marshallerContext.getClassloader());
        }
        if (input == null) {
            input = new HashMap();
        }
        Object output = null;
        long outputContentId = task.getTaskData().getOutputContentId();
        if (outputContentId != -1L) {
            Content content = this.taskService.getContentById(outputContentId);
            output = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)marshallerContext.getEnvironment(), (ClassLoader)marshallerContext.getClassloader());
        }
        if (output == null) {
            output = new HashMap();
        }
        String processId = task.getTaskData().getProcessId();
        HashMap finalOutput = new HashMap();
        if (processId != null && !processId.equals("")) {
            HashMap taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(task.getTaskData().getDeploymentId(), processId, task.getName());
            if (taskOutputMappings == null) {
                taskOutputMappings = new HashMap();
            }
            for (String key : taskOutputMappings.values()) {
                Object value = ((Map)output).get(key);
                if (value == null) {
                    value = "";
                }
                finalOutput.put(key, value);
            }
        } else if (output instanceof Map && !((Map)output).isEmpty()) {
            finalOutput.putAll((Map)output);
        }
        renderContext.put("task", task);
        renderContext.put("marshallerContext", marshallerContext);
        if (input instanceof Map) {
            renderContext.put("inputs", input);
            for (Map.Entry inputVar : ((Map)input).entrySet()) {
                renderContext.put((String)inputVar.getKey(), inputVar.getValue());
            }
        } else {
            renderContext.put("input", input);
        }
        renderContext.put("outputs", finalOutput);
        for (Map.Entry outputVar : finalOutput.entrySet()) {
            renderContext.put((String)outputVar.getKey(), outputVar.getValue());
        }
        for (FormProvider provider : this.providers) {
            String template = provider.render(name, task, processDesc, renderContext);
            if (StringUtils.isEmpty((CharSequence)template)) continue;
            return template;
        }
        logger.warn("Unable to find form to render for task '{}' on process '{}'", (Object)name, (Object)processDesc.getName());
        return "";
    }

    protected ContentMarshallerContext getMarshallerContext(String deploymentId, String processId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            return new ContentMarshallerContext();
        }
        InternalRuntimeManager manager = (InternalRuntimeManager)deployedUnit.getRuntimeManager();
        return new ContentMarshallerContext(manager.getEnvironment().getEnvironment(), manager.getEnvironment().getClassLoader());
    }

    protected ContentMarshallerContext getMarshallerContext(Task task) {
        if (task == null) {
            return new ContentMarshallerContext();
        }
        return TaskContentRegistry.get().getMarshallerContext(task);
    }
}

