/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.adapter;

import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.uberfire.security.authz.adapter.GroupsAdapter;

public class GroupAdapterAuthorizationSource {
    private final ServiceLoader<GroupsAdapter> groupsAdapterServiceLoader = ServiceLoader.load(GroupsAdapter.class);

    public Set<Group> collectGroups(String name) {
        HashSet<Group> userGroups = new HashSet<Group>();
        for (GroupsAdapter adapter : this.groupsAdapterServiceLoader) {
            List groupRoles = adapter.getGroups(name, null);
            if (groupRoles == null) continue;
            userGroups.addAll(groupRoles);
        }
        return userGroups;
    }

    public Set<Role> collectGroupsAsRoles(String name, Object subject) {
        HashSet<Role> userGroups = new HashSet<Role>();
        for (GroupsAdapter adapter : this.groupsAdapterServiceLoader) {
            List groupRoles = adapter.getGroups(name, subject);
            if (groupRoles == null) continue;
            for (Group group : groupRoles) {
                userGroups.add((Role)new RoleImpl(group.getName()));
            }
        }
        return userGroups;
    }
}

