/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.util.Encode;

public abstract class BaseHttpRequest
implements HttpRequest {
    protected CountDownLatch latch;
    protected long suspendTimeout;
    protected SynchronousDispatcher dispatcher;
    protected boolean suspended;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected AbstractAsynchronousResponse asynchronousResponse;
    protected HttpResponse httpResponse;

    public BaseHttpRequest(SynchronousDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm(this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException(Messages.MESSAGES.requestMediaTypeNotUrlencoded());
        }
        return this.formParameters;
    }

    @Override
    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    @Override
    public AsynchronousResponse createAsynchronousResponse(long suspendTimeout) {
        this.suspended = true;
        this.latch = new CountDownLatch(1);
        this.suspendTimeout = suspendTimeout;
        this.asynchronousResponse = new AbstractAsynchronousResponse(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setResponse(Response response) {
                try {
                    this.setupResponse((ServerResponse)response);
                    BaseHttpRequest.this.dispatcher.asynchronousDelivery((HttpRequest)BaseHttpRequest.this, BaseHttpRequest.this.httpResponse, response);
                }
                finally {
                    BaseHttpRequest.this.latch.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFailure(Exception ex) {
                try {
                    BaseHttpRequest.this.dispatcher.asynchronousDelivery((HttpRequest)BaseHttpRequest.this, BaseHttpRequest.this.httpResponse, ex);
                }
                finally {
                    BaseHttpRequest.this.latch.countDown();
                }
            }
        };
        return this.asynchronousResponse;
    }

    @Override
    public AsynchronousResponse getAsynchronousResponse() {
        return this.asynchronousResponse;
    }

    @Override
    public boolean isInitial() {
        return true;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public void initialRequestThreadFinished() {
        if (this.latch == null) {
            return;
        }
        try {
            this.latch.await(this.suspendTimeout + 100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

