/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.LinkedFilter;
import org.guvnor.common.services.backend.file.LinkedRegularFileFilter;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.kie.workbench.common.screens.explorer.backend.server.FolderListingResolver;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerData;
import org.kie.workbench.common.screens.explorer.backend.server.UserExplorerLastData;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.kie.workbench.common.screens.explorer.model.FolderListing;
import org.kie.workbench.common.screens.explorer.service.Option;
import org.kie.workbench.common.screens.explorer.utils.Sorters;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.UserServicesImpl;
import org.uberfire.backend.server.VFSLockServiceImpl;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class ExplorerServiceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplorerServiceHelper.class);
    @Inject
    private KieProjectService projectService;
    @Inject
    private FolderListingResolver folderListingResolver;
    private LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter();
    private LinkedRegularFileFilter regularFileFilter = new LinkedRegularFileFilter((LinkedFilter)this.dotFileFilter);
    private XStream xs = new XStream();
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    @Named(value="configIO")
    private IOService ioServiceConfig;
    @Inject
    private VFSLockServiceImpl lockService;
    @Inject
    private UserServicesImpl userServices;

    public static FolderItem toFolderItem(Package pkg) {
        if (pkg == null) {
            return null;
        }
        return new FolderItem((Object)pkg, pkg.getRelativeCaption(), FolderItemType.FOLDER);
    }

    public static FolderItem toFolderItem(Path path) {
        if (Files.isRegularFile((Path)path, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path p = Paths.convert((Path)path);
            return new FolderItem((Object)p, p.getFileName(), FolderItemType.FILE, false, Paths.readLockedBy((org.uberfire.backend.vfs.Path)p));
        }
        if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path p = Paths.convert((Path)path);
            return new FolderItem((Object)p, p.getFileName(), FolderItemType.FOLDER);
        }
        return null;
    }

    public List<FolderItem> getPackageSegments(Package _pkg) {
        ArrayList<FolderItem> result = new ArrayList<FolderItem>();
        Package pkg = _pkg;
        while (pkg != null) {
            Package parent = this.projectService.resolveParentPackage(pkg);
            if (parent != null) {
                result.add(ExplorerServiceHelper.toFolderItem(parent));
            }
            pkg = parent;
        }
        return Lists.reverse(result);
    }

    public FolderListing getFolderListing(FolderItem selectedItem, Project selectedProject, Package selectedPackage, Set<Option> options) {
        return this.folderListingResolver.resolve(selectedItem, selectedProject, selectedPackage, this, options);
    }

    public FolderListing getFolderListing(Package pkg) {
        return new FolderListing(ExplorerServiceHelper.toFolderItem(pkg), this.getItems(pkg), this.getPackageSegments(pkg));
    }

    public FolderListing getFolderListing(FolderItem item) {
        FolderListing result = null;
        if (item.getItem() instanceof org.uberfire.backend.vfs.Path) {
            result = this.getFolderListing((org.uberfire.backend.vfs.Path)item.getItem());
        } else if (item.getItem() instanceof Package) {
            result = this.getFolderListing((Package)item.getItem());
        }
        return result;
    }

    public FolderListing getFolderListing(org.uberfire.backend.vfs.Path path) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        while (!Files.exists((Path)nioPath, (LinkOption[])new LinkOption[0])) {
            nioPath = nioPath.getParent();
        }
        org.uberfire.backend.vfs.Path basePath = Paths.convert((Path)nioPath);
        DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPath, (DirectoryStream.Filter)this.dotFileFilter);
        for (Path np : nioPaths) {
            FolderItem folderItem;
            org.uberfire.backend.vfs.Path p;
            if (Files.isRegularFile((Path)np, (LinkOption[])new LinkOption[0])) {
                p = Paths.convert((Path)np);
                String lockedBy = Paths.readLockedBy((org.uberfire.backend.vfs.Path)p);
                folderItem = new FolderItem((Object)p, p.getFileName(), FolderItemType.FILE, false, lockedBy);
                folderItems.add(folderItem);
                continue;
            }
            if (!Files.isDirectory((Path)np, (LinkOption[])new LinkOption[0])) continue;
            p = Paths.convert((Path)np);
            boolean lockedItems = !this.lockService.retrieveLockInfos(Paths.convert((Path)np), true).isEmpty();
            folderItem = new FolderItem((Object)p, p.getFileName(), FolderItemType.FOLDER, lockedItems, null);
            folderItems.add(folderItem);
        }
        Collections.sort(folderItems, Sorters.ITEM_SORTER);
        return new FolderListing(ExplorerServiceHelper.toFolderItem(nioPath), folderItems, this.getPathSegments(basePath));
    }

    public List<FolderItem> getItems(Package pkg) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        if (pkg == null) {
            return Collections.emptyList();
        }
        Set childPackages = this.projectService.resolvePackages(pkg);
        for (Package childPackage : childPackages) {
            folderItems.add(ExplorerServiceHelper.toFolderItem(childPackage));
        }
        folderItems.addAll(this.getItems(pkg.getPackageMainSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestSrcPath()));
        folderItems.addAll(this.getItems(pkg.getPackageMainResourcesPath()));
        folderItems.addAll(this.getItems(pkg.getPackageTestResourcesPath()));
        Collections.sort(folderItems, Sorters.ITEM_SORTER);
        return folderItems;
    }

    private List<FolderItem> getPathSegments(org.uberfire.backend.vfs.Path path) {
        Path nioSegmentPath = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent();
        int segmentCount = nioSegmentPath.getNameCount();
        if (segmentCount < 1) {
            return new ArrayList<FolderItem>();
        }
        FolderItem[] segments = new FolderItem[segmentCount];
        for (int idx = segmentCount; idx > 0; --idx) {
            segments[idx - 1] = ExplorerServiceHelper.toFolderItem(nioSegmentPath);
            nioSegmentPath = nioSegmentPath.getParent();
        }
        return Arrays.asList(segments);
    }

    private List<FolderItem> getItems(org.uberfire.backend.vfs.Path packagePath) {
        ArrayList<FolderItem> folderItems = new ArrayList<FolderItem>();
        Path nioPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)packagePath);
        if (Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream nioPaths = this.ioService.newDirectoryStream(nioPackagePath, (DirectoryStream.Filter)this.regularFileFilter);
            for (Path nioPath : nioPaths) {
                org.uberfire.backend.vfs.Path path = Paths.convert((Path)nioPath);
                if (Paths.isLock((org.uberfire.backend.vfs.Path)path)) continue;
                String lockedBy = Paths.readLockedBy((org.uberfire.backend.vfs.Path)path);
                FolderItem folderItem = new FolderItem((Object)path, path.getFileName(), FolderItemType.FILE, false, lockedBy);
                folderItems.add(folderItem);
            }
        }
        return folderItems;
    }

    public void store(OrganizationalUnit selectedOrganizationalUnit, Repository selectedRepository, Project selectedProject, FolderListing folderListing, Package selectedPackage, Set<Option> options) {
        final Path userNavPath = this.userServices.buildPath("explorer", "user.nav");
        final Path lastUserNavPath = this.userServices.buildPath("explorer", "last.user.nav");
        final OrganizationalUnit _selectedOrganizationalUnit = selectedOrganizationalUnit;
        final Repository _selectedRepository = selectedRepository;
        final Project _selectedProject = selectedProject;
        FolderItem _selectedItem = folderListing.getItem();
        Object _selectedPackage = selectedPackage != null ? selectedPackage : (folderListing.getItem().getItem() instanceof Package ? (Package)folderListing.getItem().getItem() : null);
        SimpleAsyncExecutorService.getDefaultInstance().execute((Runnable)new DescriptiveRunnable((Package)_selectedPackage, _selectedItem, options){
            final /* synthetic */ Package val$_selectedPackage;
            final /* synthetic */ FolderItem val$_selectedItem;
            final /* synthetic */ Set val$options;
            {
                this.val$_selectedPackage = package_;
                this.val$_selectedItem = folderItem;
                this.val$options = set;
            }

            public String getDescription() {
                return "Serialize Navigation State";
            }

            public void run() {
                try {
                    ExplorerServiceHelper.this.store(userNavPath, lastUserNavPath, _selectedOrganizationalUnit, _selectedRepository, _selectedProject, this.val$_selectedPackage, this.val$_selectedItem, this.val$options);
                }
                catch (Exception e) {
                    LOGGER.error("Can't serialize user's state navigation", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Path userNav, Path lastUserNav, OrganizationalUnit organizationalUnit, Repository repository, Project project, Package pkg, FolderItem item, Set<Option> options) {
        UserExplorerData _content = this.loadUserContent(userNav);
        UserExplorerData content = _content == null ? new UserExplorerData() : _content;
        UserExplorerLastData lastContent = new UserExplorerLastData();
        if (organizationalUnit != null) {
            content.setOrganizationalUnit(organizationalUnit);
        }
        if (repository != null && organizationalUnit != null) {
            content.addRepository(organizationalUnit, repository);
        }
        if (project != null && organizationalUnit != null && repository != null) {
            content.addProject(organizationalUnit, repository, project);
        }
        if (item != null && organizationalUnit != null && repository != null && project != null) {
            lastContent.setFolderItem(organizationalUnit, repository, project, item);
            content.addFolderItem(organizationalUnit, repository, project, item);
        }
        if (pkg != null && organizationalUnit != null && repository != null && project != null) {
            lastContent.setPackage(organizationalUnit, repository, project, pkg);
            content.addPackage(organizationalUnit, repository, project, pkg);
        }
        if (options != null && !options.isEmpty()) {
            lastContent.setOptions(options);
        }
        if (!content.isEmpty()) {
            try {
                this.ioServiceConfig.startBatch(userNav.getFileSystem());
                this.ioServiceConfig.write(userNav, this.xs.toXML((Object)content), new OpenOption[0]);
                this.ioServiceConfig.write(lastUserNav, this.xs.toXML((Object)lastContent), new OpenOption[0]);
            }
            finally {
                this.ioServiceConfig.endBatch();
            }
        }
    }

    public UserExplorerData loadUserContent(Path path) {
        try {
            if (this.ioServiceConfig.exists(path)) {
                String xml = this.ioServiceConfig.readAllString(path);
                return (UserExplorerData)this.xs.fromXML(xml);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public UserExplorerData loadUserContent() {
        UserExplorerData userExplorerData = this.loadUserContent(this.userServices.buildPath("explorer", "user.nav"));
        if (userExplorerData != null) {
            return userExplorerData;
        }
        return new UserExplorerData();
    }

    public UserExplorerLastData getLastContent() {
        try {
            UserExplorerLastData lastData = this.getLastContent(this.userServices.buildPath("explorer", "last.user.nav"));
            if (lastData != null) {
                return lastData;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new UserExplorerLastData();
    }

    public UserExplorerLastData getLastContent(Path path) {
        try {
            if (this.ioServiceConfig.exists(path)) {
                String xml = this.ioServiceConfig.readAllString(path);
                return (UserExplorerLastData)this.xs.fromXML(xml);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

