/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.helpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.kie.api.builder.ReleaseId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomModelResolver {
    private static final Logger log = LoggerFactory.getLogger(PomModelResolver.class);

    public static PomModel resolveFromJar(InputStream jarStream) {
        PomModel pomModel = null;
        try {
            String pomXML = GuvnorM2Repository.loadPomFromJar(jarStream);
            if (pomXML != null) {
                pomModel = PomModel.Parser.parse((String)"pom.xml", (InputStream)new ByteArrayInputStream(pomXML.getBytes()));
            }
        }
        catch (Exception e) {
            log.info("Failed to parse pom.xml for GAV information. Falling back to pom.properties.", (Throwable)e);
        }
        if (pomModel == null) {
            try {
                ReleaseId releaseId;
                jarStream.reset();
                String pomProperties = GuvnorM2Repository.loadPomPropertiesFromJar(jarStream);
                if (pomProperties != null && (releaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties)) != null) {
                    pomModel = new PomModel.InternalModel();
                    ((PomModel.InternalModel)pomModel).setReleaseId(releaseId);
                }
            }
            catch (Exception e) {
                log.info("Failed to parse pom.properties for GAV information.");
            }
        }
        return pomModel;
    }

    public static PomModel resolveFromPom(InputStream pomStream) {
        PomModel pomModel = null;
        try {
            pomModel = PomModel.Parser.parse((String)"pom.xml", (InputStream)pomStream);
        }
        catch (Exception e) {
            log.info("Failed to parse pom.xml for GAV information.", (Throwable)e);
        }
        return pomModel;
    }
}

