/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.builder.Message;
import org.kie.workbench.common.services.backend.builder.BaseFileNameResolver;
import org.kie.workbench.common.services.backend.builder.Handles;
import org.uberfire.backend.vfs.Path;

class MessageConverter {
    MessageConverter() {
    }

    static List<BuildMessage> convertMessages(List<Message> messages, Handles handles) {
        ArrayList<BuildMessage> result = new ArrayList<BuildMessage>();
        if (messages != null && !messages.isEmpty()) {
            for (Message message : messages) {
                result.add(MessageConverter.convertMessage(message, handles));
            }
        }
        return result;
    }

    static List<BuildMessage> convertValidationMessages(List<ValidationMessage> validationMessages) {
        ArrayList<BuildMessage> result = new ArrayList<BuildMessage>();
        if (validationMessages != null && !validationMessages.isEmpty()) {
            for (ValidationMessage validationMessage : validationMessages) {
                result.add(MessageConverter.convertValidationMessage(validationMessage));
            }
        }
        return result;
    }

    static BuildMessage convertValidationMessage(ValidationMessage message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        m.setPath(message.getPath());
        return m;
    }

    static BuildMessage convertMessage(Message message, Handles handles) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        m.setPath(MessageConverter.convertPath(message.getPath(), handles));
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        return m;
    }

    private static Path convertPath(String kieBuilderPath, Handles handles) {
        if (kieBuilderPath == null || kieBuilderPath.isEmpty()) {
            return null;
        }
        Path path = handles.get("src/main/resources/" + BaseFileNameResolver.getBaseFileName(kieBuilderPath));
        if (path == null) {
            path = handles.get(BaseFileNameResolver.getBaseFileName(kieBuilderPath));
        }
        return path;
    }
}

